/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.v53.impl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hibernate.cache.cfg.spi.CollectionDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataCachingConfig;
import org.hibernate.cache.cfg.spi.DomainDataRegionConfig;
import org.hibernate.cache.cfg.spi.EntityDataCachingConfig;
import org.hibernate.cache.cfg.spi.NaturalIdDataCachingConfig;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.DomainDataRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.functional.MetaParam;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.TimeSource;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.LockingInterceptor;
import org.infinispan.hibernate.cache.commons.access.PutFromLoadValidator;
import org.infinispan.hibernate.cache.commons.access.UnorderedDistributionInterceptor;
import org.infinispan.hibernate.cache.commons.access.UnorderedReplicationLogic;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;
import org.infinispan.hibernate.cache.v53.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.v53.impl.BaseRegionImpl;
import org.infinispan.hibernate.cache.v53.impl.CollectionDataAccessImpl;
import org.infinispan.hibernate.cache.v53.impl.NonStrictAccessDelegate;
import org.infinispan.hibernate.cache.v53.impl.NonTxInvalidationCacheAccessDelegate;
import org.infinispan.hibernate.cache.v53.impl.ReadOnlyEntityDataAccess;
import org.infinispan.hibernate.cache.v53.impl.ReadOnlyNaturalDataAccess;
import org.infinispan.hibernate.cache.v53.impl.ReadWriteEntityDataAccess;
import org.infinispan.hibernate.cache.v53.impl.ReadWriteNaturalDataAccess;
import org.infinispan.hibernate.cache.v53.impl.TombstoneAccessDelegate;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;

public class DomainDataRegionImpl
extends BaseRegionImpl
implements DomainDataRegion,
InfinispanDataRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(DomainDataRegionImpl.class);
    private final CacheKeysFactory cacheKeysFactory;
    private final DomainDataRegionConfig config;
    private final AdvancedCache<Object, Object> localCache;
    private final Map<String, Comparator<Object>> comparatorsByType = new HashMap<String, Comparator<Object>>();
    private long tombstoneExpiration;
    private PutFromLoadValidator validator;
    private Strategy strategy;
    private MetaParam.MetaLifespan expiringMetaParam;

    public DomainDataRegionImpl(AdvancedCache cache, DomainDataRegionConfig config, InfinispanRegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, config.getRegionName(), factory);
        this.config = config;
        this.cacheKeysFactory = cacheKeysFactory;
        this.localCache = cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL});
        this.tombstoneExpiration = factory.getPendingPutsCacheConfiguration().expiration().maxIdle();
        this.expiringMetaParam = new MetaParam.MetaLifespan(this.tombstoneExpiration);
    }

    public EntityDataAccess getEntityDataAccess(NavigableRole rootEntityRole) {
        EntityDataCachingConfig entityConfig = (EntityDataCachingConfig)this.findConfig(this.config.getEntityCaching(), rootEntityRole);
        AccessType accessType = entityConfig.getAccessType();
        AccessDelegate accessDelegate = this.createAccessDelegate(accessType, entityConfig.isVersioned() ? (Comparator)entityConfig.getVersionComparatorAccess().get() : null);
        if (accessType == AccessType.READ_ONLY || !entityConfig.isMutable()) {
            return new ReadOnlyEntityDataAccess(accessType, accessDelegate, this);
        }
        return new ReadWriteEntityDataAccess(accessType, accessDelegate, this);
    }

    public NaturalIdDataAccess getNaturalIdDataAccess(NavigableRole rootEntityRole) {
        NaturalIdDataCachingConfig naturalIdConfig = (NaturalIdDataCachingConfig)this.findConfig(this.config.getNaturalIdCaching(), rootEntityRole);
        AccessType accessType = naturalIdConfig.getAccessType();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            accessType = AccessType.READ_WRITE;
        }
        AccessDelegate accessDelegate = this.createAccessDelegate(accessType, null);
        if (accessType == AccessType.READ_ONLY || !naturalIdConfig.isMutable()) {
            return new ReadOnlyNaturalDataAccess(accessType, accessDelegate, this);
        }
        return new ReadWriteNaturalDataAccess(accessType, accessDelegate, this);
    }

    public CollectionDataAccess getCollectionDataAccess(NavigableRole collectionRole) {
        CollectionDataCachingConfig collectionConfig = (CollectionDataCachingConfig)this.findConfig(this.config.getCollectionCaching(), collectionRole);
        AccessType accessType = collectionConfig.getAccessType();
        AccessDelegate accessDelegate = this.createAccessDelegate(accessType, collectionConfig.getOwnerVersionComparator());
        return new CollectionDataAccessImpl(this, accessDelegate, accessType);
    }

    private <T extends DomainDataCachingConfig> T findConfig(List<T> configs, NavigableRole role) {
        return (T)configs.stream().filter(c -> c.getNavigableRole().equals((Object)role)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot find configuration for " + role));
    }

    public CacheKeysFactory getCacheKeysFactory() {
        return this.cacheKeysFactory;
    }

    private synchronized AccessDelegate createAccessDelegate(AccessType accessType, Comparator<Object> comparator) {
        CacheMode cacheMode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (accessType == AccessType.NONSTRICT_READ_WRITE) {
            this.prepareForVersionedEntries(cacheMode);
            return new NonStrictAccessDelegate(this, comparator);
        }
        if (cacheMode.isDistributed() || cacheMode.isReplicated()) {
            this.prepareForTombstones(cacheMode);
            return new TombstoneAccessDelegate(this);
        }
        this.prepareForValidation();
        return new NonTxInvalidationCacheAccessDelegate(this, this.validator);
    }

    private void prepareForValidation() {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VALIDATION);
            return;
        }
        this.validator = new PutFromLoadValidator(this.cache, (TimeSource)this.factory, this.factory.getPendingPutsCacheConfiguration());
        this.strategy = Strategy.VALIDATION;
    }

    private void prepareForVersionedEntries(CacheMode cacheMode) {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.VERSIONED_ENTRIES);
            return;
        }
        this.prepareCommon(cacheMode);
        this.filter = VersionedEntry.EXCLUDE_EMPTY_VERSIONED_ENTRY;
        for (EntityDataCachingConfig entityConfig : this.config.getEntityCaching()) {
            if (!entityConfig.isVersioned()) continue;
            for (NavigableRole role : entityConfig.getCachedTypes()) {
                this.comparatorsByType.put(role.getNavigableName(), (Comparator<Object>)entityConfig.getVersionComparatorAccess().get());
            }
        }
        for (CollectionDataCachingConfig collectionConfig : this.config.getCollectionCaching()) {
            if (!collectionConfig.isVersioned()) continue;
            this.comparatorsByType.put(collectionConfig.getNavigableRole().getNavigableName(), collectionConfig.getOwnerVersionComparator());
        }
        this.strategy = Strategy.VERSIONED_ENTRIES;
    }

    private void prepareForTombstones(CacheMode cacheMode) {
        if (this.strategy != null) {
            assert (this.strategy == Strategy.TOMBSTONES);
            return;
        }
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.memory().isEvictionEnabled()) {
            log.evictionWithTombstones();
        }
        this.prepareCommon(cacheMode);
        this.filter = Tombstone.EXCLUDE_TOMBSTONES;
        this.strategy = Strategy.TOMBSTONES;
    }

    private void prepareCommon(CacheMode cacheMode) {
        ComponentRef ref;
        InternalExpirationManager expirationManager;
        BasicComponentRegistry registry = (BasicComponentRegistry)this.cache.getComponentRegistry().getComponent(BasicComponentRegistry.class);
        if (cacheMode.isReplicated() || cacheMode.isDistributed()) {
            AsyncInterceptorChain chain = this.cache.getAsyncInterceptorChain();
            LockingInterceptor lockingInterceptor = new LockingInterceptor();
            registry.registerComponent(LockingInterceptor.class, (Object)lockingInterceptor, true);
            registry.getComponent(LockingInterceptor.class).running();
            if (!chain.addInterceptorBefore((AsyncInterceptor)lockingInterceptor, NonTransactionalLockingInterceptor.class)) {
                throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
            }
            chain.removeInterceptor(NonTransactionalLockingInterceptor.class);
            UnorderedDistributionInterceptor distributionInterceptor = new UnorderedDistributionInterceptor();
            registry.registerComponent(UnorderedDistributionInterceptor.class, (Object)distributionInterceptor, true);
            registry.getComponent(UnorderedDistributionInterceptor.class).running();
            if (!chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, NonTxDistributionInterceptor.class) && !chain.addInterceptorBefore((AsyncInterceptor)distributionInterceptor, TriangleDistributionInterceptor.class)) {
                throw new IllegalStateException("Misconfigured cache, interceptor chain is " + chain);
            }
            chain.removeInterceptor(NonTxDistributionInterceptor.class);
            chain.removeInterceptor(TriangleDistributionInterceptor.class);
        }
        if ((expirationManager = (InternalExpirationManager)(ref = registry.getComponent(InternalExpirationManager.class)).running()) instanceof ClusterExpirationManager) {
            registry.replaceComponent(InternalExpirationManager.class.getName(), (Object)new ExpirationManagerImpl(), true);
            registry.getComponent(InternalExpirationManager.class).running();
            registry.rewire();
            ((ClusterExpirationManager)expirationManager).stop();
        } else if (!(expirationManager instanceof ExpirationManagerImpl)) {
            throw new IllegalStateException("Expected clustered expiration manager, found " + expirationManager);
        }
        registry.registerComponent(InfinispanDataRegion.class, (Object)this, true);
        if (cacheMode.isClustered()) {
            UnorderedReplicationLogic replLogic = new UnorderedReplicationLogic();
            registry.replaceComponent(ClusteringDependentLogic.class.getName(), (Object)replLogic, true);
            registry.getComponent(ClusteringDependentLogic.class).running();
            registry.rewire();
        }
    }

    public long getTombstoneExpiration() {
        return this.tombstoneExpiration;
    }

    public MetaParam.MetaLifespan getExpiringMetaParam() {
        return this.expiringMetaParam;
    }

    public Comparator<Object> getComparator(String subclass) {
        return this.comparatorsByType.get(subclass);
    }

    @Override
    protected void runInvalidation() {
        if (this.strategy == null) {
            throw new IllegalStateException("Strategy was not set");
        }
        switch (this.strategy) {
            case NONE: 
            case VALIDATION: {
                super.runInvalidation();
                return;
            }
            case TOMBSTONES: {
                this.removeEntries(entry -> this.localCache.remove(entry.getKey(), entry.getValue()));
                return;
            }
            case VERSIONED_ENTRIES: {
                VersionedEntry evict = new VersionedEntry(this.factory.nextTimestamp());
                this.removeEntries(entry -> this.localCache.put(entry.getKey(), (Object)evict, this.tombstoneExpiration, TimeUnit.MILLISECONDS));
                return;
            }
        }
    }

    private void removeEntries(Consumer<Map.Entry<Object, Object>> remover) {
        this.localCache.entrySet().stream().filter(this.filter).forEach(remover);
    }

    @Override
    public void destroy() throws CacheException {
        super.destroy();
        if (this.validator != null) {
            this.validator.destroy();
        }
    }

    public DomainDataRegionConfig config() {
        return this.config;
    }

    protected static enum Strategy {
        NONE,
        VALIDATION,
        TOMBSTONES,
        VERSIONED_ENTRIES;

    }
}

