/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.security.wss4j.policyvalidators.PolicyValidatorParameters;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SecurityPolicyValidator;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.RequiredElements;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequiredElementsPolicyValidator
implements SecurityPolicyValidator {
    @Override
    public boolean canValidatePolicy(AssertionInfo assertionInfo) {
        return assertionInfo.getAssertion() != null && (SP12Constants.REQUIRED_ELEMENTS.equals(assertionInfo.getAssertion().getName()) || SP11Constants.REQUIRED_ELEMENTS.equals(assertionInfo.getAssertion().getName()));
    }

    @Override
    public void validatePolicies(PolicyValidatorParameters parameters, Collection<AssertionInfo> ais) {
        for (AssertionInfo ai : ais) {
            RequiredElements rp = (RequiredElements)ai.getAssertion();
            ai.setAsserted(true);
            if (rp == null || rp.getXPaths() == null || rp.getXPaths().isEmpty()) continue;
            XPathFactory factory = XPathFactory.newInstance();
            for (org.apache.wss4j.policy.model.XPath xPath : rp.getXPaths()) {
                Map namespaces = xPath.getPrefixNamespaceMap();
                String expression = xPath.getXPath();
                XPath xpath = factory.newXPath();
                if (namespaces != null) {
                    xpath.setNamespaceContext((NamespaceContext)new MapNamespaceContext(namespaces));
                }
                Element header = parameters.getSoapHeader();
                header = (Element)DOMUtils.getDomElement((Node)header);
                try {
                    NodeList list = (NodeList)xpath.evaluate(expression, header, XPathConstants.NODESET);
                    if (list.getLength() != 0) continue;
                    ai.setNotAsserted("No header element matching XPath " + expression + " found.");
                }
                catch (XPathExpressionException e) {
                    ai.setNotAsserted("Invalid XPath expression " + expression + " " + e.getMessage());
                }
            }
        }
    }
}

