/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.interceptors.CountedInterceptor;
import io.smallrye.metrics.interceptors.MeteredInterceptor;
import io.smallrye.metrics.interceptors.MetricName;
import io.smallrye.metrics.interceptors.MetricNameFactory;
import io.smallrye.metrics.interceptors.MetricResolver;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.interceptors.MetricsInterceptor;
import io.smallrye.metrics.interceptors.TimedInterceptor;
import io.smallrye.metrics.setup.AnnotatedTypeDecorator;
import io.smallrye.metrics.setup.MetricsMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.jboss.logging.Logger;

public class MetricCdiInjectionExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final AnnotationLiteral<MetricsBinding> METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){};
    private static final AnnotationLiteral<Default> DEFAULT = new AnnotationLiteral<Default>(){};
    private final Map<Bean<?>, AnnotatedMember<?>> metrics = new HashMap();
    private final List<Class<?>> metricsInterfaces;

    public MetricCdiInjectionExtension() {
        log.debug((Object)"MetricCdiInjectionExtension");
        this.metricsInterfaces = new ArrayList();
    }

    private void addInterceptorBindings(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        log.info((Object)"MicroProfile: Metrics activated");
        String extensionName = MetricCdiInjectionExtension.class.getName();
        for (Class clazz : new Class[]{MetricProducer.class, MetricNameFactory.class, MetricsInterceptor.class, MetricRegistries.class, MeteredInterceptor.class, CountedInterceptor.class, TimedInterceptor.class, MetricsRequestHandler.class}) {
            bbd.addAnnotatedType(manager.createAnnotatedType(clazz), extensionName + "_" + clazz.getName());
        }
    }

    private <X> void metricsAnnotations(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Metered.class, Timed.class}) ProcessAnnotatedType<X> pat) {
        Class clazz = pat.getAnnotatedType().getJavaClass();
        Package pack = clazz.getPackage();
        if (pack != null && pack.getName().equals(MetricsInterceptor.class.getPackage().getName())) {
            return;
        }
        if (clazz.isInterface()) {
            this.metricsInterfaces.add(clazz);
        } else {
            AnnotatedTypeDecorator newPAT = new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING);
            log.debugf("annotations: %s", newPAT.getAnnotations());
            log.debugf("methods: %s", newPAT.getMethods());
            pat.setAnnotatedType(newPAT);
        }
    }

    private void metricProducerField(@Observes ProcessProducerField<? extends Metric, ?> ppf) {
        log.infof("Metrics producer field discovered: %s", (Object)ppf.getAnnotatedProducerField());
        this.metrics.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
    }

    private void metricProducerMethod(@Observes ProcessProducerMethod<? extends Metric, ?> ppm) {
        if (!ppm.getBean().getBeanClass().equals(MetricProducer.class)) {
            log.infof("Metrics producer method discovered: %s", (Object)ppm.getAnnotatedProducerMethod());
            this.metrics.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    void registerMetrics(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        MetricRegistry registry = MetricCdiInjectionExtension.getReference(manager, MetricRegistry.class);
        MetricName name = MetricCdiInjectionExtension.getReference(manager, MetricName.class);
        for (Map.Entry<Bean<?>, AnnotatedMember<?>> bean : this.metrics.entrySet()) {
            if (!bean.getKey().getQualifiers().contains(DEFAULT) || MetricCdiInjectionExtension.hasInjectionPointMetadata(bean.getValue())) continue;
            String metricName = name.of(bean.getValue());
            registry.register(metricName, (Metric)MetricCdiInjectionExtension.getReference(manager, bean.getValue().getBaseType(), bean.getKey()));
        }
        if (!this.metricsInterfaces.isEmpty()) {
            MetricResolver resolver = new MetricResolver();
            for (Class<?> metricsInterface : this.metricsInterfaces) {
                for (Method method : metricsInterface.getDeclaredMethods()) {
                    if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
                    MetricsMetadata.registerMetrics(registry, resolver, metricsInterface, method);
                }
            }
        }
        this.metricsInterfaces.clear();
        this.metrics.clear();
    }

    private static boolean hasInjectionPointMetadata(AnnotatedMember<?> member) {
        if (!(member instanceof AnnotatedMethod)) {
            return false;
        }
        AnnotatedMethod method = (AnnotatedMethod)member;
        for (AnnotatedParameter parameter : method.getParameters()) {
            if (!parameter.getBaseType().equals(InjectionPoint.class)) continue;
            return true;
        }
        return false;
    }

    private static <T> T getReference(BeanManager manager, Class<T> type) {
        return MetricCdiInjectionExtension.getReference(manager, type, manager.resolve(manager.getBeans(type, new Annotation[0])));
    }

    private static <T> T getReference(BeanManager manager, Type type, Bean<?> bean) {
        return (T)manager.getReference(bean, type, manager.createCreationalContext(bean));
    }
}

