/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ejb.EJB;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.services.bootstrap.AbstractResourceInjectionServices;
import org.jboss.as.weld.services.bootstrap.ComponentViewToResourceReferenceFactoryAdapter;
import org.jboss.as.weld.util.ResourceInjectionUtilities;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.util.reflection.Reflections;

public class WeldEjbInjectionServices
extends AbstractResourceInjectionServices
implements EjbInjectionServices {
    private final EEApplicationDescription applicationDescription;
    private final VirtualFile deploymentRoot;
    private final boolean warModule;

    public WeldEjbInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription, EEApplicationDescription applicationDescription, VirtualFile deploymentRoot, Module module, boolean warModule) {
        super(serviceRegistry, moduleDescription, module);
        this.warModule = warModule;
        if (serviceRegistry == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("serviceRegistry");
        }
        if (moduleDescription == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("moduleDescription");
        }
        if (applicationDescription == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("applicationDescription");
        }
        if (deploymentRoot == null) {
            throw WeldLogger.ROOT_LOGGER.parameterCannotBeNull("deploymentRoot");
        }
        this.applicationDescription = applicationDescription;
        this.deploymentRoot = deploymentRoot;
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        throw new UnsupportedOperationException();
    }

    public ResourceReferenceFactory<Object> registerEjbInjectionPoint(InjectionPoint injectionPoint) {
        final EJB ejb = (EJB)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(EJB.class);
        if (ejb == null) {
            throw WeldLogger.ROOT_LOGGER.annotationNotFound(EJB.class, injectionPoint.getMember());
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw WeldLogger.ROOT_LOGGER.injectionPointNotAJavabean((Method)injectionPoint.getMember());
        }
        if (!ejb.lookup().equals("")) {
            if (ejb.lookup().startsWith("ejb:")) {
                return new ResourceReferenceFactory<Object>(){

                    public ResourceReference<Object> createResource() {
                        return new SimpleResourceReference(WeldEjbInjectionServices.this.doLookup(ejb.lookup(), null));
                    }
                };
            }
            return this.handleServiceLookup(ejb.lookup(), injectionPoint);
        }
        ViewDescription viewDescription = this.getViewDescription(ejb, injectionPoint);
        if (viewDescription != null) {
            return this.handleServiceLookup(viewDescription, injectionPoint);
        }
        final String proposedName = this.getEjbBindLocation(injectionPoint);
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(WeldEjbInjectionServices.this.doLookup(proposedName, null));
            }
        };
    }

    private ResourceReferenceFactory<Object> handleServiceLookup(ViewDescription viewDescription, InjectionPoint injectionPoint) {
        ComponentView view = this.getComponentView(viewDescription);
        if (view != null && injectionPoint.getAnnotated().isAnnotationPresent(Produces.class)) {
            Class clazz = view.getViewClass();
            Class injectionPointRawType = Reflections.getRawType((Type)injectionPoint.getType());
            boolean found = false;
            for (Class c = clazz; c != null && c != Object.class; c = c.getSuperclass()) {
                if (!injectionPointRawType.getName().equals(c.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                throw BeanLogger.LOG.invalidResourceProducerType((Object)injectionPoint.getAnnotated(), (Object)clazz.getName());
            }
            return new ComponentViewToResourceReferenceFactoryAdapter(view);
        }
        return new LazyResourceReferenceFactory(viewDescription, this.serviceRegistry);
    }

    private ComponentView getComponentView(ViewDescription viewDescription) {
        ServiceController controller = this.serviceRegistry.getService(viewDescription.getServiceName());
        if (controller == null) {
            return null;
        }
        return (ComponentView)controller.getValue();
    }

    private ViewDescription getViewDescription(EJB ejb, InjectionPoint injectionPoint) {
        Set viewService = ejb.beanName().isEmpty() ? (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponentsForViewName(ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponentsForViewName(WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot)) : (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponents(ejb.beanName(), ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponents(ejb.beanName(), WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot));
        if (injectionPoint.getAnnotated().isAnnotationPresent(Produces.class)) {
            if (viewService.isEmpty()) {
                throw WeldLogger.ROOT_LOGGER.ejbNotResolved((Object)ejb, injectionPoint.getMember());
            }
            if (viewService.size() > 1) {
                throw WeldLogger.ROOT_LOGGER.moreThanOneEjbResolved((Object)ejb, injectionPoint.getMember(), viewService);
            }
        } else {
            if (viewService.isEmpty()) {
                return null;
            }
            if (viewService.size() > 1) {
                return null;
            }
        }
        return (ViewDescription)viewService.iterator().next();
    }

    protected ContextNames.BindInfo getBindInfo(String result) {
        return ContextNames.bindInfoForEnvEntry((String)this.moduleDescription.getApplicationName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (!this.warModule ? 1 : 0) != 0, (String)result);
    }

    public void cleanup() {
    }

    private static Class<?> getType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return WeldEjbInjectionServices.getType(((ParameterizedType)type).getRawType());
        }
        throw WeldLogger.ROOT_LOGGER.couldNotDetermineUnderlyingType(type);
    }

    protected ResourceReferenceFactory<Object> createLazyResourceReferenceFactory(final ViewDescription viewDescription) {
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                try {
                    ServiceController controller = WeldEjbInjectionServices.this.serviceRegistry.getRequiredService(viewDescription.getServiceName());
                    ComponentView view = (ComponentView)controller.getValue();
                    final ManagedReference instance = view.createInstance();
                    return new ResourceReference<Object>(){

                        public Object getInstance() {
                            return instance.getInstance();
                        }

                        public void release() {
                            instance.release();
                        }
                    };
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Object doLookup(String jndiName, String mappedName) {
        String name = ResourceInjectionUtilities.getResourceName((String)jndiName, (String)mappedName);
        try {
            return new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw WeldLogger.ROOT_LOGGER.couldNotFindResource(name, (Throwable)e);
        }
    }

    private String getEjbBindLocation(InjectionPoint injectionPoint) {
        String propertyName;
        EJB ejb = (EJB)ResourceInjectionUtilities.getResourceAnnotated((InjectionPoint)injectionPoint).getAnnotation(EJB.class);
        String mappedName = ejb.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = ejb.name();
        if (!name.equals("")) {
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = ResourceInjectionUtilities.getPropertyName((Method)((Method)injectionPoint.getMember()));
            if (propertyName == null) {
                throw WeldLogger.ROOT_LOGGER.injectionPointNotAJavabean((Method)injectionPoint.getMember());
            }
        } else {
            throw WeldLogger.ROOT_LOGGER.cannotInject(injectionPoint);
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    private static class LazyResourceReferenceFactory
    implements ResourceReferenceFactory<Object> {
        private final ViewDescription viewDescription;
        private final ServiceRegistry serviceRegistry;

        LazyResourceReferenceFactory(ViewDescription viewDescription, ServiceRegistry serviceRegistry) {
            this.viewDescription = viewDescription;
            this.serviceRegistry = serviceRegistry;
        }

        public ResourceReference<Object> createResource() {
            try {
                ServiceController controller = this.serviceRegistry.getRequiredService(this.viewDescription.getServiceName());
                ComponentView view = (ComponentView)controller.getValue();
                final ManagedReference instance = view.createInstance();
                return new ResourceReference<Object>(){

                    public Object getInstance() {
                        return instance.getInstance();
                    }

                    public void release() {
                        instance.release();
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

