/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jboss.as.threads.ManagedJBossThreadPoolExecutorService;
import org.jboss.as.threads.ManagedQueueExecutorService;
import org.jboss.as.threads.ManagedQueuelessExecutorService;
import org.jboss.as.threads.ManagedScheduledExecutorService;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.StatisticsExecutor;
import org.jboss.logging.Logger;
import org.jboss.threads.BlockingExecutor;
import org.jboss.threads.JBossThreadPoolExecutor;
import org.jboss.threads.management.ThreadPoolExecutorMBean;

public class StatisticsExecutorImpl
implements StatisticsExecutor {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)org.jboss.jca.core.workmanager.StatisticsExecutorImpl.class.getName());
    private final BlockingExecutor realExecutor;

    public StatisticsExecutorImpl(BlockingExecutor realExecutor) {
        this.realExecutor = realExecutor;
    }

    public void execute(Runnable runnable) {
        this.realExecutor.execute(runnable);
    }

    public void executeBlocking(Runnable runnable) throws RejectedExecutionException, InterruptedException {
        this.realExecutor.executeBlocking(runnable);
    }

    public void executeBlocking(Runnable runnable, long l, TimeUnit timeUnit) throws RejectedExecutionException, InterruptedException {
        this.realExecutor.executeBlocking(runnable, l, timeUnit);
    }

    public void executeNonBlocking(Runnable runnable) throws RejectedExecutionException {
        this.realExecutor.executeNonBlocking(runnable);
    }

    public long getNumberOfFreeThreads() {
        if (this.realExecutor instanceof JBossThreadPoolExecutor) {
            return ((JBossThreadPoolExecutor)this.realExecutor).getMaximumPoolSize() - ((JBossThreadPoolExecutor)this.realExecutor).getActiveCount();
        }
        if (this.realExecutor instanceof ThreadPoolExecutorMBean) {
            return ((ThreadPoolExecutorMBean)this.realExecutor).getMaxThreads() - ((ThreadPoolExecutorMBean)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedQueueExecutorService) {
            return ((ManagedQueueExecutorService)this.realExecutor).getMaxThreads() - ((ManagedQueueExecutorService)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedJBossThreadPoolExecutorService) {
            return ((ManagedJBossThreadPoolExecutorService)this.realExecutor).getMaxThreads() - ((ManagedJBossThreadPoolExecutorService)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedQueuelessExecutorService) {
            return ((ManagedQueuelessExecutorService)this.realExecutor).getMaxThreads() - ((ManagedQueuelessExecutorService)this.realExecutor).getCurrentThreadCount();
        }
        if (this.realExecutor instanceof ManagedScheduledExecutorService) {
            return ((ManagedScheduledExecutorService)this.realExecutor).getLargestPoolSize() - ((ManagedScheduledExecutorService)this.realExecutor).getActiveCount();
        }
        return 0L;
    }
}

