/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.metrics;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.setup.JmxRegistrar;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.config.smallrye.ServiceNames;
import org.wildfly.extension.microprofile.metrics.MetricCollector;
import org.wildfly.extension.microprofile.metrics.MicroProfileMetricsSubsystemDefinition;
import org.wildfly.extension.microprofile.metrics._private.MicroProfileMetricsLogger;

public class MetricsRegistrationService
implements org.jboss.msc.service.Service<MetricsRegistrationService> {
    private final ImmutableManagementResourceRegistration rootResourceRegistration;
    private final Resource rootResource;
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private List<String> exposedSubsystems;
    private String globalPrefix;
    private MetricCollector metricCollector;
    private JmxRegistrar jmxRegistrar;
    private LocalModelControllerClient modelControllerClient;
    private MetricCollector.MetricRegistration registration;

    static void install(OperationContext context, List<String> exposedSubsystems, String prefix) {
        ImmutableManagementResourceRegistration rootResourceRegistration = context.getRootResourceRegistration();
        Resource rootResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileMetricsSubsystemDefinition.WILDFLY_REGISTRATION_SERVICE);
        Supplier modelControllerClientFactory = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.model-controller-client-factory", ModelControllerClientFactory.class));
        Supplier managementExecutor = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.executor", Executor.class));
        serviceBuilder.requires(ServiceNames.CONFIG_PROVIDER);
        MetricsRegistrationService service = new MetricsRegistrationService(rootResourceRegistration, rootResource, modelControllerClientFactory, managementExecutor, exposedSubsystems, prefix);
        serviceBuilder.setInstance((Service)service).install();
    }

    public MetricsRegistrationService(ImmutableManagementResourceRegistration rootResourceRegistration, Resource rootResource, Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor, List<String> exposedSubsystems, String globalPrefix) {
        this.rootResourceRegistration = rootResourceRegistration;
        this.rootResource = rootResource;
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
        this.exposedSubsystems = exposedSubsystems;
        this.globalPrefix = globalPrefix;
    }

    public void start(StartContext context) throws StartException {
        this.jmxRegistrar = new JmxRegistrar();
        try {
            this.jmxRegistrar.init();
        }
        catch (IOException e) {
            throw MicroProfileMetricsLogger.LOGGER.failedInitializeJMXRegistrar(e);
        }
        this.modelControllerClient = this.modelControllerClientFactory.get().createClient(this.managementExecutor.get());
        this.metricCollector = new MetricCollector(this.modelControllerClient, this.rootResourceRegistration, this.exposedSubsystems, this.globalPrefix);
        this.registration = this.metricCollector.collectResourceMetrics(this.rootResource, this.rootResourceRegistration, Function.identity());
    }

    public void stop(StopContext context) {
        for (MetricRegistry registry : new MetricRegistry[]{MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.BASE), MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.VENDOR)}) {
            for (String name : registry.getNames()) {
                registry.remove(name);
            }
        }
        this.registration.unregister();
        this.metricCollector.close();
        this.modelControllerClient.close();
        this.jmxRegistrar = null;
    }

    public MetricsRegistrationService getValue() {
        return this;
    }

    public MetricCollector.MetricRegistration registerMetrics(Resource rootResource, ImmutableManagementResourceRegistration managementResourceRegistration, Function<PathAddress, PathAddress> resourceAddressResolver) {
        return this.metricCollector.collectResourceMetrics(rootResource, managementResourceRegistration, resourceAddressResolver);
    }
}

