/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.table.management;

import java.sql.Connection;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.jdbc.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.jdbc.logging.Log;
import org.infinispan.persistence.jdbc.table.management.AbstractTableManager;
import org.infinispan.persistence.jdbc.table.management.DbMetaData;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.util.logging.LogFactory;

class PostgresTableManager
extends AbstractTableManager {
    private static final Log LOG = (Log)LogFactory.getLog(PostgresTableManager.class, Log.class);

    PostgresTableManager(ConnectionFactory connectionFactory, TableManipulationConfiguration config, DbMetaData metaData) {
        super(connectionFactory, config, metaData, LOG);
    }

    @Override
    protected void dropIndex(Connection conn, String indexName) throws PersistenceException {
        String dropIndexDdl = String.format("DROP INDEX IF EXISTS  %s", this.getIndexName(true, indexName));
        this.executeUpdateSql(conn, dropIndexDdl);
    }

    @Override
    public String getUpdateRowSql() {
        if (this.updateRowSql == null) {
            this.updateRowSql = String.format("UPDATE %s SET %s = ? , %s = ? WHERE %s = cast(? as %s)", this.getTableName(), this.config.dataColumnName(), this.config.timestampColumnName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.updateRowSql;
    }

    @Override
    public String getSelectRowSql() {
        if (this.selectRowSql == null) {
            this.selectRowSql = String.format("SELECT %s, %s FROM %s WHERE %s = cast(? as %s)", this.config.idColumnName(), this.config.dataColumnName(), this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.selectRowSql;
    }

    @Override
    public String getSelectMultipleRowSql(int numberOfParams) {
        String selectCriteria = this.config.idColumnName() + " = cast(? as " + this.config.idColumnType() + ")";
        return this.getSelectMultipleRowSql(numberOfParams, selectCriteria);
    }

    @Override
    public String getSelectIdRowSql() {
        if (this.selectIdRowSql == null) {
            this.selectIdRowSql = String.format("SELECT %s FROM %s WHERE %s = cast(? as %s)", this.config.idColumnName(), this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.selectIdRowSql;
    }

    @Override
    public String getDeleteRowSql() {
        if (this.deleteRowSql == null) {
            this.deleteRowSql = String.format("DELETE FROM %s WHERE %s = cast(? as %s)", this.getTableName(), this.config.idColumnName(), this.config.idColumnType());
        }
        return this.deleteRowSql;
    }

    @Override
    public boolean isUpsertSupported() {
        return super.isUpsertSupported() && (this.metaData.getMajorVersion() >= 10 || this.metaData.getMajorVersion() == 9 && this.metaData.getMinorVersion() >= 5);
    }

    @Override
    public String getUpsertRowSql() {
        if (this.upsertRowSql == null) {
            this.upsertRowSql = String.format("%1$s ON CONFLICT (%2$s) DO UPDATE SET %3$s = EXCLUDED.%3$s, %4$s = EXCLUDED.%4$s", this.getInsertRowSql(), this.config.idColumnName(), this.config.dataColumnName(), this.config.timestampColumnName());
        }
        return this.upsertRowSql;
    }
}

