/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.container.CommandContainerBuilder;
import org.aesh.command.impl.container.AeshCommandContainerBuilder;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.registry.CommandRegistryException;
import org.aesh.command.registry.MutableCommandRegistry;
import org.aesh.parser.ParsedLine;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.util.LoggerUtil;

public class MutableCommandRegistryImpl<C extends Command<CI>, CI extends CommandInvocation>
implements MutableCommandRegistry<C, CI> {
    private final Map<String, CommandContainer<C, CI>> registry = new HashMap<String, CommandContainer<C, CI>>();
    private final Map<String, CommandContainer<C, CI>> aliases = new HashMap<String, CommandContainer<C, CI>>();
    private CommandContainerBuilder<C, CI> containerBuilder;
    private final List<CommandRegistry.CommandRegistrationListener> listeners = new ArrayList<CommandRegistry.CommandRegistrationListener>();
    private static final Logger LOGGER = LoggerUtil.getLogger((String)MutableCommandRegistryImpl.class.getName());

    public void setCommandContainerBuilder(CommandContainerBuilder<C, CI> containerBuilder) {
        this.containerBuilder = containerBuilder;
    }

    @Override
    public CommandContainer<C, CI> getCommand(String name, String line) throws CommandNotFoundException {
        if (this.registry.containsKey(name)) {
            return this.registry.get(name);
        }
        if (name.contains(" ")) {
            String[] names = name.split(" ");
            if (this.registry.containsKey(names[0])) {
                return this.registry.get(names[0]);
            }
            throw new CommandNotFoundException("Command: " + names[0] + " was not found.", names[0]);
        }
        throw new CommandNotFoundException("Command: " + name + " was not found.", name);
    }

    @Override
    public List<CommandLineParser<C>> getChildCommandParsers(String parent) throws CommandNotFoundException {
        CommandContainer<C, CI> c = this.getCommand(parent, "");
        if (c == null) {
            throw new CommandNotFoundException("Command: " + parent + " was not found.", parent);
        }
        return Collections.unmodifiableList(c.getParser().getAllChildParsers());
    }

    @Override
    public void completeCommandName(CompleteOperation co, ParsedLine parsedLine) {
        if (parsedLine.words().size() == 0) {
            for (CommandContainer<C, CI> command : this.registry.values()) {
                ProcessedCommand<C> com = command.getParser().getProcessedCommand();
                if (!com.getActivator().isActivated(new ParsedCommand(com))) continue;
                co.addCompletionCandidate(com.name());
            }
        } else {
            for (CommandContainer<C, CI> command : this.registry.values()) {
                ProcessedCommand<C> com = command.getParser().getProcessedCommand();
                if (!com.name().startsWith(parsedLine.selectedWord().word()) || !com.getActivator().isActivated(new ParsedCommand(com))) continue;
                co.addCompletionCandidate(com.name());
                co.setOffset(co.getCursor() - parsedLine.selectedWord().word().length());
                if (parsedLine.selectedIndex() >= parsedLine.size() - 1) continue;
                co.doAppendSeparator(false);
            }
        }
    }

    @Override
    public Set<String> getAllCommandNames() {
        return this.registry.keySet();
    }

    @Override
    public void addCommand(CommandContainer<C, CI> container) {
        this.putIntoRegistry(container);
    }

    @Override
    public void addCommand(C command) throws CommandRegistryException {
        try {
            this.putIntoRegistry(this.getBuilder().create(command));
        }
        catch (CommandLineParserException e) {
            throw new CommandRegistryException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void addCommand(Class<C> command) throws CommandRegistryException {
        try {
            this.putIntoRegistry(this.getBuilder().create(command));
        }
        catch (CommandLineParserException e) {
            throw new CommandRegistryException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void addAllCommands(List<C> commands) throws CommandRegistryException {
        if (commands != null) {
            for (Command command : commands) {
                this.addCommand(command);
            }
        }
    }

    @Override
    public void addAllCommandContainers(List<CommandContainer<C, CI>> commands) {
        if (commands != null) {
            for (CommandContainer<C, CI> command : commands) {
                this.addCommand((C)command);
            }
        }
    }

    @Override
    public boolean contains(String commandName) {
        return this.registry.containsKey(commandName) || this.aliases.containsKey(commandName);
    }

    private void putIntoRegistry(CommandContainer<C, CI> commandContainer) {
        if (!commandContainer.haveBuildError() && !this.contains(commandContainer.getParser().getProcessedCommand())) {
            this.registry.put(commandContainer.getParser().getProcessedCommand().name(), commandContainer);
            ProcessedCommand<C> command = commandContainer.getParser().getProcessedCommand();
            for (String alias : command.getAliases()) {
                this.aliases.put(alias, commandContainer);
            }
            this.emit(commandContainer.getParser().getProcessedCommand().name(), CommandRegistry.REGISTRATION_ACTION.ADDED);
        }
    }

    private boolean contains(ProcessedCommand<?> command) {
        if (this.registry.containsKey(command.name())) {
            return true;
        }
        for (String alias : command.getAliases()) {
            if (!this.aliases.containsKey(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeCommand(String name) {
        if (this.registry.containsKey(name)) {
            CommandContainer<C, CI> container = this.registry.remove(name);
            ProcessedCommand<C> command = container.getParser().getProcessedCommand();
            for (String alias : command.getAliases()) {
                this.aliases.remove(alias);
            }
            this.emit(name, CommandRegistry.REGISTRATION_ACTION.REMOVED);
        }
    }

    private CommandContainerBuilder<C, CI> getBuilder() {
        if (this.containerBuilder == null) {
            this.containerBuilder = new AeshCommandContainerBuilder();
        }
        return this.containerBuilder;
    }

    @Override
    public CommandContainer<C, CI> getCommandByAlias(String alias) throws CommandNotFoundException {
        if (this.aliases.containsKey(alias)) {
            return this.aliases.get(alias);
        }
        throw new CommandNotFoundException("Command: named " + alias + " was not found.", alias);
    }

    private void emit(String name, CommandRegistry.REGISTRATION_ACTION action) {
        for (CommandRegistry.CommandRegistrationListener listener : this.listeners) {
            listener.registrationAction(name, action);
        }
    }

    @Override
    public void addRegistrationListener(CommandRegistry.CommandRegistrationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeRegistrationListener(CommandRegistry.CommandRegistrationListener listener) {
        this.listeners.remove(listener);
    }
}

