/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocator
implements RouteLocator {
    private final NodeFactory<Address> factory;
    private final Registry<String, Void> registry;
    private final Cache<String, ?> cache;

    public InfinispanRouteLocator(InfinispanRouteLocatorConfiguration config) {
        this.cache = config.getCache();
        this.registry = config.getRegistry();
        this.factory = config.getMemberFactory();
    }

    public String locate(String sessionId) {
        Map.Entry entry;
        DistributionManager dist = this.cache.getAdvancedCache().getDistributionManager();
        Address address = dist != null && !this.cache.getCacheConfiguration().clustering().cacheMode().isScattered() ? dist.getCacheTopology().getDistribution((Object)new Key((Object)sessionId)).primary() : this.cache.getCacheManager().getAddress();
        Node node = address != null ? this.factory.createNode((Object)address) : null;
        Map.Entry entry2 = entry = node != null ? this.registry.getEntry(node) : null;
        if (entry == null) {
            entry = this.registry.getEntry(this.registry.getGroup().getLocalMember());
        }
        return entry != null ? (String)entry.getKey() : null;
    }
}

