/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.store.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.CredentialStoreSpi;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store.impl.SecurityVaultData;
import org.wildfly.security.credential.store.impl.VaultObjectInputStream;
import org.wildfly.security.credential.store.impl.VaultObjectOutputStream;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.util.AtomicFileOutputStream;

public final class VaultCredentialStore
extends CredentialStoreSpi {
    public static final String VAULT_CREDENTIAL_STORE = "VaultCredentialStore";
    private static final String LOCATION = "location";
    private static final List<String> validAttribtues = Arrays.asList("location");
    private final Map<String, byte[]> data = new HashMap<String, byte[]>();
    private SecretKey adminKey;
    private File location;
    private volatile boolean modifiable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Map<String, String> attributes, CredentialStore.ProtectionParameter protectionParameter, Provider[] providers) throws CredentialStoreException {
        File locationFile;
        SecretKey secretKey;
        if (!(protectionParameter instanceof CredentialStore.CredentialSourceProtectionParameter)) {
            throw ElytronMessages.log.invalidProtectionParameter(protectionParameter);
        }
        CredentialSource credentialSource = ((CredentialStore.CredentialSourceProtectionParameter)protectionParameter).getCredentialSource();
        try {
            secretKey = credentialSource.applyToCredential(SecretKeyCredential.class, "AES", SecretKeyCredential::getSecretKey);
        }
        catch (IOException e) {
            throw ElytronMessages.log.cannotAcquireCredentialFromStore(e);
        }
        if (secretKey == null) {
            throw ElytronMessages.log.cannotAcquireCredentialFromStore(null);
        }
        this.validateAttribute(attributes, validAttribtues);
        String location = attributes.get(LOCATION);
        if (location != null && (locationFile = new File(location, "VAULT.dat")).exists()) {
            SecurityVaultData data;
            try (FileInputStream is = new FileInputStream(locationFile);
                 VaultObjectInputStream ois = new VaultObjectInputStream(is);){
                data = (SecurityVaultData)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw ElytronMessages.log.cannotAcquireCredentialFromStore(e);
            }
            if (data != null) {
                Map<String, byte[]> map = this.data;
                synchronized (map) {
                    this.data.clear();
                    this.data.putAll(data.getVaultData());
                }
            }
            this.location = locationFile;
            this.modifiable = locationFile.canWrite();
        }
        this.adminKey = secretKey;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String credentialAlias, Credential credential, CredentialStore.ProtectionParameter protectionParameter) throws CredentialStoreException, UnsupportedCredentialTypeException {
        byte[] encoded;
        if (!this.modifiable) {
            throw ElytronMessages.log.nonModifiableCredentialStore("store");
        }
        if (protectionParameter != null) {
            throw ElytronMessages.log.invalidProtectionParameter(protectionParameter);
        }
        char[] chars = credential.castAndApply(PasswordCredential.class, c -> c.getPassword().castAndApply(ClearPassword.class, ClearPassword::getPassword));
        if (chars == null) {
            throw ElytronMessages.log.unsupportedCredentialType(credential.getClass());
        }
        try {
            Cipher cipher = Cipher.getInstance(this.adminKey.getAlgorithm());
            cipher.init(1, this.adminKey);
            encoded = cipher.doFinal(CodePointIterator.ofChars(chars).asUtf8().drain());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw ElytronMessages.log.cannotWriteCredentialToStore(e);
        }
        Map<String, byte[]> map = this.data;
        synchronized (map) {
            this.data.put(credentialAlias, encoded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends Credential> C retrieve(String credentialAlias, Class<C> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec, CredentialStore.ProtectionParameter protectionParameter) throws CredentialStoreException {
        byte[] decoded;
        byte[] bytes;
        if (protectionParameter != null) {
            throw ElytronMessages.log.invalidProtectionParameter(protectionParameter);
        }
        if (!credentialType.isAssignableFrom(PasswordCredential.class)) {
            return null;
        }
        if (credentialAlgorithm != null && !credentialAlgorithm.equals("clear")) {
            return null;
        }
        if (parameterSpec != null) {
            return null;
        }
        Map<String, byte[]> map = this.data;
        synchronized (map) {
            bytes = this.data.get(credentialAlias);
        }
        try {
            Cipher cipher = Cipher.getInstance(this.adminKey.getAlgorithm());
            cipher.init(2, this.adminKey);
            decoded = cipher.doFinal(bytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw ElytronMessages.log.cannotAcquireCredentialFromStore(e);
        }
        return (C)((Credential)credentialType.cast(new PasswordCredential(ClearPassword.createRaw("clear", new String(decoded, StandardCharsets.UTF_8).toCharArray()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String credentialAlias, Class<? extends Credential> credentialType, String credentialAlgorithm, AlgorithmParameterSpec parameterSpec) throws CredentialStoreException {
        if (!credentialType.isAssignableFrom(PasswordCredential.class)) {
            return;
        }
        if (credentialAlgorithm != null && !credentialAlgorithm.equals("clear")) {
            return;
        }
        if (parameterSpec != null) {
            return;
        }
        Map<String, byte[]> map = this.data;
        synchronized (map) {
            this.data.remove(credentialAlias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws CredentialStoreException {
        Map<String, byte[]> map = this.data;
        synchronized (map) {
            File location = this.location;
            if (location != null) {
                try (AtomicFileOutputStream os = new AtomicFileOutputStream(location);){
                    try (VaultObjectOutputStream oos = new VaultObjectOutputStream(os);){
                        oos.writeObject(new SecurityVaultData(this.data));
                    }
                    catch (Throwable t) {
                        os.cancel();
                        throw t;
                    }
                }
                catch (IOException e) {
                    throw ElytronMessages.log.cannotWriteCredentialToStore(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAliases() throws UnsupportedOperationException, CredentialStoreException {
        Map<String, byte[]> map = this.data;
        synchronized (map) {
            return this.data.keySet();
        }
    }
}

