/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaExceptionClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.WSDLToJavaProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;

public class FaultGenerator
extends AbstractJAXWSGenerator {
    private static final String FAULT_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/fault.vm";

    public FaultGenerator() {
        this.name = "fault.generator";
    }

    @Override
    public boolean passthrough() {
        if (this.env.optionSet("genFault") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genService");
    }

    @Override
    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        if (this.passthrough()) {
            return;
        }
        Map map = CastUtils.cast((Map)((Map)penv.get(WSDLToJavaProcessor.MODEL_MAP)));
        for (JavaModel javaModel : map.values()) {
            Map exceptionClasses = javaModel.getExceptionClasses();
            for (Map.Entry entry : exceptionClasses.entrySet()) {
                String simpleName;
                JavaExceptionClass expClz = (JavaExceptionClass)entry.getValue();
                this.clearAttributes();
                if (penv.containsKey("faultSerialVersionUID")) {
                    String faultSerialVersionUID = penv.get("faultSerialVersionUID").toString();
                    this.setAttributes("faultSerialVersionUID", faultSerialVersionUID);
                    if ("FQCN".equalsIgnoreCase(faultSerialVersionUID)) {
                        this.setAttributes("suid", this.generateHashSUID(expClz.getFullClassName()));
                    } else if ("TIMESTAMP".equalsIgnoreCase(faultSerialVersionUID)) {
                        this.setAttributes("suid", this.generateTimestampSUID());
                    } else if ("NONE".equalsIgnoreCase(faultSerialVersionUID)) {
                        this.setAttributes("suid", "");
                    } else {
                        try {
                            Long.parseLong(faultSerialVersionUID);
                        }
                        catch (NumberFormatException nfe) {
                            throw new ToolException((Throwable)nfe);
                        }
                        this.setAttributes("suid", faultSerialVersionUID);
                    }
                } else {
                    this.setAttributes("suid", "");
                }
                this.setAttributes("expClass", expClz);
                String exceptionSuperclass = penv.containsKey("exceptionSuper") ? penv.get("exceptionSuper").toString() : "java.lang.Exception";
                String exceptionSuperclassString = simpleName = exceptionSuperclass.indexOf(46) == -1 ? exceptionSuperclass : exceptionSuperclass.substring(exceptionSuperclass.lastIndexOf(46) + 1);
                for (JavaField jf : expClz.getFields()) {
                    String jfClassName = jf.getClassName();
                    if (jfClassName.substring(jfClassName.lastIndexOf(".") + 1).equals(simpleName)) {
                        exceptionSuperclassString = exceptionSuperclass;
                    }
                    this.setAttributes("paraName", ProcessorUtil.mangleNameToVariableName(jf.getName()));
                }
                ClassCollector collector = (ClassCollector)penv.get(ClassCollector.class);
                for (String pkg : collector.getTypesPackages()) {
                    if (!collector.containTypesClass(pkg, simpleName)) continue;
                    exceptionSuperclassString = exceptionSuperclass;
                }
                if (expClz.getName().equals(exceptionSuperclassString)) {
                    exceptionSuperclassString = exceptionSuperclass;
                }
                this.setAttributes("exceptionSuperclass", exceptionSuperclassString);
                if (!exceptionSuperclass.startsWith("java.lang.") && !exceptionSuperclassString.equals(exceptionSuperclass)) {
                    expClz.addImport(exceptionSuperclass);
                }
                this.setCommonAttributes();
                this.doWrite(FAULT_TEMPLATE, this.parseOutputName(expClz.getPackageName(), expClz.getName()));
            }
        }
    }

    private String generateHashSUID(String className) {
        return Long.toString(className.hashCode());
    }

    private String generateTimestampSUID() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    @Override
    public void register(ClassCollector collector, String packageName, String fileName) {
        collector.addExceptionClassName(packageName, fileName, packageName + "." + fileName);
    }
}

