/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.DoubleAdder;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.SimpleTimer;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class Histogram
extends SimpleCollector<Child>
implements Collector.Describable {
    private final double[] buckets;

    Histogram(Builder b) {
        super(b);
        this.buckets = b.buckets;
        this.initializeNoLabelsChild();
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child(this.buckets);
    }

    public void observe(double amt) {
        ((Child)this.noLabelsChild).observe(amt);
    }

    public Timer startTimer() {
        return ((Child)this.noLabelsChild).startTimer();
    }

    public double time(Runnable timeable) {
        return ((Child)this.noLabelsChild).time(timeable);
    }

    public <E> E time(Callable<E> timeable) {
        return ((Child)this.noLabelsChild).time(timeable);
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Child.Value v = ((Child)c.getValue()).get();
            ArrayList<String> labelNamesWithLe = new ArrayList<String>(this.labelNames);
            labelNamesWithLe.add("le");
            for (int i = 0; i < v.buckets.length; ++i) {
                ArrayList<String> labelValuesWithLe = new ArrayList<String>((Collection)c.getKey());
                labelValuesWithLe.add(Histogram.doubleToGoString(this.buckets[i]));
                samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_bucket", labelNamesWithLe, labelValuesWithLe, v.buckets[i]));
            }
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_count", this.labelNames, (List)c.getKey(), v.buckets[this.buckets.length - 1]));
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_sum", this.labelNames, (List)c.getKey(), v.sum));
        }
        return this.familySamplesList(Collector.Type.HISTOGRAM, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.fullname, Collector.Type.HISTOGRAM, this.help, Collections.<Collector.MetricFamilySamples.Sample>emptyList()));
    }

    double[] getBuckets() {
        return this.buckets;
    }

    public static class Child {
        private final double[] upperBounds;
        private final DoubleAdder[] cumulativeCounts;
        private final DoubleAdder sum = new DoubleAdder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double time(Runnable timeable) {
            double elapsed;
            Timer timer = this.startTimer();
            try {
                timeable.run();
            }
            finally {
                elapsed = timer.observeDuration();
            }
            return elapsed;
        }

        public <E> E time(Callable<E> timeable) {
            Timer timer = this.startTimer();
            try {
                E e = timeable.call();
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                timer.observeDuration();
            }
        }

        private Child(double[] buckets) {
            this.upperBounds = buckets;
            this.cumulativeCounts = new DoubleAdder[buckets.length];
            for (int i = 0; i < buckets.length; ++i) {
                this.cumulativeCounts[i] = new DoubleAdder();
            }
        }

        public void observe(double amt) {
            for (int i = 0; i < this.upperBounds.length; ++i) {
                if (!(amt <= this.upperBounds[i])) continue;
                this.cumulativeCounts[i].add(1.0);
                break;
            }
            this.sum.add(amt);
        }

        public Timer startTimer() {
            return new Timer(this, SimpleTimer.defaultTimeProvider.nanoTime());
        }

        public Value get() {
            double[] buckets = new double[this.cumulativeCounts.length];
            double acc = 0.0;
            for (int i = 0; i < this.cumulativeCounts.length; ++i) {
                buckets[i] = acc += this.cumulativeCounts[i].sum();
            }
            return new Value(this.sum.sum(), buckets);
        }

        public static class Value {
            public final double sum;
            public final double[] buckets;

            public Value(double sum, double[] buckets) {
                this.sum = sum;
                this.buckets = buckets;
            }
        }
    }

    public static class Timer
    implements Closeable {
        private final Child child;
        private final long start;

        private Timer(Child child, long start) {
            this.child = child;
            this.start = start;
        }

        public double observeDuration() {
            double elapsed = SimpleTimer.elapsedSecondsFromNanos(this.start, SimpleTimer.defaultTimeProvider.nanoTime());
            this.child.observe(elapsed);
            return elapsed;
        }

        @Override
        public void close() {
            this.observeDuration();
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Histogram> {
        private double[] buckets = new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};

        @Override
        public Histogram create() {
            for (int i = 0; i < this.buckets.length - 1; ++i) {
                if (!(this.buckets[i] >= this.buckets[i + 1])) continue;
                throw new IllegalStateException("Histogram buckets must be in increasing order: " + this.buckets[i] + " >= " + this.buckets[i + 1]);
            }
            if (this.buckets.length == 0) {
                throw new IllegalStateException("Histogram must have at least one bucket.");
            }
            for (String label : this.labelNames) {
                if (!label.equals("le")) continue;
                throw new IllegalStateException("Histogram cannot have a label named 'le'.");
            }
            if (this.buckets[this.buckets.length - 1] != Double.POSITIVE_INFINITY) {
                double[] tmp = new double[this.buckets.length + 1];
                System.arraycopy(this.buckets, 0, tmp, 0, this.buckets.length);
                tmp[this.buckets.length] = Double.POSITIVE_INFINITY;
                this.buckets = tmp;
            }
            this.dontInitializeNoLabelsChild = true;
            return new Histogram(this);
        }

        public Builder buckets(double ... buckets) {
            this.buckets = buckets;
            return this;
        }

        public Builder linearBuckets(double start, double width, int count) {
            this.buckets = new double[count];
            for (int i = 0; i < count; ++i) {
                this.buckets[i] = start + (double)i * width;
            }
            return this;
        }

        public Builder exponentialBuckets(double start, double factor, int count) {
            this.buckets = new double[count];
            for (int i = 0; i < count; ++i) {
                this.buckets[i] = start * Math.pow(factor, i);
            }
            return this;
        }
    }
}

