/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.controller.descriptions.SimpleResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.PassiveServiceSupplier;

public class ChannelRuntimeResourceRegistration
implements RuntimeResourceRegistration,
ProtocolMetricsHandler.ProtocolLocator {
    @Override
    public Protocol findProtocol(OperationContext context) throws ClassNotFoundException, ModuleLoadException {
        ChannelFactory factory;
        PathAddress address = context.getCurrentAddress();
        String channelName = address.getParent().getLastElement().getValue();
        String protocolName = address.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        JChannel channel = (JChannel)new PassiveServiceSupplier(registry, JGroupsRequirement.CHANNEL.getServiceName(context, channelName)).get();
        if (channel != null && (factory = (ChannelFactory)new PassiveServiceSupplier(registry, JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channelName)).get()) != null) {
            ProtocolStackConfiguration configuration = factory.getProtocolStackConfiguration();
            TransportConfiguration transport = configuration.getTransport();
            if (transport.getName().equals(protocolName)) {
                Class<?> protocolClass = ((TP)transport.createProtocol(configuration)).getClass();
                return channel.getProtocolStack().findProtocol(protocolClass);
            }
            for (ProtocolConfiguration protocol : configuration.getProtocols()) {
                if (!protocol.getName().equals(protocolName)) continue;
                Class<?> protocolClass = protocol.createProtocol(configuration).getClass();
                return channel.getProtocolStack().findProtocol(protocolClass);
            }
        }
        return null;
    }

    public void register(OperationContext context) throws OperationFailedException {
        OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                String description = JGroupsExtension.SUBSYSTEM_RESOLVER.getChildTypeDescription(ProtocolResourceDefinition.WILDCARD_PATH.getKey(), locale, JGroupsExtension.SUBSYSTEM_RESOLVER.getResourceBundle(locale));
                ModelNode result = new ModelNode();
                result.get("description").set(description);
                return Collections.singletonMap(ProtocolResourceDefinition.WILDCARD_PATH.getKey(), result);
            }
        };
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        String stack = ChannelResourceDefinition.Attribute.STACK.resolveModelAttribute((ExpressionResolver)context, resource.getModel()).asString();
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate().registerOverrideModel(context.getCurrentAddressValue(), provider);
        PathAddress stackAddress = context.getCurrentAddress().getParent().append(new PathElement[]{StackResourceDefinition.pathElement(stack)});
        Resource stackResource = context.readResourceFromRoot(stackAddress, false);
        for (String name : stackResource.getChildrenNames(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
            PathAddress transportAddress = stackAddress.append(new PathElement[]{TransportResourceDefinition.pathElement(name)});
            ModelNode transport = context.readResourceFromRoot(transportAddress, false).getModel();
            String moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, transport).asString();
            Class<? extends Protocol> transportClass = ChannelRuntimeResourceRegistration.findProtocolClass(context, name, moduleName);
            registration.registerSubModel(this.createProtocolResourceDefinition(name, transportClass));
            resource.registerChild(ProtocolResourceDefinition.pathElement(name), (Resource)PlaceholderResource.INSTANCE);
        }
        for (String name : stackResource.getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            Resource protocolResource = context.readResourceFromRoot(stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement(name)}), false);
            String moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, protocolResource.getModel()).asString();
            Class<? extends Protocol> protocolClass = ChannelRuntimeResourceRegistration.findProtocolClass(context, name, moduleName);
            registration.registerSubModel(this.createProtocolResourceDefinition(name, protocolClass));
            resource.registerChild(ProtocolResourceDefinition.pathElement(name), (Resource)PlaceholderResource.INSTANCE);
        }
        if (stackResource.hasChild(RelayResourceDefinition.PATH)) {
            registration.registerSubModel(this.createProtocolResourceDefinition("relay.RELAY2", RELAY2.class));
            resource.registerChild(ProtocolResourceDefinition.pathElement("relay.RELAY2"), (Resource)PlaceholderResource.INSTANCE);
        }
    }

    public void unregister(OperationContext context) {
        for (String name : context.readResource(PathAddress.EMPTY_ADDRESS).getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{ProtocolResourceDefinition.pathElement(name)}));
        }
        context.getResourceRegistrationForUpdate().unregisterOverrideModel(context.getCurrentAddressValue());
    }

    private ResourceDefinition createProtocolResourceDefinition(String protocolName, Class<? extends Protocol> protocolClass) {
        SimpleResourceDescriptionResolver resolver = new SimpleResourceDescriptionResolver(protocolName, protocolClass.getSimpleName());
        ResourceBuilder builder = ResourceBuilder.Factory.create((PathElement)ProtocolResourceDefinition.pathElement(protocolName), (StandardResourceDescriptionResolver)resolver).setRuntime();
        ProtocolMetricsHandler handler = new ProtocolMetricsHandler(this);
        for (Map.Entry<String, ProtocolMetricsHandler.Attribute> entry : ProtocolMetricsHandler.findProtocolAttributes(protocolClass).entrySet()) {
            String name = entry.getKey();
            ProtocolMetricsHandler.Attribute attribute = entry.getValue();
            ProtocolMetricsHandler.FieldType type = ProtocolMetricsHandler.FieldType.valueOf(attribute.getType());
            resolver.addDescription(name, attribute.getDescription());
            builder.addMetric((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type.getModelType(), true).setStorageRuntime()).build(), (OperationStepHandler)handler);
        }
        return builder.build();
    }

    static Class<? extends Protocol> findProtocolClass(OperationContext context, String protocolName, String moduleName) throws OperationFailedException {
        String className = protocolName;
        if (moduleName.equals(AbstractProtocolResourceDefinition.Attribute.MODULE.getDefinition().getDefaultValue().asString()) && !protocolName.startsWith("org.jgroups.protocols")) {
            className = String.join((CharSequence)".", "org.jgroups.protocols", protocolName);
        }
        try {
            return Module.getContextModuleLoader().loadModule(moduleName).getClassLoader().loadClass(className).asSubclass(Protocol.class);
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            throw JGroupsLogger.ROOT_LOGGER.unableToLoadProtocolClass(className);
        }
    }
}

