/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.util.function.Supplier;
import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.singleton.LocalSingletonService;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceConfiguratorContext;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceContext;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.service.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceConfigurator;

public class LocalSingletonServiceConfigurator
extends SimpleServiceNameProvider
implements SingletonServiceConfigurator,
LocalSingletonServiceContext {
    private final SupplierDependency<Group> group;

    public LocalSingletonServiceConfigurator(ServiceName name, LocalSingletonServiceConfiguratorContext context) {
        super(name);
        this.group = context.getGroupDependency();
    }

    public SingletonServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        return new LocalSingletonServiceBuilder(this.group.register(builder), this);
    }

    public SingletonServiceConfigurator requireQuorum(int quorum) {
        return this;
    }

    public SingletonServiceConfigurator electionPolicy(SingletonElectionPolicy policy) {
        return this;
    }

    @Override
    public Supplier<Group> getGroup() {
        return this.group;
    }

    private static class LocalSingletonServiceBuilder<T>
    extends DelegatingServiceBuilder<T>
    implements SingletonServiceBuilder<T> {
        private final LocalSingletonServiceContext context;
        private Service service = Service.NULL;

        LocalSingletonServiceBuilder(ServiceBuilder<T> builder, LocalSingletonServiceContext context) {
            super(builder);
            this.context = context;
        }

        public ServiceBuilder<T> setInstance(Service service) {
            this.service = service;
            return this;
        }

        public ServiceController<T> install() {
            return this.getDelegate().setInstance((Service)new LocalSingletonService(this.service, this.context)).install();
        }
    }
}

