/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.indexes.impl.IndexManagerGroupHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.store.ShardIdentifierProvider;

class DynamicShardingIndexManagerSelector
implements IndexManagerSelector {
    private final ShardIdentifierProvider shardIdentifierProvider;
    private final IndexManagerGroupHolder indexManagerGroupHolder;
    private final Properties indexProperties;
    private final IndexedTypeIdentifier entityType;

    public DynamicShardingIndexManagerSelector(ShardIdentifierProvider shardIdentifierProvider, IndexManagerGroupHolder indexManagerGroupHolder, Properties indexProperties, IndexedTypeIdentifier entityType) {
        this.shardIdentifierProvider = shardIdentifierProvider;
        this.indexManagerGroupHolder = indexManagerGroupHolder;
        this.indexProperties = indexProperties;
        this.entityType = entityType;
    }

    @Override
    public Set<IndexManager> all() {
        Set<String> allShardIdentifiers = this.shardIdentifierProvider.getAllShardIdentifiers();
        return this.getIndexManagersFromShards(allShardIdentifiers);
    }

    @Override
    public IndexManager forNew(IndexedTypeIdentifier typeId, Serializable id, String idInString, Document document) {
        String shardIdentifier = this.shardIdentifierProvider.getShardIdentifier(typeId.getPojoType(), id, idInString, document);
        return this.indexManagerGroupHolder.getOrCreateIndexManager(shardIdentifier, this.indexProperties, this.entityType, null);
    }

    @Override
    public Set<IndexManager> forExisting(IndexedTypeIdentifier typeId, Serializable id, String idInString) {
        Set<String> shardIdentifiers = this.shardIdentifierProvider.getShardIdentifiersForDeletion(typeId.getPojoType(), id, idInString);
        return this.getIndexManagersFromShards(shardIdentifiers);
    }

    @Override
    public Set<IndexManager> forFilters(FullTextFilterImplementor[] fullTextFilters) {
        Set<String> shards = this.shardIdentifierProvider.getShardIdentifiersForQuery(fullTextFilters);
        return this.getIndexManagersFromShards(shards);
    }

    private Set<IndexManager> getIndexManagersFromShards(Set<String> shardIdentifiers) {
        HashSet<IndexManager> managers = new HashSet<IndexManager>(shardIdentifiers.size());
        for (String shardIdentifier : shardIdentifiers) {
            managers.add(this.indexManagerGroupHolder.getOrCreateIndexManager(shardIdentifier, this.indexProperties, this.entityType, null));
        }
        return managers;
    }
}

