/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2018, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.clustering.web.infinispan;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.ServiceLoader;

import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.web.IdentifierSerializerProvider;
import org.wildfly.security.manager.WildFlySecurityManager;

/**
 * @author Paul Ferraro
 */
public enum SessionIdentifierSerializer implements Serializer<String> {
    INSTANCE;

    private final Serializer<String> serializer = WildFlySecurityManager.doUnchecked(new PrivilegedAction<Serializer<String>>() {
        @Override
        public Serializer<String> run() {
            Iterator<IdentifierSerializerProvider> providerIterator = ServiceLoader.load(IdentifierSerializerProvider.class, IdentifierSerializerProvider.class.getClassLoader()).iterator();
            if (!providerIterator.hasNext()) {
                throw new IllegalStateException();
            }
            return providerIterator.next().getSerializer();
        }
    });

    @Override
    public void write(DataOutput output, String value) throws IOException {
        this.serializer.write(output, value);
    }

    @Override
    public String read(DataInput input) throws IOException {
        return this.serializer.read(input);
    }
}
