/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.cdi;

import com.arjuna.ats.jta.cdi.AbstractBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;

final class JNDIBean<T>
extends AbstractBean<T> {
    private final String name;
    private final Class<? extends T> type;

    JNDIBean(String name, Class<? extends T> type) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
    }

    JNDIBean(Name name, Class<? extends T> type) {
        this(Objects.requireNonNull(name).toString(), Objects.requireNonNull(type));
    }

    public final T create(CreationalContext<T> cc) {
        try {
            return this.type.cast(((InitialContext)CDI.current().select(InitialContext.class, new Annotation[0]).get()).lookup(this.name));
        }
        catch (NamingException namingException) {
            throw new CreationException(namingException.getMessage(), (Throwable)namingException);
        }
    }

    public final Set<Type> getTypes() {
        return Collections.singleton(this.type);
    }

    @Override
    public final Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    @Override
    protected String getTypeName() {
        return this.type.getName();
    }
}

