/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security.OneTimeSecurityFactory;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.ssl.ConfiguredSSLContextSpi;
import org.wildfly.security.ssl.DelegatingSSLContext;
import org.wildfly.security.ssl.ProtocolSelector;
import org.wildfly.security.ssl.SSLConfigurator;
import org.wildfly.security.ssl.SSLContextSelector;
import org.wildfly.security.ssl.SelectingServerSSLEngine;

public final class SSLUtils {
    private static final String[] NO_STRINGS = new String[0];
    private static final String SERVICE_TYPE = SSLContext.class.getSimpleName();
    public static final String SSL_SESSION_IDENTITY_KEY = "org.wildfly.security.ssl.identity";
    private static final SecurityFactory<X509TrustManager> DEFAULT_TRUST_MANAGER_SECURITY_FACTORY = new OneTimeSecurityFactory<X509TrustManager>(() -> {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw ElytronMessages.log.noDefaultTrustManager();
    });

    private SSLUtils() {
    }

    public static SecurityFactory<SSLContext> createSslContextFactory(ProtocolSelector protocolSelector, Supplier<Provider[]> providerSupplier) {
        return SSLUtils.createSslContextFactory(protocolSelector, providerSupplier, null);
    }

    public static SecurityFactory<SSLContext> createSslContextFactory(ProtocolSelector protocolSelector, Supplier<Provider[]> providerSupplier, String providerName) {
        HashMap<String, List> preferredProviderByAlgorithm = new HashMap<String, List>();
        for (Provider provider : providerSupplier.get()) {
            Set<Provider.Service> services;
            if (providerName != null && !providerName.equals(provider.getName()) || (services = provider.getServices()) == null) continue;
            for (Provider.Service service : services) {
                if (!SERVICE_TYPE.equals(service.getType())) continue;
                String protocolName = service.getAlgorithm();
                List providerList = preferredProviderByAlgorithm.computeIfAbsent(protocolName.toUpperCase(Locale.ENGLISH), s -> new ArrayList());
                providerList.add(provider);
                if (!ElytronMessages.log.isTraceEnabled()) continue;
                ElytronMessages.log.tracef("Provider %s was added for algorithm %s", (Object)provider, (Object)protocolName.toUpperCase(Locale.ENGLISH));
            }
        }
        Object[] supportedProtocols = protocolSelector.evaluate(preferredProviderByAlgorithm.keySet().toArray(NO_STRINGS));
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("Supported protocols are: %s", (Object)Arrays.toString(supportedProtocols));
        }
        if (supportedProtocols.length > 0) {
            return () -> SSLUtils.lambda$createSslContextFactory$1((String[])supportedProtocols, preferredProviderByAlgorithm, providerSupplier);
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by providers in %s: %s", (Object)SERVICE_TYPE, (Object)SSLUtils.class.getSimpleName(), (Object)Arrays.toString(providerSupplier.get()));
        }
        return SSLUtils::throwIt;
    }

    private static SSLContext throwIt() throws NoSuchAlgorithmException {
        throw ElytronMessages.log.noAlgorithmForSslProtocol();
    }

    public static SecurityFactory<SSLContext> createSimpleSslContextFactory(String protocol, Provider provider) {
        return () -> SSLContext.getInstance(protocol, provider);
    }

    public static SSLContext createConfiguredSslContext(SSLContext original, SSLConfigurator sslConfigurator) {
        return SSLUtils.createConfiguredSslContext(original, sslConfigurator, true);
    }

    public static SSLContext createConfiguredSslContext(SSLContext original, SSLConfigurator sslConfigurator, boolean wrap) {
        return new DelegatingSSLContext(new ConfiguredSSLContextSpi(original, sslConfigurator, wrap));
    }

    public static SecurityFactory<SSLContext> createConfiguredSslContextFactory(SecurityFactory<SSLContext> originalFactory, SSLConfigurator sslConfigurator) {
        return () -> SSLUtils.createConfiguredSslContext((SSLContext)originalFactory.create(), sslConfigurator);
    }

    public static SecurityFactory<X509TrustManager> getDefaultX509TrustManagerSecurityFactory() {
        return DEFAULT_TRUST_MANAGER_SECURITY_FACTORY;
    }

    public static SSLEngine createSelectingSSLEngine(SSLContextSelector selector) {
        Assert.checkNotNullParam("selector", selector);
        return new SelectingServerSSLEngine(selector);
    }

    public static SSLEngine createSelectingSSLEngine(SSLContextSelector selector, String host, int port) {
        Assert.checkNotNullParam("selector", selector);
        return new SelectingServerSSLEngine(selector, host, port);
    }

    public static SNIMatcher createHostNamePredicateSNIMatcher(final Predicate<SNIHostName> predicate) {
        Assert.checkNotNullParam("predicate", predicate);
        return new SNIMatcher(0){

            @Override
            public boolean matches(SNIServerName sniServerName) {
                return sniServerName instanceof SNIHostName && predicate.test((SNIHostName)sniServerName);
            }
        };
    }

    public static SNIMatcher createHostNameStringPredicateSNIMatcher(final Predicate<String> predicate) {
        Assert.checkNotNullParam("predicate", predicate);
        return new SNIMatcher(0){

            @Override
            public boolean matches(SNIServerName sniServerName) {
                return sniServerName instanceof SNIHostName && predicate.test(((SNIHostName)sniServerName).getAsciiName());
            }
        };
    }

    public static SNIMatcher createHostNameStringSNIMatcher(String string) {
        Assert.checkNotNullParam("string", string);
        return SSLUtils.createHostNameStringPredicateSNIMatcher(string::equals);
    }

    public static SNIMatcher createHostNameSuffixSNIMatcher(String suffix) {
        Assert.checkNotNullParam("suffix", suffix);
        Assert.checkNotEmptyParam("suffix", suffix);
        String finalSuffix = suffix.startsWith(".") ? suffix : "." + suffix;
        return SSLUtils.createHostNameStringPredicateSNIMatcher(n -> n.endsWith(finalSuffix));
    }

    public static SecurityFactory<SSLEngine> createDispatchingSSLEngineFactory(SSLContextSelector selector) {
        Assert.checkNotNullParam("selector", selector);
        return () -> new SelectingServerSSLEngine(selector);
    }

    public static Object getOrDefault(SSLSession sslSession, String key, Object defaultValue) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        Object value = sslSession.getValue(key);
        return value != null ? value : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object putSessionValueIfAbsent(SSLSession sslSession, String key, Object newValue) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("newValue", newValue);
        SSLSession sSLSession = sslSession;
        synchronized (sSLSession) {
            Object existing = sslSession.getValue(key);
            if (existing == null) {
                sslSession.putValue(key, newValue);
                return null;
            }
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object removeSessionValue(SSLSession sslSession, String key) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        SSLSession sSLSession = sslSession;
        synchronized (sSLSession) {
            Object existing = sslSession.getValue(key);
            sslSession.removeValue(key);
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSessionValue(SSLSession sslSession, String key, Object value) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("value", value);
        SSLSession sSLSession = sslSession;
        synchronized (sSLSession) {
            Object existing = sslSession.getValue(key);
            if (Objects.equals(existing, value)) {
                sslSession.removeValue(key);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object replaceSessionValue(SSLSession sslSession, String key, Object newValue) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("newValue", newValue);
        SSLSession sSLSession = sslSession;
        synchronized (sSLSession) {
            Object existing = sslSession.getValue(key);
            if (existing != null) {
                sslSession.putValue(key, newValue);
            }
            return existing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replaceSessionValue(SSLSession sslSession, String key, Object oldValue, Object newValue) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("oldValue", oldValue);
        Assert.checkNotNullParam("newValue", newValue);
        SSLSession sSLSession = sslSession;
        synchronized (sSLSession) {
            Object existing = sslSession.getValue(key);
            if (Objects.equals(existing, oldValue)) {
                sslSession.putValue(key, newValue);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R computeIfAbsent(SSLSession sslSession, String key, Function<String, R> mappingFunction) {
        Assert.checkNotNullParam("sslSession", sslSession);
        Assert.checkNotNullParam("key", key);
        Assert.checkNotNullParam("mappingFunction", mappingFunction);
        SSLSession sSLSession = sslSession;
        synchronized (sSLSession) {
            Object existing = sslSession.getValue(key);
            if (existing == null) {
                R newValue = mappingFunction.apply(key);
                Assert.assertNotNull(newValue);
                sslSession.putValue(key, newValue);
                return newValue;
            }
            return (R)existing;
        }
    }

    private static /* synthetic */ SSLContext lambda$createSslContextFactory$1(String[] supportedProtocols, Map preferredProviderByAlgorithm, Supplier providerSupplier) throws GeneralSecurityException {
        for (String protocol : supportedProtocols) {
            List providerList = preferredProviderByAlgorithm.getOrDefault(protocol.toUpperCase(Locale.ENGLISH), Collections.emptyList());
            if (ElytronMessages.log.isTraceEnabled() && providerList.isEmpty()) {
                ElytronMessages.log.tracef("No providers are available for protocol %s", (Object)protocol);
            }
            for (Provider provider : providerList) {
                try {
                    if (ElytronMessages.log.isTraceEnabled()) {
                        ElytronMessages.log.tracef("Attempting to get an SSLContext instance using protocol %s and provider %s", (Object)protocol, (Object)provider);
                    }
                    return SSLContext.getInstance(protocol, provider);
                }
                catch (NoSuchAlgorithmException ignored) {
                    if (!ElytronMessages.log.isTraceEnabled()) continue;
                    ElytronMessages.log.tracef((Throwable)ignored, "Provider %s has no such protocol %s", (Object)provider, (Object)protocol);
                }
            }
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.tracef("No %s provided by providers in %s: %s", (Object)SERVICE_TYPE, (Object)SSLUtils.class.getSimpleName(), (Object)Arrays.toString((Object[])providerSupplier.get()));
        }
        throw ElytronMessages.log.noAlgorithmForSslProtocol();
    }
}

