/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.extension.clustering.singleton.SingletonDeploymentResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonServiceResourceDefinition;

public class SingletonPolicyResource
extends DelegatingResource
implements Registrar<ServiceName> {
    private static final String DEPLOYMENT_CHILD_TYPE = SingletonDeploymentResourceDefinition.WILDCARD_PATH.getKey();
    private static final String SERVICE_CHILD_TYPE = SingletonServiceResourceDefinition.WILDCARD_PATH.getKey();
    final Set<ServiceName> services;
    final Set<String> deployments;

    public SingletonPolicyResource(Resource resource) {
        this(resource, ConcurrentHashMap.newKeySet(), ConcurrentHashMap.newKeySet());
    }

    private SingletonPolicyResource(Resource resource, Set<ServiceName> services, Set<String> deployments) {
        super(resource);
        this.services = services;
        this.deployments = deployments;
    }

    public Registration register(final ServiceName service) {
        if (Services.JBOSS_DEPLOYMENT.isParentOf(service)) {
            final String deploymentName = SingletonDeploymentResourceDefinition.pathElement(service).getValue();
            this.deployments.add(deploymentName);
            return new Registration(){

                public void close() {
                    SingletonPolicyResource.this.deployments.remove(deploymentName);
                }
            };
        }
        this.services.add(service);
        return new Registration(){

            public void close() {
                SingletonPolicyResource.this.services.remove(service);
            }
        };
    }

    public Resource clone() {
        return new SingletonPolicyResource(super.clone(), this.services, this.deployments);
    }

    public Resource getChild(PathElement path) {
        String childType = path.getKey();
        if (childType.equals(DEPLOYMENT_CHILD_TYPE)) {
            return this.deployments.contains(path.getValue()) ? PlaceholderResource.INSTANCE : null;
        }
        if (childType.equals(SERVICE_CHILD_TYPE)) {
            return this.services.contains(ServiceName.parse((String)path.getValue())) ? PlaceholderResource.INSTANCE : null;
        }
        return super.getChild(path);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if (childType.equals(DEPLOYMENT_CHILD_TYPE)) {
            HashSet<Resource.ResourceEntry> entries = new HashSet<Resource.ResourceEntry>();
            for (String deployment : this.deployments) {
                entries.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry(SingletonDeploymentResourceDefinition.pathElement(deployment)));
            }
            return entries;
        }
        if (childType.equals(SERVICE_CHILD_TYPE)) {
            HashSet<Resource.ResourceEntry> entries = new HashSet<Resource.ResourceEntry>();
            for (ServiceName service : this.services) {
                entries.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry(SingletonServiceResourceDefinition.pathElement(service)));
            }
            return entries;
        }
        return super.getChildren(childType);
    }

    public Set<String> getChildrenNames(String childType) {
        if (childType.equals(DEPLOYMENT_CHILD_TYPE)) {
            return this.deployments;
        }
        if (childType.equals(SERVICE_CHILD_TYPE)) {
            HashSet<String> names = new HashSet<String>();
            for (ServiceName service : this.services) {
                names.add(SingletonServiceResourceDefinition.pathElement(service).getValue());
            }
            return names;
        }
        return super.getChildrenNames(childType);
    }

    public Set<String> getChildTypes() {
        HashSet<String> childTypes = new HashSet<String>(super.getChildTypes());
        childTypes.add(DEPLOYMENT_CHILD_TYPE);
        childTypes.add(SERVICE_CHILD_TYPE);
        return childTypes;
    }

    public boolean hasChild(PathElement path) {
        String childType = path.getKey();
        if (childType.equals(DEPLOYMENT_CHILD_TYPE)) {
            return this.deployments.contains(path.getValue());
        }
        if (childType.equals(SERVICE_CHILD_TYPE)) {
            return this.services.contains(ServiceName.parse((String)path.getValue()));
        }
        return super.hasChild(path);
    }

    public boolean hasChildren(String childType) {
        if (childType.equals(DEPLOYMENT_CHILD_TYPE)) {
            return !this.deployments.isEmpty();
        }
        if (childType.equals(SERVICE_CHILD_TYPE)) {
            return !this.services.isEmpty();
        }
        return super.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        return address.size() == 1 ? this.requireChild(address.getLastElement()) : super.navigate(address);
    }

    public Resource requireChild(PathElement path) {
        Resource resource = this.getChild(path);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(path);
        }
        return resource;
    }
}

