/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.OperationTransformationOverrideBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.domain.controller.resources.DomainResolver;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.process.ProcessInfo;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DomainServerLifecycleHandlers {
    private static final AttributeDefinition BLOCKING = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"blocking", (ModelType)ModelType.BOOLEAN, (boolean)true).setDefaultValue(new ModelNode(false))).build();
    private static final AttributeDefinition START_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"start-mode", (ModelType)ModelType.STRING, (boolean)true).setDefaultValue(new ModelNode(StartMode.NORMAL.toString()))).setValidator((ParameterValidator)new EnumValidator(StartMode.class, true, true))).build();
    @Deprecated
    private static final AttributeDefinition TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timeout", (ModelType)ModelType.INT, (boolean)true).setMeasurementUnit(MeasurementUnit.SECONDS)).setDefaultValue(new ModelNode(0))).setAlternatives(new String[]{"suspend-timeout"})).setDeprecated(ModelVersion.create((int)9, (int)0))).build();
    private static final AttributeDefinition SUSPEND_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"suspend-timeout", (ModelType)ModelType.INT, (boolean)true).setMeasurementUnit(MeasurementUnit.SECONDS)).setAlternatives(new String[]{"timeout"})).setDefaultValue(new ModelNode(0))).build();
    private static final AttributeDefinition HOST_SUSPEND_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"suspend-timeout", (ModelType)ModelType.INT, (boolean)true).setMeasurementUnit(MeasurementUnit.SECONDS)).setDefaultValue(new ModelNode(0))).build();
    public static final String RESTART_SERVERS_NAME = "restart-servers";
    public static final String START_SERVERS_NAME = "start-servers";
    public static final String STOP_SERVERS_NAME = "stop-servers";
    public static final String SUSPEND_SERVERS_NAME = "suspend-servers";
    public static final String RESUME_SERVERS_NAME = "resume-servers";
    public static final String KILL_SERVERS_NAME = "kill-servers";
    public static final String DESTROY_SERVERS_NAME = "destroy-servers";

    public static void initializeServerInventory(ServerInventory serverInventory) {
        StopServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        StartServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        RestartServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        ReloadServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        SuspendServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        ResumeServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        KillServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        DestroyServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        HostSuspendServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
        HostResumeServersLifecycleHandler.INSTANCE.setServerInventory(serverInventory);
    }

    public static void registerDomainHandlers(ManagementResourceRegistration registration) {
        DomainServerLifecycleHandlers.registerHandlers(registration, false);
    }

    public static void registerServerGroupHandlers(ManagementResourceRegistration registration) {
        DomainServerLifecycleHandlers.registerHandlers(registration, true);
    }

    public static void registerHostHandlers(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getHostSuspendOperationDefinition(SUSPEND_SERVERS_NAME), (OperationStepHandler)HostSuspendServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getHostResumeOperationDefinition(RESUME_SERVERS_NAME), (OperationStepHandler)HostResumeServersLifecycleHandler.INSTANCE);
    }

    private static void registerHandlers(ManagementResourceRegistration registration, boolean serverGroup) {
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getStopOperationDefinition(serverGroup, STOP_SERVERS_NAME), (OperationStepHandler)StopServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, START_SERVERS_NAME), (OperationStepHandler)StartServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, RESTART_SERVERS_NAME), (OperationStepHandler)RestartServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getOperationDefinition(serverGroup, "reload-servers"), (OperationStepHandler)ReloadServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getSuspendOperationDefinition(serverGroup, SUSPEND_SERVERS_NAME), (OperationStepHandler)SuspendServersLifecycleHandler.INSTANCE);
        registration.registerOperationHandler(DomainServerLifecycleHandlers.getSuspendOperationDefinition(serverGroup, RESUME_SERVERS_NAME), (OperationStepHandler)ResumeServersLifecycleHandler.INSTANCE);
        if (serverGroup) {
            registration.registerOperationHandler(DomainServerLifecycleHandlers.getKillDestroyOperationDefinition(KILL_SERVERS_NAME), (OperationStepHandler)KillServersLifecycleHandler.INSTANCE);
            registration.registerOperationHandler(DomainServerLifecycleHandlers.getKillDestroyOperationDefinition(DESTROY_SERVERS_NAME), (OperationStepHandler)DestroyServersLifecycleHandler.INSTANCE);
        }
    }

    private static OperationDefinition getKillDestroyOperationDefinition(String operationName) {
        return new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver("server-group")).setRuntimeOnly().build();
    }

    private static OperationDefinition getOperationDefinition(boolean serverGroup, String operationName) {
        return new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).addParameter(BLOCKING).addParameter(START_MODE).setRuntimeOnly().build();
    }

    private static OperationDefinition getStopOperationDefinition(boolean serverGroup, String operationName) {
        return new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).addParameter(BLOCKING).addParameter(TIMEOUT).addParameter(SUSPEND_TIMEOUT).setRuntimeOnly().build();
    }

    private static OperationDefinition getSuspendOperationDefinition(boolean serverGroup, String operationName) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(operationName, DomainResolver.getResolver(serverGroup ? "server-group" : "domain")).setRuntimeOnly();
        if (operationName.equals(SUSPEND_SERVERS_NAME)) {
            builder.setParameters(new AttributeDefinition[]{TIMEOUT}).addParameter(SUSPEND_TIMEOUT);
        }
        return builder.build();
    }

    private static OperationDefinition getHostSuspendOperationDefinition(String operationName) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(operationName, HostResolver.getResolver("host")).addParameter(HOST_SUSPEND_TIMEOUT).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly();
        return builder.build();
    }

    private static OperationDefinition getHostResumeOperationDefinition(String operationName) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(operationName, HostResolver.getResolver("host")).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).setRuntimeOnly();
        return builder.build();
    }

    public static void registerServerLifeCycleOperationsTransformers(ResourceTransformationDescriptionBuilder builder) {
        ((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)builder.addOperationTransformationOverride(SUSPEND_SERVERS_NAME).setReject().end().discardOperations(new String[]{RESUME_SERVERS_NAME}).addOperationTransformationOverride(STOP_SERVERS_NAME).addRename(SUSPEND_TIMEOUT, TIMEOUT.getName())).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{TIMEOUT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{SUSPEND_TIMEOUT})).end();
    }

    public static void registerSuspendedStartTransformers(ResourceTransformationDescriptionBuilder builder) {
        ((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)builder.addOperationTransformationOverride(START_SERVERS_NAME).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(StartMode.NORMAL.toString())}), new AttributeDefinition[]{START_MODE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{START_MODE})).end().addOperationTransformationOverride("reload-servers").setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(StartMode.NORMAL.toString())}), new AttributeDefinition[]{START_MODE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{START_MODE})).end().addOperationTransformationOverride(RESTART_SERVERS_NAME).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(StartMode.NORMAL.toString())}), new AttributeDefinition[]{START_MODE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{START_MODE})).end();
    }

    public static void registerKillDestroyTransformers(ResourceTransformationDescriptionBuilder builder) {
        builder.addOperationTransformationOverride(KILL_SERVERS_NAME).setReject().end().addOperationTransformationOverride(DESTROY_SERVERS_NAME).setReject().end();
    }

    public static void registerTimeoutToSuspendTimeoutRename(ResourceTransformationDescriptionBuilder builder) {
        ((OperationTransformationOverrideBuilder)((OperationTransformationOverrideBuilder)builder.addOperationTransformationOverride(SUSPEND_SERVERS_NAME).addRename(SUSPEND_TIMEOUT, TIMEOUT.getName())).end().addOperationTransformationOverride(STOP_SERVERS_NAME).addRename(SUSPEND_TIMEOUT, TIMEOUT.getName())).end();
    }

    private static void renameTimeoutToSuspendTimeout(ModelNode operation) {
        if (!operation.hasDefined(SUSPEND_TIMEOUT.getName()) && operation.hasDefined(TIMEOUT.getName())) {
            operation.get(SUSPEND_TIMEOUT.getName()).set(operation.get(TIMEOUT.getName()));
            operation.remove(TIMEOUT.getName());
        }
    }

    static enum StartMode {
        NORMAL("normal"),
        SUSPEND("suspend");

        private final String localName;

        private StartMode(String localName) {
            this.localName = localName;
        }

        public String toString() {
            return this.localName;
        }
    }

    private static class HostResumeServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "resume-servers";
        static final HostResumeServersLifecycleHandler INSTANCE = new HostResumeServersLifecycleHandler();

        private HostResumeServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            final Resource hostResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Set<String> servers = this.getServersForHost(hostResource);
                    List<ModelNode> errorResponses = serverInventory.resumeServers(servers, blockingTimeout);
                    if (!errorResponses.isEmpty()) {
                        context.getFailureDescription().set(errorResponses);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class HostSuspendServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "suspend-servers";
        static final HostSuspendServersLifecycleHandler INSTANCE = new HostSuspendServersLifecycleHandler();

        private HostSuspendServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            final Resource hostResource = context.readResource(PathAddress.EMPTY_ADDRESS);
            final int suspendTimeout = HOST_SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
            final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Set<String> servers = this.getServersForHost(hostResource);
                    List<ModelNode> errorResponses = serverInventory.suspendServers(servers, suspendTimeout, blockingTimeout);
                    if (!errorResponses.isEmpty()) {
                        context.getFailureDescription().set(errorResponses);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class DestroyServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "destroy-servers";
        static final DestroyServersLifecycleHandler INSTANCE = new DestroyServersLifecycleHandler();

        private DestroyServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                            Set<String> serversInGroup = this.getServersForGroup(model, group);
                            HashSet<String> serversToDestroy = new HashSet<String>();
                            for (String serverName : processes.keySet()) {
                                String serverModelName = serverInventory.getProcessServerName(serverName);
                                if (group != null && !serversInGroup.contains(serverModelName)) continue;
                                serversToDestroy.add(serverModelName);
                            }
                            for (String s : serversToDestroy) {
                                serverInventory.destroyServer(s);
                            }
                            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class KillServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "kill-servers";
        static final KillServersLifecycleHandler INSTANCE = new KillServersLifecycleHandler();

        private KillServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.authorize(operation, EnumSet.of(Action.ActionEffect.WRITE_RUNTIME));
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                            Set<String> serversInGroup = this.getServersForGroup(model, group);
                            HashSet<String> serversToKill = new HashSet<String>();
                            for (String serverName : processes.keySet()) {
                                String serverModelName = serverInventory.getProcessServerName(serverName);
                                if (group != null && !serversInGroup.contains(serverModelName)) continue;
                                serversToKill.add(serverModelName);
                            }
                            for (String s : serversToKill) {
                                serverInventory.killServer(s);
                            }
                            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class ResumeServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "resume-servers";
        static final ResumeServersLifecycleHandler INSTANCE = new ResumeServersLifecycleHandler();

        private ResumeServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        waitForServers.add(serverModelName);
                    }
                    List<ModelNode> errorResponses = serverInventory.resumeServers(waitForServers, blockingTimeout);
                    if (!errorResponses.isEmpty()) {
                        context.getFailureDescription().set(errorResponses);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class SuspendServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "suspend-servers";
        static final SuspendServersLifecycleHandler INSTANCE = new SuspendServersLifecycleHandler();

        private SuspendServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            DomainServerLifecycleHandlers.renameTimeoutToSuspendTimeout(operation);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final int suspendTimeout = SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
            final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        waitForServers.add(serverModelName);
                    }
                    List<ModelNode> errorResponses = serverInventory.suspendServers(waitForServers, suspendTimeout, blockingTimeout);
                    if (!errorResponses.isEmpty()) {
                        context.getFailureDescription().set(errorResponses);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class ReloadServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "reload-servers";
        static final ReloadServersLifecycleHandler INSTANCE = new ReloadServersLifecycleHandler();

        private ReloadServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            final boolean suspend = START_MODE.resolveModelAttribute(context, operation).asString().toLowerCase(Locale.ENGLISH).equals(StartMode.SUSPEND.toString());
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        serverInventory.reloadServer(serverModelName, false, suspend);
                        waitForServers.add(serverModelName);
                    }
                    if (blocking) {
                        serverInventory.awaitServersState(waitForServers, true);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class RestartServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "restart-servers";
        static final RestartServersLifecycleHandler INSTANCE = new RestartServersLifecycleHandler();

        private RestartServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            final boolean suspend = START_MODE.resolveModelAttribute(context, operation).asString().toLowerCase(Locale.ENGLISH).equals(StartMode.SUSPEND.toString());
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    Map<String, ProcessInfo> processes = serverInventory.determineRunningProcesses(true);
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    for (String serverName : processes.keySet()) {
                        String serverModelName = serverInventory.getProcessServerName(serverName);
                        if (group != null && !serversInGroup.contains(serverModelName)) continue;
                        serverInventory.restartServer(serverModelName, 0, model, false, suspend);
                        waitForServers.add(serverModelName);
                    }
                    if (blocking) {
                        serverInventory.awaitServersState(waitForServers, true);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class StartServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "start-servers";
        static final StartServersLifecycleHandler INSTANCE = new StartServersLifecycleHandler();

        private StartServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
                throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
            }
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            final ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            final boolean suspend = START_MODE.resolveModelAttribute(context, operation).asString().toLowerCase(Locale.ENGLISH).equals(StartMode.SUSPEND.toString());
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    String hostName = (String)model.get("host").keys().iterator().next();
                    ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
                    Set<String> serversInGroup = this.getServersForGroup(model, group);
                    HashSet<String> waitForServers = new HashSet<String>();
                    if (serverConfig.isDefined()) {
                        context.getServiceRegistry(true);
                        for (Property config : serverConfig.asPropertyList()) {
                            ServerStatus status = serverInventory.determineServerStatus(config.getName());
                            if (status == ServerStatus.STARTING || status == ServerStatus.STARTED || group != null && !serversInGroup.contains(config.getName())) continue;
                            if (status != ServerStatus.STOPPED) {
                                serverInventory.stopServer(config.getName(), 0);
                            }
                            serverInventory.startServer(config.getName(), model, false, suspend);
                            waitForServers.add(config.getName());
                        }
                        if (blocking) {
                            serverInventory.awaitServersState(waitForServers, true);
                        }
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static class StopServersLifecycleHandler
    extends AbstractHackLifecycleHandler {
        static final String OPERATION_NAME = "stop-servers";
        static final StopServersLifecycleHandler INSTANCE = new StopServersLifecycleHandler();

        private StopServersLifecycleHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.acquireControllerLock();
            context.readResource(PathAddress.EMPTY_ADDRESS, false);
            DomainServerLifecycleHandlers.renameTimeoutToSuspendTimeout(operation);
            final String group = this.getServerGroupName(operation);
            final boolean blocking = BLOCKING.resolveModelAttribute(context, operation).asBoolean();
            final int suspendTimeout = SUSPEND_TIMEOUT.resolveModelAttribute(context, operation).asInt();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.getServiceRegistry(true);
                    if (group != null) {
                        HashSet<String> waitForServers = new HashSet<String>();
                        ModelNode model = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true));
                        for (String server : this.getServersForGroup(model, group)) {
                            serverInventory.stopServer(server, suspendTimeout);
                            waitForServers.add(server);
                        }
                        if (blocking) {
                            serverInventory.awaitServersState(waitForServers, false);
                        }
                    } else {
                        serverInventory.stopServers(suspendTimeout, blocking);
                    }
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    private static abstract class AbstractHackLifecycleHandler
    implements OperationStepHandler {
        volatile ServerInventory serverInventory;

        protected AbstractHackLifecycleHandler() {
        }

        void setServerInventory(ServerInventory serverInventory) {
            this.serverInventory = serverInventory;
        }

        String getServerGroupName(ModelNode operation) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            if (address.size() == 0) {
                return null;
            }
            return address.getLastElement().getValue();
        }

        Set<String> getServersForGroup(ModelNode model, String groupName) {
            if (groupName == null) {
                return Collections.emptySet();
            }
            String hostName = (String)model.get("host").keys().iterator().next();
            ModelNode serverConfig = model.get(new String[]{"host", hostName}).get("server-config");
            if (!serverConfig.isDefined()) {
                return Collections.emptySet();
            }
            HashSet<String> servers = new HashSet<String>();
            for (Property config : serverConfig.asPropertyList()) {
                if (!groupName.equals(config.getValue().get("group").asString())) continue;
                servers.add(config.getName());
            }
            return servers;
        }

        Set<String> getServersForHost(Resource hostResource) {
            HashSet<String> servers = new HashSet<String>();
            ModelNode hostModel = Resource.Tools.readModel((Resource)hostResource);
            ModelNode serverConfig = hostModel.get("server-config");
            if (serverConfig.isDefined()) {
                for (Property config : serverConfig.asPropertyList()) {
                    servers.add(config.getName());
                }
            }
            return servers;
        }
    }
}

