/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.interfaces.UnixSHACryptPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.util.PasswordUtil;

final class UnixSHACryptPasswordImpl
extends AbstractPasswordImpl
implements UnixSHACryptPassword {
    private static final long serialVersionUID = 1414406780966627792L;
    private final String algorithm;
    private final byte[] salt;
    private final int iterationCount;
    private final byte[] hash;

    UnixSHACryptPasswordImpl(UnixSHACryptPassword password) {
        this(password.getAlgorithm(), UnixSHACryptPasswordImpl.truncatedClone(password.getSalt()), password.getIterationCount(), (byte[])password.getHash().clone());
    }

    UnixSHACryptPasswordImpl(String algorithm, byte[] clonedSalt, int iterationCount, byte[] hash) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        if (!"crypt-sha-256".equals(algorithm) && !"crypt-sha-512".equals(algorithm)) {
            throw ElytronMessages.log.unrecognizedAlgorithm(algorithm);
        }
        this.salt = clonedSalt;
        this.iterationCount = iterationCount;
        this.algorithm = algorithm;
        this.hash = hash;
    }

    UnixSHACryptPasswordImpl(String algorithm, char[] passwordChars) throws NoSuchAlgorithmException {
        this(algorithm, PasswordUtil.generateRandomSalt(16), 5000, passwordChars);
    }

    UnixSHACryptPasswordImpl(String algorithm, IteratedSaltedHashPasswordSpec spec) {
        this(algorithm, UnixSHACryptPasswordImpl.truncatedClone(spec.getSalt()), Math.min(999999999, Math.max(1000, spec.getIterationCount())), (byte[])spec.getHash().clone());
    }

    UnixSHACryptPasswordImpl(String algorithm, SaltedHashPasswordSpec spec) {
        this(algorithm, UnixSHACryptPasswordImpl.truncatedClone(spec.getSalt()), Math.min(999999999, Math.max(1000, 5000)), (byte[])spec.getHash().clone());
    }

    UnixSHACryptPasswordImpl(String algorithm, ClearPasswordSpec spec) throws NoSuchAlgorithmException {
        this(algorithm, spec.getEncodedPassword());
    }

    UnixSHACryptPasswordImpl(String algorithm, IteratedSaltedPasswordAlgorithmSpec parameterSpec, char[] password) throws NoSuchAlgorithmException {
        this(algorithm, UnixSHACryptPasswordImpl.truncatedClone(parameterSpec.getSalt()), Math.min(999999999, Math.max(1000, parameterSpec.getIterationCount())), password);
    }

    UnixSHACryptPasswordImpl(String algorithm, SaltedPasswordAlgorithmSpec parameterSpec, char[] password) throws NoSuchAlgorithmException {
        this(algorithm, UnixSHACryptPasswordImpl.truncatedClone(parameterSpec.getSalt()), 5000, password);
    }

    UnixSHACryptPasswordImpl(String algorithm, IteratedPasswordAlgorithmSpec parameterSpec, char[] password) throws NoSuchAlgorithmException {
        this(algorithm, PasswordUtil.generateRandomSalt(16), Math.min(999999999, Math.max(1000, parameterSpec.getIterationCount())), password);
    }

    UnixSHACryptPasswordImpl(String algorithm, byte[] clonedSalt, int adjustedIterationCount, char[] password) throws NoSuchAlgorithmException {
        this(algorithm, clonedSalt, adjustedIterationCount, UnixSHACryptPasswordImpl.doEncode(algorithm, UnixSHACryptPasswordImpl.getNormalizedPasswordBytes(password), clonedSalt, adjustedIterationCount));
    }

    private static byte[] truncatedClone(byte[] salt) {
        if (salt.length <= 16) {
            return (byte[])salt.clone();
        }
        return Arrays.copyOf(salt, 16);
    }

    @Override
    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    @Override
    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(IteratedSaltedHashPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new IteratedSaltedHashPasswordSpec(this.getHash(), this.getSalt(), this.getIterationCount())));
        }
        throw ElytronMessages.log.invalidKeySpecExpectedSpecGotSpec(IteratedSaltedHashPasswordSpec.class.getName(), keySpecType.getName());
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            byte[] password = UnixSHACryptPasswordImpl.getNormalizedPasswordBytes(guess);
            byte[] encodedGuess = UnixSHACryptPasswordImpl.doEncode(this.algorithm, password, this.salt, this.iterationCount);
            return Arrays.equals(this.getHash(), encodedGuess);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeyCannotVerifyPassword(e);
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(IteratedSaltedHashPasswordSpec.class);
    }

    static byte[] doEncode(String algorithm, byte[] password, byte[] salt, int iterationCount) throws NoSuchAlgorithmException {
        byte[] digestAC = UnixSHACryptPasswordImpl.getDigestA(algorithm, password, salt);
        byte[] sequenceP = UnixSHACryptPasswordImpl.getSequenceP(algorithm, password);
        byte[] sequenceS = UnixSHACryptPasswordImpl.getSequenceS(algorithm, digestAC, salt);
        for (int i = 0; i < iterationCount; ++i) {
            digestAC = UnixSHACryptPasswordImpl.getDigestC(algorithm, digestAC, sequenceP, sequenceS, i);
        }
        return digestAC;
    }

    private static byte[] getDigestA(String algorithm, byte[] password, byte[] salt) throws NoSuchAlgorithmException {
        byte[] digestBResult = UnixSHACryptPasswordImpl.getDigestB(password, salt, algorithm);
        int length = password.length;
        MessageDigest digestA = UnixSHACryptPasswordImpl.getMessageDigest(algorithm);
        digestA.update(password, 0, length);
        digestA.update(salt, 0, salt.length);
        int numberOfBlocksPassword = length / UnixSHACryptPasswordImpl.getInputSize(algorithm);
        for (int i = 0; i < numberOfBlocksPassword; ++i) {
            digestA.update(digestBResult, 0, UnixSHACryptPasswordImpl.getInputSize(algorithm));
        }
        int remainingBytesSizePassword = length % UnixSHACryptPasswordImpl.getInputSize(algorithm);
        digestA.update(digestBResult, 0, remainingBytesSizePassword);
        for (int i = length; i > 0; i >>= 1) {
            if (i % 2 != 0) {
                digestA.update(digestBResult, 0, UnixSHACryptPasswordImpl.getInputSize(algorithm));
                continue;
            }
            digestA.update(password, 0, length);
        }
        return digestA.digest();
    }

    private static byte[] getSequenceS(String algorithm, byte[] digestA, byte[] salt) throws NoSuchAlgorithmException {
        byte[] sequenceS = new byte[salt.length];
        byte[] digestDSResult = UnixSHACryptPasswordImpl.getDigestDS(algorithm, digestA, salt);
        ByteBuffer bufferSequenceS = ByteBuffer.wrap(sequenceS);
        int numberOfBlocksSalt = salt.length / UnixSHACryptPasswordImpl.getInputSize(algorithm);
        int remainingBytesSizeSalt = salt.length % UnixSHACryptPasswordImpl.getInputSize(algorithm);
        for (int i = 0; i < numberOfBlocksSalt; ++i) {
            bufferSequenceS.put(Arrays.copyOfRange(digestDSResult, 0, UnixSHACryptPasswordImpl.getInputSize(algorithm)));
        }
        bufferSequenceS.put(Arrays.copyOfRange(digestDSResult, 0, remainingBytesSizeSalt));
        return sequenceS;
    }

    private static byte[] getDigestDS(String algorithm, byte[] digestA, byte[] salt) throws NoSuchAlgorithmException {
        MessageDigest digestDS = UnixSHACryptPasswordImpl.getMessageDigest(algorithm);
        int repeatTimes = 16 + (digestA[0] & 0xFF);
        for (int i = 0; i < repeatTimes; ++i) {
            digestDS.update(salt, 0, salt.length);
        }
        return digestDS.digest();
    }

    private static byte[] getDigestB(byte[] password, byte[] salt, String algorithm) throws NoSuchAlgorithmException {
        MessageDigest digestB = UnixSHACryptPasswordImpl.getMessageDigest(algorithm);
        digestB.update(password, 0, password.length);
        digestB.update(salt, 0, salt.length);
        digestB.update(password, 0, password.length);
        return digestB.digest();
    }

    private static byte[] getDigestDP(String algorithm, byte[] password) throws NoSuchAlgorithmException {
        MessageDigest digestDP = UnixSHACryptPasswordImpl.getMessageDigest(algorithm);
        for (byte ignored : password) {
            digestDP.update(password, 0, password.length);
        }
        return digestDP.digest();
    }

    private static byte[] getSequenceP(String algorithm, byte[] password) throws NoSuchAlgorithmException {
        byte[] digestDPResult = UnixSHACryptPasswordImpl.getDigestDP(algorithm, password);
        byte[] sequenceP = new byte[password.length];
        ByteBuffer bufferSequenceP = ByteBuffer.wrap(sequenceP);
        int numberOfBlocksPassword = password.length / UnixSHACryptPasswordImpl.getInputSize(algorithm);
        for (int i = 0; i < numberOfBlocksPassword; ++i) {
            bufferSequenceP.put(Arrays.copyOfRange(digestDPResult, 0, UnixSHACryptPasswordImpl.getInputSize(algorithm)));
        }
        int remainingBytesSizePassword = password.length % UnixSHACryptPasswordImpl.getInputSize(algorithm);
        bufferSequenceP.put(Arrays.copyOfRange(digestDPResult, 0, remainingBytesSizePassword));
        return sequenceP;
    }

    private static byte[] getDigestC(String algorithm, byte[] digestAC, byte[] sequenceP, byte[] sequenceS, int round) throws NoSuchAlgorithmException {
        MessageDigest digestC = UnixSHACryptPasswordImpl.getMessageDigest(algorithm);
        if (round % 2 != 0) {
            digestC.update(sequenceP, 0, sequenceP.length);
        } else {
            digestC.update(digestAC, 0, digestAC.length);
        }
        if (round % 3 != 0) {
            digestC.update(sequenceS, 0, sequenceS.length);
        }
        if (round % 7 != 0) {
            digestC.update(sequenceP, 0, sequenceP.length);
        }
        if (round % 2 != 0) {
            digestC.update(digestAC, 0, digestAC.length);
        } else {
            digestC.update(sequenceP, 0, sequenceP.length);
        }
        return digestC.digest();
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "crypt-sha-256": {
                return MessageDigest.getInstance("SHA-256");
            }
            case "crypt-sha-512": {
                return MessageDigest.getInstance("SHA-512");
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    private static int getInputSize(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "crypt-sha-256": {
                return 32;
            }
            case "crypt-sha-512": {
                return 64;
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)HashMath.multiHashOrdered((int)Arrays.hashCode(this.hash), (int)Arrays.hashCode(this.salt)), (int)this.iterationCount), (int)this.algorithm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnixSHACryptPasswordImpl)) {
            return false;
        }
        UnixSHACryptPasswordImpl other = (UnixSHACryptPasswordImpl)obj;
        return this.iterationCount == other.iterationCount && this.algorithm.equals(other.algorithm) && Arrays.equals(this.hash, other.hash) && Arrays.equals(this.salt, other.salt);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return UnixSHACryptPassword.createRaw(this.algorithm, this.salt, this.hash, this.iterationCount);
    }

    @Override
    public UnixSHACryptPasswordImpl clone() {
        return this;
    }
}

