/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.common.net.URIs;
import org.wildfly.security.auth.client.MatchNoUserRule;
import org.wildfly.security.auth.client.MatchRule;

class MatchUserRule
extends MatchRule {
    private final String userSpec;

    MatchUserRule(MatchRule parent, String userSpec) {
        super(parent.without(MatchNoUserRule.class));
        this.userSpec = userSpec;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String userInfo = URIs.getUserFromURI((URI)uri);
        return userInfo != null && userInfo.equals(this.userSpec) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchUserRule(newParent, this.userSpec);
    }

    @Override
    public String getMatchUser() {
        return this.userSpec;
    }

    @Override
    public boolean isUserMatched() {
        return true;
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.userSpec.equals(other.getMatchUser());
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)3323, (int)this.userSpec.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("user=").append(this.userSpec).append(',');
    }
}

