/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.SessionAttributesFactory;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

@Listener(sync=false)
public class CoarseSessionAttributesFactory<V>
implements SessionAttributesFactory<Map.Entry<Map<String, Object>, V>> {
    private final Cache<SessionAttributesKey, V> cache;
    private final Marshaller<Map<String, Object>, V> marshaller;
    private final CacheProperties properties;
    private final Immutability immutability;

    public CoarseSessionAttributesFactory(Cache<SessionAttributesKey, V> cache, Marshaller<Map<String, Object>, V> marshaller, Immutability immutability, CacheProperties properties) {
        this.cache = cache;
        this.marshaller = marshaller;
        this.immutability = immutability;
        this.properties = properties;
    }

    public Map.Entry<Map<String, Object>, V> createValue(String id, Void context) {
        AbstractMap attributes = this.properties.isLockOnRead() ? new HashMap() : new ConcurrentHashMap();
        Object value = this.marshaller.write(attributes);
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)new SessionAttributesKey(id), value);
        return new AbstractMap.SimpleImmutableEntry(attributes, value);
    }

    public Map.Entry<Map<String, Object>, V> findValue(String id) {
        Object value = this.cache.get((Object)new SessionAttributesKey(id));
        if (value != null) {
            try {
                Map attributes = (Map)this.marshaller.read(value);
                return new AbstractMap.SimpleImmutableEntry<Map, Object>(attributes, value);
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                this.remove(id);
            }
        }
        return null;
    }

    public boolean remove(String id) {
        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributesKey(id));
        return true;
    }

    @Override
    public SessionAttributes createSessionAttributes(String id, Map.Entry<Map<String, Object>, V> entry) {
        SessionAttributesKey key = new SessionAttributesKey(id);
        CacheEntryMutator mutator = this.properties.isTransactional() && this.cache.getAdvancedCache().getCacheEntry((Object)key).isCreated() ? Mutator.PASSIVE : new CacheEntryMutator(this.cache, (Object)key, entry.getValue());
        return new CoarseSessionAttributes(entry.getKey(), (Mutator)mutator, (Marshallability)this.marshaller, this.immutability, this.properties);
    }

    @Override
    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map.Entry<Map<String, Object>, V> entry) {
        return new CoarseImmutableSessionAttributes(entry.getKey());
    }

    @CacheEntriesEvicted
    public void evicted(CacheEntriesEvictedEvent<Key<String>, ?> event) {
        if (!event.isPre()) {
            AdvancedCache cache = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
            for (Key key : event.getEntries().keySet()) {
                if (!(key instanceof SessionCreationMetaDataKey)) continue;
                cache.evict((Object)new SessionAttributesKey((String)key.getValue()));
            }
        }
    }
}

