/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.configuration.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.util.InfoStream;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.hibernate.search.util.logging.impl.LoggerInfoStream;

public enum IndexWriterSetting implements Serializable
{
    MAX_BUFFERED_DELETE_TERMS("max_buffered_delete_terms"){

        @Override
        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setMaxBufferedDeleteTerms(value);
        }
    }
    ,
    MAX_BUFFERED_DOCS("max_buffered_docs"){

        @Override
        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setMaxBufferedDocs(value);
        }
    }
    ,
    MAX_MERGE_DOCS("max_merge_docs"){

        @Override
        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMaxMergeDocs(value);
        }
    }
    ,
    MERGE_FACTOR("merge_factor"){

        @Override
        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMergeFactor(value);
        }
    }
    ,
    MERGE_MIN_SIZE("merge_min_size"){

        @Override
        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMinMergeMB((double)value);
        }
    }
    ,
    MERGE_MAX_SIZE("merge_max_size"){

        @Override
        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMaxMergeMB((double)value);
        }
    }
    ,
    MERGE_MAX_OPTIMIZE_SIZE("merge_max_optimize_size"){

        @Override
        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            logByteSizeMergePolicy.setMaxMergeMBForForcedMerge((double)value);
        }
    }
    ,
    MERGE_CALIBRATE_BY_DELETES("merge_calibrate_by_deletes"){

        @Override
        public Integer parseVal(String value) {
            return 8.MERGE_CALIBRATE_BY_DELETES.parseBoolean(value);
        }

        @Override
        public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
            boolean calibrateByDeletes = IndexWriterSetting.intToBoolean(value);
            logByteSizeMergePolicy.setCalibrateSizeByDeletes(calibrateByDeletes);
        }
    }
    ,
    RAM_BUFFER_SIZE("ram_buffer_size"){

        @Override
        public void applySetting(IndexWriterConfig writerConfig, int value) {
            writerConfig.setRAMBufferSizeMB((double)value);
        }
    }
    ,
    TERM_INDEX_INTERVAL("term_index_interval"){

        @Override
        public void applySetting(IndexWriterConfig writerConfig, int value) {
            log.deprecatedConfigurationPropertyIsIgnored("term_index_interval");
        }
    }
    ,
    MAX_THREAD_STATES("max_thread_states"){

        @Override
        public void applySetting(IndexWriterConfig writerConfig, int value) {
            log.deprecatedConfigurationPropertyIsIgnored("max_thread_states");
        }
    }
    ,
    INFOSTREAM("infostream"){

        @Override
        public Integer parseVal(String value) {
            return 12.INFOSTREAM.parseBoolean(value);
        }

        @Override
        public void applySetting(IndexWriterConfig writerConfig, int value) {
            boolean enableInfoStream = IndexWriterSetting.intToBoolean(value);
            if (enableInfoStream) {
                writerConfig.setInfoStream((InfoStream)new LoggerInfoStream());
            }
        }
    };

    private static final Integer TRUE;
    private static final Integer FALSE;
    private static final Log log;
    private final String cfgKey;

    private IndexWriterSetting(String configurationKey) {
        this.cfgKey = configurationKey;
    }

    public void applySetting(IndexWriterConfig writerConfig, int value) {
    }

    public void applySetting(LogByteSizeMergePolicy logByteSizeMergePolicy, int value) {
    }

    public String getKey() {
        return this.cfgKey;
    }

    public Integer parseVal(String value) {
        return ConfigurationParseHelper.parseInt(value, "Invalid value for " + this.cfgKey + ": " + value);
    }

    private Integer parseBoolean(String value) {
        boolean v = ConfigurationParseHelper.parseBoolean(value, "Invalid value for " + this.cfgKey + ": " + value);
        return v ? TRUE : FALSE;
    }

    private static boolean intToBoolean(int value) {
        return value == TRUE;
    }

    static {
        TRUE = 1;
        FALSE = 0;
        log = LoggerFactory.make(MethodHandles.lookup());
    }
}

