/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.wildfly.security.ssl.AbstractDelegatingSSLSocket;
import org.wildfly.security.ssl.SSLConfigurator;

final class ConfiguredSSLSocket
extends AbstractDelegatingSSLSocket {
    private final SSLContext sslContext;
    private final SSLConfigurator sslConfigurator;

    ConfiguredSSLSocket(SSLSocket delegate, SSLContext sslContext, SSLConfigurator sslConfigurator) {
        super(delegate);
        this.sslContext = sslContext;
        this.sslConfigurator = sslConfigurator;
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.sslConfigurator.setUseClientMode(this.sslContext, this.getDelegate(), mode);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslConfigurator.setNeedClientAuth(this.sslContext, this.getDelegate(), need);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslConfigurator.setWantClientAuth(this.sslContext, this.getDelegate(), want);
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslConfigurator.setEnableSessionCreation(this.sslContext, this.getDelegate(), flag);
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslConfigurator.setEnabledCipherSuites(this.sslContext, this.getDelegate(), suites);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslConfigurator.setEnabledProtocols(this.sslContext, this.getDelegate(), protocols);
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.sslConfigurator.setSSLParameters(this.sslContext, this.getDelegate(), params);
    }
}

