/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.wildfly.extension.messaging.activemq.AbstractTransportDefinition;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryUpdateJndiHandler;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryAdd;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryRemove;
import org.wildfly.extension.messaging.activemq.jms.ExternalConnectionFactoryService;

public class ExternalConnectionFactoryDefinition
extends PersistentResourceDefinition {
    private static StringListAttributeDefinition CONNECTORS = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(ConnectionFactoryAttributes.Common.CONNECTORS).setCapabilityReference((CapabilityReferenceRecorder)new AbstractTransportDefinition.TransportCapabilityReferenceRecorder("org.wildfly.messaging.activemq.external.connection-factory", "org.wildfly.messaging.activemq.connector", true))).build();
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq.external.connection-factory", (boolean)true, ExternalConnectionFactoryService.class).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.HA, ConnectionFactoryAttributes.Regular.FACTORY_TYPE, ConnectionFactoryAttributes.Common.DISCOVERY_GROUP, CONNECTORS, ConnectionFactoryAttributes.Common.ENTRIES};
    private final boolean registerRuntimeOnly;

    public ExternalConnectionFactoryDefinition(boolean registerRuntimeOnly) {
        super(new SimpleResourceDefinition.Parameters(MessagingExtension.CONNECTION_FACTORY_PATH, MessagingExtension.getResourceDescriptionResolver("connection-factory")).setCapabilities(new RuntimeCapability[]{CAPABILITY}).setAddHandler((OperationStepHandler)ExternalConnectionFactoryAdd.INSTANCE).setRemoveHandler((OperationStepHandler)ExternalConnectionFactoryRemove.INSTANCE));
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            ConnectionFactoryUpdateJndiHandler.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

