/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.elytron.CertificateAuthorityAccountDefinition;
import org.wildfly.extension.elytron.KeyStoreService;
import org.wildfly.extension.elytron.ModifiableKeyStoreService;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.x500.cert.acme.AcmeAccount;

class AcmeAccountService
implements Service<AcmeAccount> {
    private final InjectedValue<KeyStore> keyStoreInjector = new InjectedValue();
    private final InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplierInjector = new InjectedValue();
    private final CertificateAuthorityAccountDefinition.CertificateAuthority certificateAuthority;
    private final List<String> contactUrlsList;
    private final String alias;
    private final String keyStoreName;
    private volatile AcmeAccount acmeAccount;

    AcmeAccountService(CertificateAuthorityAccountDefinition.CertificateAuthority certificateAuthority, List<String> contactUrlsList, String alias, String keyStoreName) {
        this.certificateAuthority = certificateAuthority;
        this.contactUrlsList = contactUrlsList;
        this.alias = alias;
        this.keyStoreName = keyStoreName;
    }

    public void start(StartContext startContext) throws StartException {
        try {
            ServiceContainer serviceRegistry = startContext.getController().getServiceContainer();
            ModifiableKeyStoreService keyStoreService = CertificateAuthorityAccountDefinition.getModifiableKeyStoreService((ServiceRegistry)serviceRegistry, this.keyStoreName);
            char[] keyPassword = this.resolveKeyPassword((KeyStoreService)keyStoreService);
            KeyStore keyStore = (KeyStore)this.keyStoreInjector.getValue();
            AcmeAccount.Builder acmeAccountBuilder = AcmeAccount.builder().setServerUrl(this.certificateAuthority.getUrl()).setStagingServerUrl(this.certificateAuthority.getStagingUrl());
            if (!this.contactUrlsList.isEmpty()) {
                acmeAccountBuilder = acmeAccountBuilder.setContactUrls(this.contactUrlsList.toArray(new String[this.contactUrlsList.size()]));
            }
            boolean updateAccountKeyStore = false;
            if (keyStore.containsAlias(this.alias)) {
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(this.alias);
                if (certificate == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainCertificateAuthorityAccountCertificate(this.alias);
                }
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(this.alias, keyPassword);
                if (privateKey == null) {
                    throw ElytronSubsystemMessages.ROOT_LOGGER.unableToObtainCertificateAuthorityAccountPrivateKey(this.alias);
                }
                acmeAccountBuilder = acmeAccountBuilder.setKey(certificate, privateKey);
            } else {
                updateAccountKeyStore = true;
            }
            this.acmeAccount = acmeAccountBuilder.build();
            if (updateAccountKeyStore) {
                this.saveCertificateAuthorityAccountKey(keyStoreService, keyPassword);
            }
        }
        catch (Exception e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToStartService(e);
        }
    }

    public void stop(StopContext stopContext) {
        this.acmeAccount = null;
    }

    public AcmeAccount getValue() throws IllegalStateException, IllegalArgumentException {
        return this.acmeAccount;
    }

    Injector<KeyStore> getKeyStoreInjector() {
        return this.keyStoreInjector;
    }

    Injector<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplierInjector;
    }

    char[] resolveKeyPassword(KeyStoreService keyStoreService) throws RuntimeException {
        try {
            return keyStoreService.resolveKeyPassword((ExceptionSupplier<CredentialSource, Exception>)((ExceptionSupplier)this.credentialSourceSupplierInjector.getOptionalValue()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void saveCertificateAuthorityAccountKey(OperationContext operationContext) throws OperationFailedException {
        ModifiableKeyStoreService keyStoreService = CertificateAuthorityAccountDefinition.getModifiableKeyStoreService(operationContext, this.keyStoreName);
        char[] keyPassword = this.resolveKeyPassword((KeyStoreService)keyStoreService);
        this.saveCertificateAuthorityAccountKey(keyStoreService, keyPassword);
    }

    private void saveCertificateAuthorityAccountKey(ModifiableKeyStoreService keyStoreService, char[] keyPassword) throws OperationFailedException {
        KeyStore modifiableAccountkeyStore = keyStoreService.getModifiableValue();
        try {
            modifiableAccountkeyStore.setKeyEntry(this.alias, this.acmeAccount.getPrivateKey(), keyPassword, new X509Certificate[]{this.acmeAccount.getCertificate()});
        }
        catch (KeyStoreException e) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.unableToUpdateCertificateAuthorityAccountKeyStore(e, e.getLocalizedMessage());
        }
        ((KeyStoreService)keyStoreService).save();
    }
}

