/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import javax.servlet.http.HttpSession;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;

public class SAML2InResponseToVerificationHandler
extends BaseSAML2Handler {
    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        String authnRequestId = (String)request.getOptions().get("AUTH_REQUEST_ID");
        HttpSession session = BaseSAML2Handler.getHttpSession(request);
        session.setAttribute("AUTH_REQUEST_ID", (Object)authnRequestId);
        logger.trace("ID of authentication request " + authnRequestId + " saved into HTTP session.");
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            return;
        }
        ResponseType responseType = (ResponseType)request.getSAML2Object();
        String inResponseTo = responseType.getInResponseTo();
        HttpSession session = BaseSAML2Handler.getHttpSession(request);
        String authnRequestId = (String)session.getAttribute("AUTH_REQUEST_ID");
        session.removeAttribute("AUTH_REQUEST_ID");
        if (inResponseTo == null || !inResponseTo.equals(authnRequestId)) {
            logger.samlHandlerFailedInResponseToVerification(inResponseTo, authnRequestId);
            throw logger.samlHandlerFailedInResponseToVerificarionError();
        }
        logger.trace("Successful verification of InResponseTo for request " + inResponseTo);
    }
}

