/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.ha;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;

public class ReplicaPolicyConfiguration
implements HAPolicyConfiguration {
    private String clusterName = null;
    private int maxSavedReplicatedJournalsSize = ActiveMQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize();
    private String groupName = null;
    private boolean restartBackup = ActiveMQDefaultConfiguration.isDefaultRestartBackup();
    private ScaleDownConfiguration scaleDownConfiguration;
    private boolean allowFailBack = false;
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private boolean voteOnReplicationFailure = ActiveMQDefaultConfiguration.getDefaultVoteOnReplicationFailure();
    private int quorumSize = ActiveMQDefaultConfiguration.getDefaultQuorumSize();
    private int voteRetries = ActiveMQDefaultConfiguration.getDefaultVoteRetries();
    private long voteRetryWait = ActiveMQDefaultConfiguration.getDefaultVoteRetryWait();
    private int quorumVoteWait = ActiveMQDefaultConfiguration.getDefaultQuorumVoteWait();
    private long retryReplicationWait = ActiveMQDefaultConfiguration.getDefaultRetryReplicationWait();

    @Override
    public HAPolicyConfiguration.TYPE getType() {
        return HAPolicyConfiguration.TYPE.REPLICA;
    }

    public ScaleDownConfiguration getScaleDownConfiguration() {
        return this.scaleDownConfiguration;
    }

    public ReplicaPolicyConfiguration setScaleDownConfiguration(ScaleDownConfiguration scaleDownConfiguration) {
        this.scaleDownConfiguration = scaleDownConfiguration;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ReplicaPolicyConfiguration setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }

    public ReplicaPolicyConfiguration setMaxSavedReplicatedJournalsSize(int maxSavedReplicatedJournalsSize) {
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ReplicaPolicyConfiguration setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public boolean isRestartBackup() {
        return this.restartBackup;
    }

    public ReplicaPolicyConfiguration setRestartBackup(boolean restartBackup) {
        this.restartBackup = restartBackup;
        return this;
    }

    public boolean isAllowFailBack() {
        return this.allowFailBack;
    }

    public ReplicaPolicyConfiguration setAllowFailBack(boolean allowFailBack) {
        this.allowFailBack = allowFailBack;
        return this;
    }

    @Deprecated
    public ReplicaPolicyConfiguration setFailbackDelay(long failbackDelay) {
        return this;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public ReplicaPolicyConfiguration setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        return this;
    }

    public boolean getVoteOnReplicationFailure() {
        return this.voteOnReplicationFailure;
    }

    public void setVoteOnReplicationFailure(Boolean voteOnReplicationFailure) {
        this.voteOnReplicationFailure = voteOnReplicationFailure;
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public void setQuorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
    }

    public int getVoteRetries() {
        return this.voteRetries;
    }

    public void setVoteRetries(int voteRetries) {
        this.voteRetries = voteRetries;
    }

    public void setVoteRetryWait(long voteRetryWait) {
        this.voteRetryWait = voteRetryWait;
    }

    public long getVoteRetryWait() {
        return this.voteRetryWait;
    }

    public int getQuorumVoteWait() {
        return this.quorumVoteWait;
    }

    public void setQuorumVoteWait(int quorumVoteWait) {
        this.quorumVoteWait = quorumVoteWait;
    }

    public long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }

    public void setRetryReplicationWait(long retryReplicationWait) {
        this.retryReplicationWait = retryReplicationWait;
    }
}

