/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.pem;

import java.security.cert.CertificateException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.wildfly.security.asn1.ASN1Exception;

@MessageLogger(projectCode="ELY", length=5)
interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");

    @Message(id=3010, value="Malformed PEM content at offset %d")
    public IllegalArgumentException malformedPemContent(long var1);

    @Message(id=3011, value="Invalid PEM type (expected \"%s\", got \"%s\"")
    public IllegalArgumentException invalidPemType(String var1, String var2);

    @Message(id=3012, value="Certificate parse error")
    public IllegalArgumentException certificateParseError(@Cause CertificateException var1);

    @Message(id=3023, value="PublicKey parse error")
    public IllegalArgumentException publicKeyParseError(@Cause Throwable var1);

    @Message(id=3033, value="PrivateKey parse error")
    public IllegalArgumentException privateKeyParseError(@Cause Throwable var1);

    @Message(id=7001, value="Unrecognized encoding algorithm [%s]")
    public ASN1Exception asnUnrecognisedAlgorithm(String var1);

    @Message(id=7004, value="Unexpected ASN.1 tag encountered")
    public ASN1Exception asnUnexpectedTag();
}

