/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.components;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.logging.Logger;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.components.BeanManagerInstanceCreator;
import org.eclipse.yasson.internal.components.DefaultConstructorCreator;
import org.eclipse.yasson.internal.components.JsonbComponentInstanceCreator;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonbComponentInstanceCreatorFactory {
    private static final Logger log = Logger.getLogger(JsonbComponentInstanceCreator.class.getName());
    public static final String BEAN_MANAGER_NAME = "java:comp/BeanManager";
    public static final String INITIAL_CONTEXT_CLASS = "javax.naming.InitialContext";
    private static final String CDI_SPI_CLASS = "javax.enterprise.inject.spi.CDI";

    public static JsonbComponentInstanceCreator getComponentInstanceCreator() {
        Object beanManager = JsonbComponentInstanceCreatorFactory.getCdiBeanManager();
        if (beanManager == null) {
            beanManager = JsonbComponentInstanceCreatorFactory.getJndiBeanManager();
        }
        if (beanManager == null) {
            log.finest(Messages.getMessage(MessageKeys.BEAN_MANAGER_NOT_FOUND_USING_DEFAULT, new Object[0]));
            return new DefaultConstructorCreator();
        }
        return new BeanManagerInstanceCreator(beanManager);
    }

    private static Object getCdiBeanManager() {
        return AccessController.doPrivileged(() -> {
            try {
                return JsonbComponentInstanceCreatorFactory.getBeanManager(() -> {
                    Class<?> cdiClass = Class.forName(CDI_SPI_CLASS);
                    Method current = cdiClass.getMethod("current", new Class[0]);
                    Method getBeanManager = cdiClass.getMethod("getBeanManager", new Class[0]);
                    Object cdiObject = current.invoke(cdiClass, new Object[0]);
                    if (cdiObject == null) {
                        return null;
                    }
                    return getBeanManager.invoke(cdiObject, new Object[0]);
                });
            }
            catch (ClassNotFoundException e) {
                log.finest(Messages.getMessage(MessageKeys.NO_CDI_API_PROVIDER, CDI_SPI_CLASS));
                return null;
            }
        });
    }

    private static Object getJndiBeanManager() {
        return AccessController.doPrivileged(() -> {
            try {
                return JsonbComponentInstanceCreatorFactory.getBeanManager(() -> {
                    Class<?> initialContextClass = Class.forName(INITIAL_CONTEXT_CLASS);
                    Method lookupMethod = initialContextClass.getMethod("lookup", String.class);
                    Constructor<?> initialContextConstructor = initialContextClass.getConstructor(new Class[0]);
                    Object initialContextObject = initialContextConstructor.newInstance(new Object[0]);
                    return lookupMethod.invoke(initialContextObject, BEAN_MANAGER_NAME);
                });
            }
            catch (ClassNotFoundException e) {
                log.finest(Messages.getMessage(MessageKeys.NO_JNDI_ENVIRONMENT, INITIAL_CONTEXT_CLASS));
                return null;
            }
        });
    }

    private static Object getBeanManager(BeanManagerProvider command) throws ClassNotFoundException {
        try {
            return command.provide();
        }
        catch (InstantiationException | NoSuchMethodException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, e.getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warning(e.getMessage());
            log.warning(Messages.getMessage(MessageKeys.ILLEGAL_ACCESS, "lookup CDI bean manager"));
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                log.finest(e.getMessage());
            }
            log.finest(Messages.getMessage(MessageKeys.NO_CDI_ENVIRONMENT, new Object[0]));
            return null;
        }
    }

    private static interface BeanManagerProvider {
        public Object provide() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, InstantiationException, ClassNotFoundException;
    }
}

