/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import java.util.Arrays;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.clustering.web.infinispan.routing.LocalRouteLocatorServiceConfiguratorFactory;
import org.wildfly.clustering.web.infinispan.routing.NullRouteLocatorServiceConfiguratorFactory;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocatorServiceConfiguratorFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementProvider;
import org.wildfly.clustering.web.routing.RouteLocatorServiceConfiguratorFactory;
import org.wildfly.clustering.web.session.DistributableSessionManagementProvider;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentConfiguration;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.extension.clustering.web.deployment.MutableDistributableDeploymentConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableInfinispanSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableSessionManagementConfiguration;

public class DistributableWebDeploymentXMLReader
implements XMLElementReader<MutableDistributableDeploymentConfiguration>,
JBossAllXMLParser<DistributableWebDeploymentConfiguration> {
    private static final String SESSION_MANAGEMENT = "session-management";
    private static final String NAME = "name";
    private static final String INFINISPAN_SESSION_MANAGEMENT = "infinispan-session-management";
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE = "cache";
    private static final String GRANULARITY = "granularity";
    private static final String NO_AFFINITY = "no-affinity";
    private static final String LOCAL_AFFINITY = "local-affinity";
    private static final String PRIMARY_OWNER_AFFINITY = "primary-owner-affinity";
    private static final String IMMUTABLE_CLASS = "immutable-class";
    private final DistributableWebDeploymentSchema schema;

    public DistributableWebDeploymentXMLReader(DistributableWebDeploymentSchema schema) {
        this.schema = schema;
    }

    public DistributableWebDeploymentConfiguration parse(XMLExtendedStreamReader reader, DeploymentUnit unit) throws XMLStreamException {
        MutableDistributableDeploymentConfiguration configuration = new MutableDistributableDeploymentConfiguration(unit);
        this.readElement(reader, configuration);
        return configuration;
    }

    public void readElement(XMLExtendedStreamReader reader, MutableDistributableDeploymentConfiguration configuration) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        TreeSet<String> names = new TreeSet<String>();
        names.add(SESSION_MANAGEMENT);
        names.add(INFINISPAN_SESSION_MANAGEMENT);
        if (!reader.hasNext() || reader.nextTag() == 2) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, names);
        }
        switch (reader.getLocalName()) {
            case "session-management": {
                this.readSessionManagement(reader, configuration);
                break;
            }
            case "infinispan-session-management": {
                MutableInfinispanSessionManagementConfiguration config = new MutableInfinispanSessionManagementConfiguration(configuration);
                RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration> factory = this.readInfinispanSessionManagement(reader, config, configuration);
                configuration.setSessionManagement((DistributableSessionManagementProvider)new InfinispanSessionManagementProvider((InfinispanSessionManagementConfiguration)config, factory));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader, names);
            }
        }
        if (reader.hasNext() && reader.nextTag() != 2) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readSessionManagement(XMLExtendedStreamReader reader, MutableDistributableDeploymentConfiguration configuration) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (name) {
                case "name": {
                    configuration.setSessionManagementName(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        this.readImmutability(reader, configuration);
    }

    private void readSessionManagementAttribute(XMLExtendedStreamReader reader, int index, MutableSessionManagementConfiguration configuration) throws XMLStreamException {
        String value = reader.getAttributeValue(index);
        switch (reader.getAttributeLocalName(index)) {
            case "granularity": {
                try {
                    configuration.setSessionGranularity(value);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)index);
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration> readInfinispanSessionManagement(XMLExtendedStreamReader reader, MutableInfinispanSessionManagementConfiguration configuration, Consumer<String> accumulator) throws XMLStreamException {
        TreeSet<String> required = new TreeSet<String>(Arrays.asList(CACHE_CONTAINER, GRANULARITY));
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            required.remove(name);
            switch (name) {
                case "cache-container": {
                    configuration.setContainerName(value);
                    continue block8;
                }
                case "cache": {
                    configuration.setCacheName(value);
                    continue block8;
                }
                default: {
                    this.readSessionManagementAttribute(reader, i, configuration);
                }
            }
        }
        if (!required.isEmpty()) {
            ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])required.toArray(new String[required.size()]));
        }
        RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration> affinityFactory = this.readInfinispanAffinity(reader);
        this.readImmutability(reader, accumulator);
        return affinityFactory;
    }

    private RouteLocatorServiceConfiguratorFactory<InfinispanSessionManagementConfiguration> readInfinispanAffinity(XMLExtendedStreamReader reader) throws XMLStreamException {
        if (!reader.hasNext() || reader.nextTag() == 2) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, new TreeSet<String>(Arrays.asList(NO_AFFINITY, LOCAL_AFFINITY, PRIMARY_OWNER_AFFINITY)));
        }
        switch (reader.getLocalName()) {
            case "no-affinity": {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new NullRouteLocatorServiceConfiguratorFactory();
            }
            case "local-affinity": {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new LocalRouteLocatorServiceConfiguratorFactory();
            }
            case "primary-owner-affinity": {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                return new PrimaryOwnerRouteLocatorServiceConfiguratorFactory();
            }
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private void readImmutability(XMLExtendedStreamReader reader, Consumer<String> accumulator) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (reader.getLocalName()) {
                case "immutable-class": {
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    accumulator.accept(reader.getElementText());
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

