/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.dd;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;

public class AssemblyDescriptorProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = ejbJarMetaData.getAssemblyDescriptor();
        if (assemblyDescriptor != null) {
            EjbJarDescription ejbJarDescription = (EjbJarDescription)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_DESCRIPTION);
            EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
            this.processSecurityRoles(assemblyDescriptor.getSecurityRoles(), ejbJarDescription);
            MessageDestinationsMetaData destinations = assemblyDescriptor.getMessageDestinations();
            if (destinations != null) {
                this.processMessageDestinations(destinations, eeModuleDescription);
            }
        }
    }

    private void processMessageDestinations(MessageDestinationsMetaData destinations, EEModuleDescription eeModuleDescription) {
        for (MessageDestinationMetaData destination : destinations) {
            if (destination.getJndiName() != null) {
                eeModuleDescription.addMessageDestination(destination.getName(), destination.getJndiName());
                continue;
            }
            if (destination.getLookupName() == null) continue;
            eeModuleDescription.addMessageDestination(destination.getName(), destination.getLookupName());
        }
    }

    private void processSecurityRoles(SecurityRolesMetaData securityRoles, EjbJarDescription ejbJarDescription) {
        if (securityRoles == null || securityRoles.isEmpty()) {
            return;
        }
        for (SecurityRoleMetaData securityRole : securityRoles) {
            String roleName = securityRole.getRoleName();
            if (roleName == null || roleName.trim().isEmpty()) continue;
            ejbJarDescription.addSecurityRole(roleName);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

