/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.XnioByteBufferPool;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.io.BufferPoolService;
import org.wildfly.extension.io.IOExtension;
import org.xnio.Pool;

class BufferPoolResourceDefinition
extends PersistentResourceDefinition {
    static final RuntimeCapability<Void> IO_POOL_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.io.buffer-pool", (boolean)true, Pool.class).build();
    static final RuntimeCapability<Void> IO_BYTE_BUFFER_POOL_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.undertow.byte-buffer-pool", (boolean)true, ByteBufferPool.class).build();
    private static final int defaultBufferSize;
    private static final int defaultBuffersPerRegion;
    private static final boolean defaultDirectBuffers;
    static final SimpleAttributeDefinition BUFFER_SIZE;
    static final SimpleAttributeDefinition BUFFER_PER_SLICE;
    static final SimpleAttributeDefinition DIRECT_BUFFERS;
    static List<SimpleAttributeDefinition> ATTRIBUTES;
    public static final BufferPoolResourceDefinition INSTANCE;

    private BufferPoolResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(IOExtension.BUFFER_POOL_PATH, (ResourceDescriptionResolver)IOExtension.getResolver("buffer-pool")).setAddHandler((OperationStepHandler)new BufferPoolAdd()).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).addCapabilities(new RuntimeCapability[]{IO_POOL_RUNTIME_CAPABILITY, IO_BYTE_BUFFER_POOL_RUNTIME_CAPABILITY}).setDeprecatedSince(ModelVersion.create((int)4)));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory < 0x4000000L) {
            defaultDirectBuffers = false;
            defaultBufferSize = 512;
            defaultBuffersPerRegion = 10;
        } else if (maxMemory < 0x8000000L) {
            defaultDirectBuffers = true;
            defaultBufferSize = 1024;
            defaultBuffersPerRegion = 10;
        } else {
            defaultDirectBuffers = true;
            defaultBufferSize = 16384;
            defaultBuffersPerRegion = 20;
        }
        BUFFER_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffer-size", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).build();
        BUFFER_PER_SLICE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("buffers-per-slice", ModelType.INT, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).build();
        DIRECT_BUFFERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("direct-buffers", ModelType.BOOLEAN, true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setAllowExpression(true)).build();
        ATTRIBUTES = Arrays.asList(BUFFER_SIZE, BUFFER_PER_SLICE, DIRECT_BUFFERS);
        INSTANCE = new BufferPoolResourceDefinition();
    }

    private static final class ByteBufferPoolService
    implements org.jboss.msc.service.Service<ByteBufferPool> {
        final InjectedValue<Pool> bufferPool = new InjectedValue();
        private volatile ByteBufferPool byteBufferPool;

        private ByteBufferPoolService() {
        }

        public void start(StartContext startContext) throws StartException {
            this.byteBufferPool = new XnioByteBufferPool((Pool)this.bufferPool.getValue());
        }

        public void stop(StopContext stopContext) {
            this.byteBufferPool.close();
            this.byteBufferPool = null;
        }

        public ByteBufferPool getValue() throws IllegalStateException, IllegalArgumentException {
            return this.byteBufferPool;
        }
    }

    private static class BufferPoolAdd
    extends AbstractAddStepHandler {
        private BufferPoolAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            ModelNode bufferSizeModel = BUFFER_SIZE.resolveModelAttribute(context, model);
            ModelNode bufferPerSliceModel = BUFFER_PER_SLICE.resolveModelAttribute(context, model);
            ModelNode directModel = DIRECT_BUFFERS.resolveModelAttribute(context, model);
            int bufferSize = bufferSizeModel.isDefined() ? bufferSizeModel.asInt() : defaultBufferSize;
            int bufferPerSlice = bufferPerSliceModel.isDefined() ? bufferPerSliceModel.asInt() : defaultBuffersPerRegion;
            boolean direct = directModel.isDefined() ? directModel.asBoolean() : defaultDirectBuffers;
            BufferPoolService service = new BufferPoolService(bufferSize, bufferPerSlice, direct);
            context.getCapabilityServiceTarget().addCapability(IO_POOL_RUNTIME_CAPABILITY).setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            ByteBufferPoolService poolService = new ByteBufferPoolService();
            context.getCapabilityServiceTarget().addCapability(IO_BYTE_BUFFER_POOL_RUNTIME_CAPABILITY).setInstance((Service)poolService).addCapabilityRequirement(IO_POOL_RUNTIME_CAPABILITY.getDynamicName(address), Pool.class, poolService.bufferPool).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        }
    }
}

