/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.infinispan.spi.EvictableDataContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationServiceConfigurator;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValueFactory;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.session.SessionAttributePersistenceStrategy;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class InfinispanSessionManagerFactoryServiceConfigurator<C extends Marshallability, L>
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
InfinispanSessionManagerFactoryConfiguration<C, L>,
Supplier<SessionManagerFactory<L, TransactionBatch>>,
Consumer<ConfigurationBuilder> {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final InfinispanSessionManagementConfiguration configuration;
    private final SessionManagerFactoryConfiguration<C, L> factoryConfiguration;
    private volatile ServiceConfigurator configurationConfigurator;
    private volatile ServiceConfigurator cacheConfigurator;
    private volatile SupplierDependency<NodeFactory<Address>> group;
    private volatile SupplierDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile SupplierDependency<CommandDispatcherFactory> dispatcherFactory;
    private volatile Supplier<Cache> cache;

    public InfinispanSessionManagerFactoryServiceConfigurator(InfinispanSessionManagementConfiguration configuration, SessionManagerFactoryConfiguration<C, L> factoryConfiguration) {
        super(ServiceName.JBOSS.append(new String[]{"clustering", DEFAULT_CACHE_CONTAINER, factoryConfiguration.getDeploymentName()}));
        this.configuration = configuration;
        this.factoryConfiguration = factoryConfiguration;
    }

    @Override
    public SessionManagerFactory<L, TransactionBatch> get() {
        return new InfinispanSessionManagerFactory(this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        String containerName = this.configuration.getContainerName();
        String cacheName = this.configuration.getCacheName();
        String deploymentName = this.factoryConfiguration.getDeploymentName();
        this.configurationConfigurator = new TemplateConfigurationServiceConfigurator(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, containerName, deploymentName), containerName, deploymentName, cacheName, (Consumer)this).configure(support);
        this.cacheConfigurator = new CacheServiceConfigurator(InfinispanCacheRequirement.CACHE.getServiceName(support, containerName, deploymentName), containerName, deploymentName).configure(support);
        this.affinityFactory = new ServiceSupplierDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, containerName));
        this.dispatcherFactory = new ServiceSupplierDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, containerName));
        this.group = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, containerName, this.factoryConfiguration.getServerName()));
        return this;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        Integer size;
        ExpirationConfiguration expiration = builder.expiration().create();
        if (expiration.lifespan() >= 0L || expiration.maxIdle() >= 0L) {
            builder.expiration().lifespan(-1L).maxIdle(-1L);
            InfinispanWebLogger.ROOT_LOGGER.expirationDisabled(InfinispanCacheRequirement.CONFIGURATION.resolve(this.configuration.getContainerName(), this.configuration.getCacheName()));
        }
        EvictionStrategy strategy = (size = this.factoryConfiguration.getMaxActiveSessions()) != null ? EvictionStrategy.REMOVE : EvictionStrategy.NONE;
        builder.memory().evictionType(EvictionType.COUNT).evictionStrategy(strategy).size(size != null ? size.longValue() : 0L).storageType(StorageType.OBJECT);
        if (strategy.isEnabled()) {
            builder.dataContainer().dataContainer(EvictableDataContainer.createDataContainer((ConfigurationBuilder)builder, (long)size.intValue(), SessionCreationMetaDataKey.class::isInstance));
        }
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        this.configurationConfigurator.build(target).install();
        this.cacheConfigurator.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = new CompositeDependency(new Dependency[]{this.group, this.affinityFactory, this.dispatcherFactory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        this.cache = builder.requires(this.cacheConfigurator.getServiceName());
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return this.cache.get();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.get();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.get();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.group.get();
    }

    @Override
    public String getContainerName() {
        return this.configuration.getContainerName();
    }

    @Override
    public String getCacheName() {
        return this.configuration.getCacheName();
    }

    public SessionAttributePersistenceStrategy getAttributePersistenceStrategy() {
        return this.configuration.getAttributePersistenceStrategy();
    }

    public Integer getMaxActiveSessions() {
        return this.factoryConfiguration.getMaxActiveSessions();
    }

    public String getServerName() {
        return this.factoryConfiguration.getServerName();
    }

    public String getDeploymentName() {
        return this.factoryConfiguration.getDeploymentName();
    }

    public MarshalledValueFactory<C> getMarshalledValueFactory() {
        return this.factoryConfiguration.getMarshalledValueFactory();
    }

    public C getMarshallingContext() {
        return (C)this.factoryConfiguration.getMarshallingContext();
    }

    public LocalContextFactory<L> getLocalContextFactory() {
        return this.factoryConfiguration.getLocalContextFactory();
    }

    public Immutability getImmutability() {
        return this.factoryConfiguration.getImmutability();
    }
}

