/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import org.wildfly.common.Assert;
import org.wildfly.security.authz.Roles;

@FunctionalInterface
public interface RoleMapper {
    public static final RoleMapper IDENTITY_ROLE_MAPPER = rolesToMap -> rolesToMap;

    public Roles mapRoles(Roles var1);

    default public RoleMapper and(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return rolesToMap -> this.mapRoles(rolesToMap).and(other.mapRoles(rolesToMap));
    }

    default public RoleMapper or(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return rolesToMap -> this.mapRoles(rolesToMap).or(other.mapRoles(rolesToMap));
    }

    default public RoleMapper xor(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return rolesToMap -> this.mapRoles(rolesToMap).xor(other.mapRoles(rolesToMap));
    }

    default public RoleMapper minus(RoleMapper other) {
        Assert.checkNotNullParam((String)"other", (Object)other);
        return rolesToMap -> this.mapRoles(rolesToMap).minus(other.mapRoles(rolesToMap));
    }

    public static RoleMapper aggregate(RoleMapper mapper1, RoleMapper mapper2) {
        Assert.checkNotNullParam((String)"mapper1", (Object)mapper1);
        Assert.checkNotNullParam((String)"mapper2", (Object)mapper2);
        return rolesToMap -> mapper2.mapRoles(mapper1.mapRoles(rolesToMap));
    }

    public static RoleMapper aggregate(RoleMapper ... mappers) {
        Assert.checkNotNullParam((String)"mappers", (Object)mappers);
        RoleMapper[] clone = (RoleMapper[])mappers.clone();
        for (int i = 0; i < clone.length; ++i) {
            Assert.checkNotNullArrayParam((String)"mappers", (int)i, (Object)clone[i]);
        }
        return rolesToMap -> {
            for (RoleMapper r : clone) {
                rolesToMap = r.mapRoles(rolesToMap);
            }
            return rolesToMap;
        };
    }

    public static RoleMapper constant(Roles roles) {
        Assert.checkNotNullParam((String)"roles", (Object)roles);
        return rolesToMap -> roles;
    }
}

