/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.globalstate.GlobalConfigurationManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.LocalGlobalConfigurationManager;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.Registration;
import org.wildfly.clustering.infinispan.spi.CacheContainer;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

@Listener
public class CacheContainerServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Function<EmbeddedCacheManager, CacheContainer>,
Supplier<EmbeddedCacheManager>,
Consumer<EmbeddedCacheManager> {
    private final Map<String, Registration> registrations = new ConcurrentHashMap<String, Registration>();
    private final List<ServiceName> aliases = new LinkedList<ServiceName>();
    private final String name;
    private final SupplierDependency<GlobalConfiguration> configuration;
    private volatile Registrar<String> registrar;

    public CacheContainerServiceConfigurator(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.CONTAINER, address);
        this.name = address.getLastElement().getValue();
        this.configuration = new ServiceSupplierDependency(CacheContainerResourceDefinition.Capability.CONFIGURATION.getServiceName(address));
    }

    @Override
    public CacheContainer apply(EmbeddedCacheManager manager) {
        return new DefaultCacheContainer(manager);
    }

    @Override
    public EmbeddedCacheManager get() {
        GlobalConfiguration config = (GlobalConfiguration)this.configuration.get();
        String defaultCacheName = config.defaultCacheName().orElse(null);
        Configuration defaultConfiguration = defaultCacheName != null ? new ConfigurationBuilder().build() : null;
        DefaultCacheManager manager = new DefaultCacheManager(config, defaultConfiguration, false);
        if (defaultCacheName != null) {
            manager.undefineConfiguration(defaultCacheName);
        }
        BasicComponentRegistry registry = (BasicComponentRegistry)manager.getGlobalComponentRegistry().getComponent(BasicComponentRegistry.class);
        registry.replaceComponent(GlobalConfigurationManager.class.getName(), (Object)new LocalGlobalConfigurationManager(), false);
        registry.rewire();
        manager.start();
        manager.addListener((Object)this);
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache container started", this.name);
        return manager;
    }

    @Override
    public void accept(EmbeddedCacheManager manager) {
        manager.removeListener((Object)this);
        manager.stop();
        InfinispanLogger.ROOT_LOGGER.debugf("%s cache container stopped", this.name);
    }

    public CacheContainerServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.aliases.clear();
        for (ModelNode alias : ModelNodes.optionalList((ModelNode)CacheContainerResourceDefinition.Attribute.ALIASES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList())) {
            this.aliases.add(InfinispanRequirement.CONTAINER.getServiceName(context.getCapabilityServiceSupport(), alias.asString()));
        }
        this.registrar = (CacheContainerResource)context.readResource(PathAddress.EMPTY_ADDRESS);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        for (ServiceName alias : this.aliases) {
            builder.addAliases(new ServiceName[]{alias});
        }
        Consumer container = this.configuration.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(container, (Function)this, (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        String cacheName = event.getCacheName();
        InfinispanLogger.ROOT_LOGGER.cacheStarted(cacheName, this.name);
        this.registrations.put(cacheName, this.registrar.register((Object)cacheName));
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        String cacheName = event.getCacheName();
        try (Registration registration = this.registrations.remove(cacheName);){
            InfinispanLogger.ROOT_LOGGER.cacheStopped(cacheName, this.name);
        }
    }
}

