/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedLuceneAnalyzer;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ScopedLuceneAnalyzerReference
extends LuceneAnalyzerReference
implements ScopedAnalyzerReference {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final LuceneAnalyzerReference globalAnalyzerReference;
    private final Map<String, LuceneAnalyzerReference> scopedAnalyzerReferences;
    private final ScopedLuceneAnalyzer scopedAnalyzer;

    public ScopedLuceneAnalyzerReference(Builder builder) {
        this.globalAnalyzerReference = builder.globalAnalyzerReference;
        this.scopedAnalyzerReferences = Collections.unmodifiableMap(new HashMap(builder.scopedAnalyzerReferences));
        this.scopedAnalyzer = new ScopedLuceneAnalyzer(this.globalAnalyzerReference, this.scopedAnalyzerReferences);
    }

    public ScopedLuceneAnalyzer getAnalyzer() {
        return this.scopedAnalyzer;
    }

    @Override
    public boolean isNormalizer(String fieldName) {
        return this.getDelegate(fieldName).isNormalizer(fieldName);
    }

    @Override
    public void close() {
        this.getAnalyzer().close();
    }

    @Override
    public ScopedAnalyzerReference.CopyBuilder startCopy() {
        return new Builder(this.globalAnalyzerReference, this.scopedAnalyzerReferences);
    }

    private LuceneAnalyzerReference getDelegate(String fieldName) {
        LuceneAnalyzerReference analyzerReference = this.scopedAnalyzerReferences.get(fieldName);
        if (analyzerReference == null) {
            analyzerReference = this.globalAnalyzerReference;
        }
        return analyzerReference;
    }

    private static LuceneAnalyzerReference getLuceneAnalyzerReference(AnalyzerReference analyzerReference) {
        if (!analyzerReference.is(LuceneAnalyzerReference.class)) {
            throw LOG.analyzerReferenceIsNotLucene(analyzerReference);
        }
        return analyzerReference.unwrap(LuceneAnalyzerReference.class);
    }

    public static class Builder
    implements ScopedAnalyzerReference.Builder,
    ScopedAnalyzerReference.CopyBuilder {
        private LuceneAnalyzerReference globalAnalyzerReference;
        private final Map<String, LuceneAnalyzerReference> scopedAnalyzerReferences = new HashMap<String, LuceneAnalyzerReference>();

        public Builder(LuceneAnalyzerReference globalAnalyzerReference, Map<String, LuceneAnalyzerReference> scopedAnalyzers) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzerReferences.putAll(scopedAnalyzers);
        }

        @Override
        public LuceneAnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        @Override
        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = ScopedLuceneAnalyzerReference.getLuceneAnalyzerReference(globalAnalyzerReference);
        }

        @Override
        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzerReferences.put(scope, ScopedLuceneAnalyzerReference.getLuceneAnalyzerReference(analyzerReference));
        }

        @Override
        public ScopedLuceneAnalyzerReference build() {
            return new ScopedLuceneAnalyzerReference(this);
        }
    }
}

