/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.stats.Stats;

@Immutable
public class StatsImpl
implements Stats {
    private static String[] Attributes = new String[]{"timeSinceReset", "timeSinceStart", "numberOfEntries", "numberOfEntriesInMemory", "offHeapMemoryUsed", "dataMemoryUsed", "retrievals", "stores", "hits", "misses", "removeHits", "removeMisses", "evictions", "averageReadTime", "averageRemoveTime", "averageWriteTime", "averageReadTimeNanos", "averageRemoveTimeNanos", "averageWriteTimeNanos", "minRequiredNodes"};
    private final Map<String, Long> statsMap = new HashMap<String, Long>();
    final CacheMgmtInterceptor mgmtInterceptor;
    final Stats source;

    public StatsImpl(AsyncInterceptorChain chain) {
        this.mgmtInterceptor = chain.findInterceptorExtending(CacheMgmtInterceptor.class);
        this.source = null;
        if (this.mgmtInterceptor.getStatisticsEnabled()) {
            this.statsMap.put("timeSinceReset", this.mgmtInterceptor.getTimeSinceReset());
            this.statsMap.put("timeSinceStart", this.mgmtInterceptor.getTimeSinceStart());
            this.statsMap.put("numberOfEntries", Long.valueOf(this.mgmtInterceptor.getNumberOfEntries()));
            this.statsMap.put("numberOfEntriesInMemory", Long.valueOf(this.mgmtInterceptor.getNumberOfEntriesInMemory()));
            this.statsMap.put("dataMemoryUsed", this.mgmtInterceptor.getDataMemoryUsed());
            this.statsMap.put("offHeapMemoryUsed", this.mgmtInterceptor.getOffHeapMemoryUsed());
            this.statsMap.put("retrievals", this.mgmtInterceptor.getHits() + this.mgmtInterceptor.getMisses());
            this.statsMap.put("stores", this.mgmtInterceptor.getStores());
            this.statsMap.put("hits", this.mgmtInterceptor.getHits());
            this.statsMap.put("misses", this.mgmtInterceptor.getMisses());
            this.statsMap.put("removeHits", this.mgmtInterceptor.getRemoveHits());
            this.statsMap.put("removeMisses", this.mgmtInterceptor.getRemoveMisses());
            this.statsMap.put("evictions", this.mgmtInterceptor.getEvictions());
            this.statsMap.put("averageReadTime", this.mgmtInterceptor.getAverageReadTime());
            this.statsMap.put("averageRemoveTime", this.mgmtInterceptor.getAverageRemoveTime());
            this.statsMap.put("averageWriteTime", this.mgmtInterceptor.getAverageWriteTime());
            this.statsMap.put("averageReadTimeNanos", this.mgmtInterceptor.getAverageReadTimeNanos());
            this.statsMap.put("averageRemoveTimeNanos", this.mgmtInterceptor.getAverageRemoveTimeNanos());
            this.statsMap.put("averageWriteTimeNanos", this.mgmtInterceptor.getAverageWriteTimeNanos());
            this.statsMap.put("minRequiredNodes", Long.valueOf(this.mgmtInterceptor.getRequiredMinimumNumberOfNodes()));
        } else {
            for (String key : Attributes) {
                this.statsMap.put(key, -1L);
            }
        }
    }

    public StatsImpl(Stats other) {
        this.mgmtInterceptor = null;
        this.source = other;
        if (other != null) {
            this.statsMap.put("timeSinceReset", other.getTimeSinceReset());
            this.statsMap.put("timeSinceStart", other.getTimeSinceStart());
            this.statsMap.put("numberOfEntries", Long.valueOf(other.getCurrentNumberOfEntries()));
            this.statsMap.put("numberOfEntriesInMemory", Long.valueOf(other.getCurrentNumberOfEntriesInMemory()));
            this.statsMap.put("dataMemoryUsed", other.getDataMemoryUsed());
            this.statsMap.put("offHeapMemoryUsed", other.getOffHeapMemoryUsed());
            this.statsMap.put("retrievals", other.getHits() + other.getMisses());
            this.statsMap.put("stores", other.getStores());
            this.statsMap.put("hits", other.getHits());
            this.statsMap.put("misses", other.getMisses());
            this.statsMap.put("removeHits", other.getRemoveHits());
            this.statsMap.put("removeMisses", other.getRemoveMisses());
            this.statsMap.put("evictions", other.getEvictions());
            this.statsMap.put("averageReadTime", other.getAverageReadTime());
            this.statsMap.put("averageRemoveTime", other.getAverageRemoveTime());
            this.statsMap.put("averageWriteTime", other.getAverageWriteTime());
            this.statsMap.put("averageReadTimeNanos", other.getAverageReadTimeNanos());
            this.statsMap.put("averageRemoveTimeNanos", other.getAverageRemoveTimeNanos());
            this.statsMap.put("averageWriteTimeNanos", other.getAverageWriteTimeNanos());
            this.statsMap.put("minRequiredNodes", Long.valueOf(other.getRequiredMinimumNumberOfNodes()));
        } else {
            for (String key : Attributes) {
                this.statsMap.put(key, -1L);
            }
        }
    }

    @Override
    public long getTimeSinceStart() {
        return this.statsMap.get("timeSinceStart");
    }

    @Override
    public long getTimeSinceReset() {
        return this.statsMap.get("timeSinceReset");
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return Math.toIntExact(this.statsMap.get("numberOfEntries"));
    }

    @Override
    public int getCurrentNumberOfEntriesInMemory() {
        return Math.toIntExact(this.statsMap.get("numberOfEntriesInMemory"));
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.statsMap.get("stores");
    }

    @Override
    public long getDataMemoryUsed() {
        return this.statsMap.get("dataMemoryUsed");
    }

    @Override
    public long getOffHeapMemoryUsed() {
        return this.statsMap.get("offHeapMemoryUsed");
    }

    @Override
    public long getRetrievals() {
        return this.statsMap.get("retrievals");
    }

    @Override
    public long getStores() {
        return this.statsMap.get("stores");
    }

    @Override
    public long getHits() {
        return this.statsMap.get("hits");
    }

    @Override
    public long getMisses() {
        return this.statsMap.get("misses");
    }

    @Override
    public long getRemoveHits() {
        return this.statsMap.get("removeHits");
    }

    @Override
    public long getRemoveMisses() {
        return this.statsMap.get("removeMisses");
    }

    @Override
    public long getEvictions() {
        return this.statsMap.get("evictions");
    }

    @Override
    public long getAverageReadTime() {
        return this.statsMap.get("averageReadTime");
    }

    @Override
    public long getAverageWriteTime() {
        return this.statsMap.get("averageWriteTime");
    }

    @Override
    public long getAverageRemoveTime() {
        return this.statsMap.get("averageRemoveTime");
    }

    @Override
    public long getAverageReadTimeNanos() {
        return this.statsMap.get("averageReadTimeNanos");
    }

    @Override
    public long getAverageWriteTimeNanos() {
        return this.statsMap.get("averageWriteTimeNanos");
    }

    @Override
    public long getAverageRemoveTimeNanos() {
        return this.statsMap.get("averageRemoveTimeNanos");
    }

    @Override
    public int getRequiredMinimumNumberOfNodes() {
        return Math.toIntExact(this.statsMap.get("minRequiredNodes"));
    }

    @Override
    public void reset() {
        if (this.mgmtInterceptor != null) {
            this.mgmtInterceptor.resetStatistics();
        } else if (this.source != null) {
            this.source.reset();
        }
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        if (this.mgmtInterceptor != null) {
            this.mgmtInterceptor.setStatisticsEnabled(enabled);
        } else if (this.source != null) {
            this.source.setStatisticsEnabled(enabled);
        }
    }
}

