/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.file;

import com.microsoft.azure.storage.DoesServiceRequest;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.ResultSegment;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageUri;
import com.microsoft.azure.storage.core.ExecutionEngine;
import com.microsoft.azure.storage.core.LazySegmentedIterable;
import com.microsoft.azure.storage.core.ListResponse;
import com.microsoft.azure.storage.core.ListingContext;
import com.microsoft.azure.storage.core.SegmentedStorageRequest;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import com.microsoft.azure.storage.file.CloudFileShare;
import com.microsoft.azure.storage.file.FileRequest;
import com.microsoft.azure.storage.file.FileRequestOptions;
import com.microsoft.azure.storage.file.FileServiceProperties;
import com.microsoft.azure.storage.file.ShareListHandler;
import com.microsoft.azure.storage.file.ShareListingDetails;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;

public final class CloudFileClient
extends ServiceClient {
    private FileRequestOptions defaultRequestOptions = new FileRequestOptions();

    public CloudFileClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public CloudFileClient(StorageUri storageUri, StorageCredentials credentials) {
        super(storageUri, credentials);
        if (credentials == null || credentials.getClass().equals(StorageCredentialsAnonymous.class)) {
            throw new IllegalArgumentException("StorageCredentials cannot be null or anonymous for this service.");
        }
        FileRequestOptions.applyDefaults(this.defaultRequestOptions);
    }

    public CloudFileShare getShareReference(String shareName) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("shareName", shareName);
        return this.getShareReference(shareName, null);
    }

    public CloudFileShare getShareReference(String shareName, String snapshotID) throws URISyntaxException, StorageException {
        Utility.assertNotNullOrEmpty("shareName", shareName);
        return new CloudFileShare(shareName, snapshotID, this);
    }

    @DoesServiceRequest
    public Iterable<CloudFileShare> listShares() {
        return this.listSharesWithPrefix(null, EnumSet.noneOf(ShareListingDetails.class), null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudFileShare> listShares(String prefix) {
        return this.listSharesWithPrefix(prefix, EnumSet.noneOf(ShareListingDetails.class), null, null);
    }

    @DoesServiceRequest
    public Iterable<CloudFileShare> listShares(String prefix, EnumSet<ShareListingDetails> detailsIncluded, FileRequestOptions options, OperationContext opContext) {
        return this.listSharesWithPrefix(prefix, detailsIncluded, options, opContext);
    }

    @DoesServiceRequest
    public ResultSegment<CloudFileShare> listSharesSegmented() throws StorageException {
        return this.listSharesSegmented(null, EnumSet.noneOf(ShareListingDetails.class), null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudFileShare> listSharesSegmented(String prefix) throws StorageException {
        return this.listSharesWithPrefixSegmented(prefix, EnumSet.noneOf(ShareListingDetails.class), null, null, null, null);
    }

    @DoesServiceRequest
    public ResultSegment<CloudFileShare> listSharesSegmented(String prefix, EnumSet<ShareListingDetails> detailsIncluded, Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        return this.listSharesWithPrefixSegmented(prefix, detailsIncluded, maxResults, continuationToken, options, opContext);
    }

    private Iterable<CloudFileShare> listSharesWithPrefix(String prefix, EnumSet<ShareListingDetails> detailsIncluded, FileRequestOptions options, OperationContext opContext) {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        return new LazySegmentedIterable<CloudFileClient, Object, CloudFileShare>(this.listSharesWithPrefixSegmentedImpl(prefix, detailsIncluded, null, options, segmentedRequest), this, null, options.getRetryPolicyFactory(), opContext);
    }

    private ResultSegment<CloudFileShare> listSharesWithPrefixSegmented(String prefix, EnumSet<ShareListingDetails> detailsIncluded, Integer maxResults, ResultContinuation continuationToken, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this);
        Utility.assertContinuationType(continuationToken, ResultContinuationType.SHARE);
        SegmentedStorageRequest segmentedRequest = new SegmentedStorageRequest();
        segmentedRequest.setToken(continuationToken);
        return ExecutionEngine.executeWithRetry(this, null, this.listSharesWithPrefixSegmentedImpl(prefix, detailsIncluded, maxResults, options, segmentedRequest), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudFileClient, Void, ResultSegment<CloudFileShare>> listSharesWithPrefixSegmentedImpl(String prefix, final EnumSet<ShareListingDetails> detailsIncluded, Integer maxResults, final FileRequestOptions options, final SegmentedStorageRequest segmentedRequest) {
        Utility.assertContinuationType(segmentedRequest.getToken(), ResultContinuationType.SHARE);
        final ListingContext listingContext = new ListingContext(prefix, maxResults);
        StorageRequest<CloudFileClient, Void, ResultSegment<CloudFileShare>> getRequest = new StorageRequest<CloudFileClient, Void, ResultSegment<CloudFileShare>>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(Utility.getListingLocationMode(segmentedRequest.getToken()));
            }

            @Override
            public HttpURLConnection buildRequest(CloudFileClient client, Void parentObject, OperationContext context) throws Exception {
                listingContext.setMarker(segmentedRequest.getToken() != null ? segmentedRequest.getToken().getNextMarker() : null);
                return FileRequest.listShares(client.getCredentials().transformUri(client.getStorageUri()).getUri(this.getCurrentLocation()), options, context, listingContext, detailsIncluded);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudFileClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, context);
            }

            @Override
            public ResultSegment<CloudFileShare> preProcessResponse(Void parentObject, CloudFileClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ResultSegment<CloudFileShare> postProcessResponse(HttpURLConnection connection, Void share, CloudFileClient client, OperationContext context, ResultSegment<CloudFileShare> storageObject) throws Exception {
                ListResponse<CloudFileShare> response = ShareListHandler.getShareList(this.getConnection().getInputStream(), client);
                ResultContinuation newToken = null;
                if (response.getNextMarker() != null) {
                    newToken = new ResultContinuation();
                    newToken.setNextMarker(response.getNextMarker());
                    newToken.setContinuationType(ResultContinuationType.SHARE);
                    newToken.setTargetLocation(this.getResult().getTargetLocation());
                }
                ResultSegment<CloudFileShare> resSegment = new ResultSegment<CloudFileShare>(response.getResults(), response.getMaxResults(), newToken);
                segmentedRequest.setToken(resSegment.getContinuationToken());
                return resSegment;
            }
        };
        return getRequest;
    }

    @DoesServiceRequest
    public final FileServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    @DoesServiceRequest
    public final FileServiceProperties downloadServiceProperties(FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this);
        return new FileServiceProperties(ExecutionEngine.executeWithRetry(this, null, this.downloadServicePropertiesImpl(options, false), options.getRetryPolicyFactory(), opContext));
    }

    @DoesServiceRequest
    public void uploadServiceProperties(FileServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(FileServiceProperties properties, FileRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = FileRequestOptions.populateAndApplyDefaults(options, this);
        Utility.assertNotNull("properties", properties);
        ExecutionEngine.executeWithRetry(this, null, this.uploadServicePropertiesImpl(properties.getServiceProperties(), options, opContext, false), options.getRetryPolicyFactory(), opContext);
    }

    @Override
    public FileRequestOptions getDefaultRequestOptions() {
        return this.defaultRequestOptions;
    }

    public void setDefaultRequestOptions(FileRequestOptions defaultRequestOptions) {
        Utility.assertNotNull("defaultRequestOptions", defaultRequestOptions);
        this.defaultRequestOptions = defaultRequestOptions;
    }

    @Override
    protected boolean isUsePathStyleUris() {
        return super.isUsePathStyleUris();
    }
}

