/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts;

import java.util.Map;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.SecurityActions;
import org.picketlink.identity.federation.core.sts.registry.DefaultRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.DefaultTokenRegistry;
import org.picketlink.identity.federation.core.sts.registry.FileBasedRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.FileBasedTokenRegistry;
import org.picketlink.identity.federation.core.sts.registry.JDBCRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.JDBCTokenRegistry;
import org.picketlink.identity.federation.core.sts.registry.JPABasedRevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.JPABasedTokenRegistry;
import org.picketlink.identity.federation.core.sts.registry.RevocationRegistry;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;

public abstract class AbstractSecurityTokenProvider
implements SecurityTokenProvider {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected static final String TOKEN_REGISTRY = "TokenRegistry";
    protected static final String TOKEN_REGISTRY_FILE = "TokenRegistryFile";
    protected static final String TOKEN_REGISTRY_JPA = "TokenRegistryJPA";
    protected static final String TOKEN_REGISTRY_JDBC = "TokenRegistryJDBC";
    protected static final String REVOCATION_REGISTRY = "RevocationRegistry";
    protected static final String REVOCATION_REGISTRY_FILE = "RevocationRegistryFile";
    protected static final String REVOCATION_REGISTRY_JPA_CONFIG = "RevocationRegistryJPAConfig";
    protected static final String REVOCATION_REGISTRY_JDBC_CONFIG = "RevocationRegistryJDBCConfig";
    protected static final String ATTRIBUTE_PROVIDER = "AttributeProvider";
    protected static final String USE_ABSOLUTE_KEYIDENTIFIER = "USE_ABSOLUTE_KEYIDENTIFIER";
    protected SecurityTokenRegistry tokenRegistry = new DefaultTokenRegistry();
    protected RevocationRegistry revocationRegistry = new DefaultRevocationRegistry();
    protected Map<String, String> properties;

    @Override
    public void initialize(Map<String, String> properties) {
        String configuration;
        String registryOption;
        this.properties = properties;
        String tokenRegistryOption = this.properties.get(TOKEN_REGISTRY);
        if (tokenRegistryOption == null) {
            logger.stsTokenRegistryNotSpecified();
        } else if ("FILE".equalsIgnoreCase(tokenRegistryOption)) {
            String tokenRegistryFile = this.properties.get(TOKEN_REGISTRY_FILE);
            this.tokenRegistry = tokenRegistryFile != null ? new FileBasedTokenRegistry(tokenRegistryFile) : new FileBasedTokenRegistry();
        } else if ("JPA".equalsIgnoreCase(tokenRegistryOption)) {
            String tokenRegistryjpa = this.properties.get(TOKEN_REGISTRY_JPA);
            this.tokenRegistry = tokenRegistryjpa != null ? new JPABasedTokenRegistry(tokenRegistryjpa) : new JPABasedTokenRegistry();
        } else if ("JDBC".equalsIgnoreCase(tokenRegistryOption)) {
            String tokenRegistryjdbc = this.properties.get(TOKEN_REGISTRY_JDBC);
            this.tokenRegistry = tokenRegistryjdbc != null ? new JDBCTokenRegistry(tokenRegistryjdbc) : new JDBCTokenRegistry();
        } else {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), tokenRegistryOption);
                if (clazz != null) {
                    Object object = clazz.newInstance();
                    if (object instanceof SecurityTokenRegistry) {
                        this.tokenRegistry = (SecurityTokenRegistry)object;
                    } else {
                        logger.stsTokenRegistryInvalidType(tokenRegistryOption);
                    }
                }
            }
            catch (Exception pae) {
                logger.stsTokenRegistryInstantiationError();
                pae.printStackTrace();
            }
        }
        if (this.tokenRegistry == null) {
            this.tokenRegistry = new DefaultTokenRegistry();
        }
        if ((registryOption = this.properties.get(REVOCATION_REGISTRY)) == null) {
            logger.stsRevocationRegistryNotSpecified();
        } else if ("FILE".equalsIgnoreCase(registryOption)) {
            String registryFile = this.properties.get(REVOCATION_REGISTRY_FILE);
            this.revocationRegistry = registryFile != null ? new FileBasedRevocationRegistry(registryFile) : new FileBasedRevocationRegistry();
        } else if ("JPA".equalsIgnoreCase(registryOption)) {
            configuration = this.properties.get(REVOCATION_REGISTRY_JPA_CONFIG);
            this.revocationRegistry = configuration != null ? new JPABasedRevocationRegistry(configuration) : new JPABasedRevocationRegistry();
        } else if ("JDBC".equalsIgnoreCase(registryOption)) {
            configuration = this.properties.get(REVOCATION_REGISTRY_JDBC_CONFIG);
            this.revocationRegistry = configuration != null ? new JDBCRevocationRegistry(configuration) : new JDBCRevocationRegistry();
        } else {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), registryOption);
                if (clazz != null) {
                    Object object = clazz.newInstance();
                    if (object instanceof RevocationRegistry) {
                        this.revocationRegistry = (RevocationRegistry)object;
                    } else {
                        logger.stsRevocationRegistryInvalidType(registryOption);
                    }
                }
            }
            catch (Exception pae) {
                logger.stsRevocationRegistryInstantiationError();
                pae.printStackTrace();
            }
        }
        if (this.revocationRegistry == null) {
            this.revocationRegistry = new DefaultRevocationRegistry();
        }
    }

    protected long getClockSkewInMillis() {
        String clockSkew = this.properties.get("CLOCK_SKEW");
        if (clockSkew == null) {
            clockSkew = "0";
        }
        return Long.parseLong(clockSkew);
    }

    protected Lifetime adjustLifetimeForClockSkew(Lifetime lifetime) throws ProcessingException {
        try {
            lifetime.setCreated(XMLTimeUtil.subtract(lifetime.getCreated(), this.getClockSkewInMillis()));
            lifetime.setExpires(XMLTimeUtil.add(lifetime.getExpires(), this.getClockSkewInMillis()));
            return lifetime;
        }
        catch (ConfigurationException ce) {
            throw new ProcessingException(ce.getMessage());
        }
    }
}

