/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi;

import java.util.function.Predicate;
import org.infinispan.commons.util.EntrySizeCalculator;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.BoundedSegmentedDataContainer;
import org.infinispan.container.impl.DefaultDataContainer;

public class EvictableDataContainer<K, V>
extends DefaultDataContainer<K, V> {
    protected EvictableDataContainer(long size, EntrySizeCalculator<? super K, ? super InternalCacheEntry<K, V>> calculator) {
        super(size, calculator);
    }

    public static <K, V> DataContainer<K, V> createDataContainer(ConfigurationBuilder builder, long size, Predicate<K> evictable) {
        EntrySizeCalculator calculator = (key, entry) -> evictable.test(key) ? 1L : 0L;
        return builder.clustering().cacheMode().needsStateTransfer() ? new BoundedSegmentedDataContainer(builder.clustering().hash().create().numSegments(), size, calculator) : new EvictableDataContainer<K, V>(size, calculator);
    }
}

