/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.messaging;

import java.util.Collection;
import org.apache.qpid.proton.ProtonException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.codec.AMQPType;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FastPathDescribedTypeConstructor;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeEncoding;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.codec.messaging.DataType;

public class FastPathDataType
implements AMQPType<Data>,
FastPathDescribedTypeConstructor<Data> {
    private static final byte DESCRIPTOR_CODE = 117;
    private static final Object[] DESCRIPTORS = new Object[]{UnsignedLong.valueOf(117L), Symbol.valueOf("amqp:data:binary")};
    private final DataType dataType;

    public FastPathDataType(EncoderImpl encoder) {
        this.dataType = new DataType(encoder);
    }

    public EncoderImpl getEncoder() {
        return this.dataType.getEncoder();
    }

    public DecoderImpl getDecoder() {
        return this.dataType.getDecoder();
    }

    @Override
    public boolean encodesJavaPrimitive() {
        return false;
    }

    @Override
    public Class<Data> getTypeClass() {
        return this.dataType.getTypeClass();
    }

    @Override
    public TypeEncoding<Data> getEncoding(Data val) {
        return this.dataType.getEncoding(val);
    }

    @Override
    public TypeEncoding<Data> getCanonicalEncoding() {
        return this.dataType.getCanonicalEncoding();
    }

    @Override
    public Collection<? extends TypeEncoding<Data>> getAllEncodings() {
        return this.dataType.getAllEncodings();
    }

    @Override
    public Data readValue() {
        ReadableBuffer buffer = this.getDecoder().getBuffer();
        byte encodingCode = buffer.get();
        int size = 0;
        switch (encodingCode) {
            case -96: {
                size = buffer.get() & 0xFF;
                break;
            }
            case -80: {
                size = buffer.getInt();
                break;
            }
            case 64: {
                return new Data(null);
            }
            default: {
                throw new ProtonException("Expected Binary type but found encoding: " + encodingCode);
            }
        }
        if (size > buffer.remaining()) {
            throw new IllegalArgumentException("Binary data size " + size + " is specified to be greater than the amount of data available (" + buffer.remaining() + ")");
        }
        byte[] data = new byte[size];
        buffer.get(data, 0, size);
        return new Data(new Binary(data));
    }

    @Override
    public void skipValue() {
        this.getDecoder().readConstructor().skipValue();
    }

    @Override
    public void write(Data data) {
        WritableBuffer buffer = this.getEncoder().getBuffer();
        buffer.put((byte)0);
        buffer.put((byte)83);
        buffer.put((byte)117);
        this.getEncoder().writeBinary(data.getValue());
    }

    public static void register(Decoder decoder, EncoderImpl encoder) {
        FastPathDataType type = new FastPathDataType(encoder);
        for (Object descriptor : DESCRIPTORS) {
            decoder.register(descriptor, type);
        }
        encoder.register(type);
    }
}

