/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.DivertControl;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.Parameter;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConnectorServiceConfiguration;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.management.impl.view.AddressView;
import org.apache.activemq.artemis.core.management.impl.view.ConnectionView;
import org.apache.activemq.artemis.core.management.impl.view.ConsumerView;
import org.apache.activemq.artemis.core.management.impl.view.ProducerView;
import org.apache.activemq.artemis.core.management.impl.view.QueueView;
import org.apache.activemq.artemis.core.management.impl.view.SessionView;
import org.apache.activemq.artemis.core.messagecounter.MessageCounterManager;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedAddressSetting;
import org.apache.activemq.artemis.core.persistence.config.PersistedRoles;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.ConnectorServiceFactory;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.LiveOnlyPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ScaleDownPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.Activation;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.SlowConsumerPolicy;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionDetail;
import org.apache.activemq.artemis.core.transaction.TransactionDetailFactory;
import org.apache.activemq.artemis.core.transaction.impl.CoreTransactionDetail;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoginModuleConfigurator;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.ListUtil;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SecurityFormatter;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class ActiveMQServerControlImpl
extends AbstractControl
implements ActiveMQServerControl,
NotificationEmitter,
org.apache.activemq.artemis.core.server.management.NotificationListener {
    private static final Logger logger = Logger.getLogger(ActiveMQServerControlImpl.class);
    private final PostOffice postOffice;
    private final Configuration configuration;
    private final ResourceManager resourceManager;
    private final RemotingService remotingService;
    private final ActiveMQServer server;
    private final MessageCounterManager messageCounterManager;
    private final NotificationBroadcasterSupport broadcaster;
    private final AtomicLong notifSeq = new AtomicLong(0L);

    public ActiveMQServerControlImpl(PostOffice postOffice, Configuration configuration, ResourceManager resourceManager, RemotingService remotingService, ActiveMQServer messagingServer, MessageCounterManager messageCounterManager, StorageManager storageManager, NotificationBroadcasterSupport broadcaster) throws Exception {
        super(ActiveMQServerControl.class, storageManager);
        this.postOffice = postOffice;
        this.configuration = configuration;
        this.resourceManager = resourceManager;
        this.remotingService = remotingService;
        this.server = messagingServer;
        this.messageCounterManager = messageCounterManager;
        this.broadcaster = broadcaster;
        this.server.getManagementService().addNotificationListener(this);
    }

    public boolean isStarted() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isStarted((Object)this.server);
        }
        this.clearIO();
        try {
            boolean bl = this.server.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getVersion() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getVersion((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.getVersion().getFullVersion();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isBackup() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isBackup((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.getHAPolicy().isBackup();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isSharedStore() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isSharedStore((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.getHAPolicy().isSharedStore();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getBindingsDirectory() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getBindingsDirectory((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getBindingsDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getInterceptorClassNames() {
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getIncomingInterceptorClassNames().toArray(new String[this.configuration.getIncomingInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getIncomingInterceptorClassNames() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getIncomingInterceptorClassNames((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getIncomingInterceptorClassNames().toArray(new String[this.configuration.getIncomingInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getOutgoingInterceptorClassNames() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getOutgoingInterceptorClassNames((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.configuration.getOutgoingInterceptorClassNames().toArray(new String[this.configuration.getOutgoingInterceptorClassNames().size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalBufferSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalBufferSize((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalBufferSize_AIO() : this.configuration.getJournalBufferSize_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalBufferTimeout() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalBufferTimeout((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalBufferTimeout_AIO() : this.configuration.getJournalBufferTimeout_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void setFailoverOnServerShutdown(boolean failoverOnServerShutdown) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.setFailoverOnServerShutdown((Object)this.server, (Object[])new Object[]{failoverOnServerShutdown});
        }
        this.checkStarted();
        this.clearIO();
        try {
            HAPolicy haPolicy = this.server.getHAPolicy();
            if (haPolicy instanceof SharedStoreSlavePolicy) {
                ((SharedStoreSlavePolicy)haPolicy).setFailoverOnServerShutdown(failoverOnServerShutdown);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isFailoverOnServerShutdown() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isFailoverOnServerShutdown((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            HAPolicy haPolicy = this.server.getHAPolicy();
            if (haPolicy instanceof SharedStoreSlavePolicy) {
                boolean bl = ((SharedStoreSlavePolicy)haPolicy).isFailoverOnServerShutdown();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalMaxIO() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalMaxIO((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalType() == JournalType.ASYNCIO ? this.configuration.getJournalMaxIO_AIO() : this.configuration.getJournalMaxIO_NIO();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getJournalDirectory() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalDirectory((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getJournalDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalFileSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalFileSize((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalFileSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalMinFiles() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalMinFiles((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalMinFiles();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalCompactMinFiles() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalCompactMinFiles((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalCompactMinFiles();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getJournalCompactPercentage() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalCompactPercentage((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getJournalCompactPercentage();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isPersistenceEnabled() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isPersistenceEnabled((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isPersistenceEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getJournalType() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getJournalType((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getJournalType().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getPagingDirectory() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getPagingDirectory((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.configuration.getPagingDirectory();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getScheduledThreadPoolMaxSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getScheduledThreadPoolMaxSize((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getScheduledThreadPoolMaxSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getThreadPoolMaxSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getThreadPoolMaxSize((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getThreadPoolMaxSize();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getSecurityInvalidationInterval() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getSecurityInvalidationInterval((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.configuration.getSecurityInvalidationInterval();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isClustered() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isClustered((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isClustered();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isCreateBindingsDir() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isCreateBindingsDir((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isCreateBindingsDir();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isCreateJournalDir() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isCreateJournalDir((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isCreateJournalDir();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isJournalSyncNonTransactional() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isJournalSyncNonTransactional((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isJournalSyncNonTransactional();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isJournalSyncTransactional() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isJournalSyncTransactional((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isJournalSyncTransactional();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isSecurityEnabled() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isSecurityEnabled((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isSecurityEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isAsyncConnectionExecutionEnabled() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isAsyncConnectionExecutionEnabled((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isAsyncConnectionExecutionEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getDiskScanPeriod() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getDiskScanPeriod((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getDiskScanPeriod();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMaxDiskUsage() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getMaxDiskUsage((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.configuration.getMaxDiskUsage();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getGlobalMaxSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getGlobalMaxSize((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.configuration.getGlobalMaxSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getAddressMemoryUsage() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddressMemoryUsage((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            if (this.server.getPagingManager() == null) {
                long l = -1L;
                return l;
            }
            long l = this.server.getPagingManager().getGlobalSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getAddressMemoryUsagePercentage() {
        long globalMaxSize;
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddressMemoryUsagePercentage((Object)this.server);
        }
        if ((globalMaxSize = this.getGlobalMaxSize()) <= 0L) {
            return 0;
        }
        long memoryUsed = this.getAddressMemoryUsage();
        if (memoryUsed <= 0L) {
            return 0;
        }
        double result = 100.0 * (double)memoryUsed / (double)globalMaxSize;
        return (int)result;
    }

    public boolean freezeReplication() {
        Activation activation;
        if (AuditLogger.isEnabled()) {
            AuditLogger.freezeReplication((Object)this.server);
        }
        if ((activation = this.server.getActivation()) instanceof SharedNothingLiveActivation) {
            SharedNothingLiveActivation liveActivation = (SharedNothingLiveActivation)activation;
            liveActivation.freezeReplication();
            return true;
        }
        return false;
    }

    public String createAddress(String name, String routingTypes) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createAddress((Object)this.server, (Object[])new Object[]{name, routingTypes});
        }
        this.checkStarted();
        this.clearIO();
        try {
            EnumSet<RoutingType> set = EnumSet.noneOf(RoutingType.class);
            for (String routingType : ListUtil.toList((String)routingTypes)) {
                set.add(RoutingType.valueOf((String)routingType));
            }
            AddressInfo addressInfo = new AddressInfo(new SimpleString(name), set);
            if (this.server.addAddressInfo(addressInfo)) {
                String string = AddressInfoTextFormatter.Long.format(addressInfo, new StringBuilder()).toString();
                return string;
            }
            throw ActiveMQMessageBundle.BUNDLE.addressAlreadyExists(addressInfo.getName());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateAddress(String name, String routingTypes) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.updateAddress((Object)this.server, (Object[])new Object[]{name, routingTypes});
        }
        this.checkStarted();
        this.clearIO();
        try {
            EnumSet<RoutingType> routingTypeSet;
            if (routingTypes == null) {
                routingTypeSet = null;
            } else {
                String[] routingTypeNames;
                routingTypeSet = EnumSet.noneOf(RoutingType.class);
                for (String routingTypeName : routingTypeNames = routingTypes.split(",")) {
                    routingTypeSet.add(RoutingType.valueOf((String)routingTypeName));
                }
            }
            if (!this.server.updateAddressInfo(SimpleString.toSimpleString((String)name), routingTypeSet)) {
                throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(SimpleString.toSimpleString((String)name));
            }
            String string = AddressInfoTextFormatter.Long.format(this.server.getAddressInfo(SimpleString.toSimpleString((String)name)), new StringBuilder()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void deleteAddress(String name) throws Exception {
        this.deleteAddress(name, false);
    }

    public void deleteAddress(String name, boolean force) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.deleteAddress((Object)this.server, (Object[])new Object[]{name, force});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.removeAddressInfo(new SimpleString(name), null, force);
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    @Deprecated
    public void deployQueue(String address, String name, String filterString) throws Exception {
        this.deployQueue(address, name, filterString, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void deployQueue(String address, String name, String filterStr, boolean durable) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.deployQueue((Object)this.server, (Object[])new Object[]{address, name, filterStr, durable});
        }
        this.checkStarted();
        SimpleString filter = filterStr == null ? null : new SimpleString(filterStr);
        this.clearIO();
        try {
            this.server.createQueue(SimpleString.toSimpleString((String)address), this.server.getAddressSettingsRepository().getMatch(address).getDefaultQueueRoutingType(), new SimpleString(name), filter, durable, false);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createQueue(String address, String name) throws Exception {
        this.createQueue(address, name, true);
    }

    public void createQueue(String address, String name, String routingType) throws Exception {
        this.createQueue(address, name, true, routingType);
    }

    public void createQueue(String address, String name, boolean durable) throws Exception {
        this.createQueue(address, name, null, durable);
    }

    public void createQueue(String address, String name, boolean durable, String routingType) throws Exception {
        this.createQueue(address, name, null, durable, routingType);
    }

    public void createQueue(String address, String name, String filterStr, boolean durable) throws Exception {
        this.createQueue(address, name, filterStr, durable, this.server.getAddressSettingsRepository().getMatch(address == null ? name : address).getDefaultQueueRoutingType().toString());
    }

    public void createQueue(String address, String name, String filterStr, boolean durable, String routingType) throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(address == null ? name : address);
        this.createQueue(address, routingType, name, filterStr, durable, addressSettings.getDefaultMaxConsumers(), addressSettings.isDefaultPurgeOnNoConsumers(), addressSettings.isAutoCreateAddresses());
    }

    public String createQueue(String address, String routingType, String name, String filterStr, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean autoCreateAddress) throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(address == null ? name : address);
        return this.createQueue(address, routingType, name, filterStr, durable, maxConsumers, purgeOnNoConsumers, addressSettings.isDefaultExclusiveQueue(), addressSettings.isDefaultGroupRebalance(), addressSettings.getDefaultGroupBuckets(), addressSettings.isDefaultLastValueQueue(), addressSettings.getDefaultLastValueKey() == null ? null : addressSettings.getDefaultLastValueKey().toString(), addressSettings.isDefaultNonDestructive(), addressSettings.getDefaultConsumersBeforeDispatch(), addressSettings.getDefaultDelayBeforeDispatch(), addressSettings.isAutoDeleteCreatedQueues(), addressSettings.getAutoDeleteQueuesDelay(), addressSettings.getAutoDeleteQueuesMessageCount(), autoCreateAddress);
    }

    public String createQueue(String address, String routingType, String name, String filterStr, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoCreateAddress) throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(address == null ? name : address);
        return this.createQueue(address, routingType, name, filterStr, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, addressSettings.isAutoDeleteCreatedQueues(), addressSettings.getAutoDeleteQueuesDelay(), addressSettings.getAutoDeleteQueuesMessageCount(), autoCreateAddress);
    }

    public String createQueue(String address, String routingType, String name, String filterStr, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(address == null ? name : address);
        return this.createQueue(address, routingType, name, filterStr, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, addressSettings.getDefaultGroupFirstKey() == null ? null : addressSettings.getDefaultGroupFirstKey().toString(), lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
    }

    public String createQueue(String address, String routingType, String name, String filterStr, boolean durable, int maxConsumers, boolean purgeOnNoConsumers, boolean exclusive, boolean groupRebalance, int groupBuckets, String groupFirstKey, boolean lastValue, String lastValueKey, boolean nonDestructive, int consumersBeforeDispatch, long delayBeforeDispatch, boolean autoDelete, long autoDeleteDelay, long autoDeleteMessageCount, boolean autoCreateAddress) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createQueue((Object)this.server, (String)address, (Object[])new Object[]{routingType, name, filterStr, durable, maxConsumers, purgeOnNoConsumers, exclusive, groupBuckets, lastValue, lastValueKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress});
        }
        this.checkStarted();
        this.clearIO();
        SimpleString filter = filterStr == null ? null : new SimpleString(filterStr);
        try {
            if (filterStr != null && !filterStr.trim().equals("")) {
                filter = new SimpleString(filterStr);
            }
            Queue queue = this.server.createQueue(SimpleString.toSimpleString((String)address), RoutingType.valueOf((String)routingType.toUpperCase()), SimpleString.toSimpleString((String)name), filter, durable, false, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, SimpleString.toSimpleString((String)groupFirstKey), lastValue, SimpleString.toSimpleString((String)lastValueKey), nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, autoDelete, autoDeleteDelay, autoDeleteMessageCount, autoCreateAddress);
            String string = QueueTextFormatter.Long.format(queue, new StringBuilder()).toString();
            return string;
        }
        catch (ActiveMQException e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    @Deprecated
    public String updateQueue(String name, String routingType, Integer maxConsumers, Boolean purgeOnNoConsumers) throws Exception {
        return this.updateQueue(name, routingType, maxConsumers, purgeOnNoConsumers, null);
    }

    @Deprecated
    public String updateQueue(String name, String routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive) throws Exception {
        return this.updateQueue(name, routingType, maxConsumers, purgeOnNoConsumers, exclusive, null);
    }

    public String updateQueue(String name, String routingType, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, String user) throws Exception {
        return this.updateQueue(name, routingType, null, maxConsumers, purgeOnNoConsumers, exclusive, null, null, null, null, null, user);
    }

    public String updateQueue(String name, String routingType, String filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
        return this.updateQueue(name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, null, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateQueue(String name, String routingType, String filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, String groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, String user) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.updateQueue((Object)this.server, (Object[])new Object[]{name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Queue queue = this.server.updateQueue(name, routingType != null ? RoutingType.valueOf((String)routingType) : null, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user);
            if (queue == null) {
                throw ActiveMQMessageBundle.BUNDLE.noSuchQueue(new SimpleString(name));
            }
            String string = QueueTextFormatter.Long.format(queue, new StringBuilder()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getQueueNames() {
        return this.getQueueNames(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getQueueNames(String routingType) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getQueueNames((Object)this.server, (Object[])new Object[]{routingType});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Object[] queueControls = this.server.getManagementService().getResources(QueueControl.class);
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < queueControls.length; ++i) {
                QueueControl queueControl = (QueueControl)queueControls[i];
                if (routingType != null && queueControl.getRoutingType().equals(routingType.toUpperCase())) {
                    names.add(queueControl.getName());
                    continue;
                }
                if (routingType != null) continue;
                names.add(queueControl.getName());
            }
            String[] result = new String[names.size()];
            String[] stringArray = names.toArray(result);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClusterConnectionNames() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getClusterConnectionNames((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            ArrayList<String> names = new ArrayList<String>();
            for (ClusterConnection clusterConnection : this.server.getClusterManager().getClusterConnections()) {
                names.add(clusterConnection.getName().toString());
            }
            String[] result = new String[names.size()];
            String[] stringArray = names.toArray(result);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getUptime() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getUptime((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String string = this.server.getUptime();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getUptimeMillis() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getUptimeMillis((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.server.getUptimeMillis();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isReplicaSync() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isReplicaSync((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.server.isReplicaSync();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAddressNames() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddressNames((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Object[] addresses = this.server.getManagementService().getResources(AddressControl.class);
            String[] names = new String[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                AddressControl address = (AddressControl)addresses[i];
                names[i] = address.getAddress();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyQueue(String name, boolean removeConsumers, boolean autoDeleteAddress) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.destroyQueue((Object)this.server, (String)name, (Object[])new Object[]{removeConsumers, autoDeleteAddress});
        }
        this.checkStarted();
        this.clearIO();
        try {
            SimpleString queueName = new SimpleString(name);
            this.server.destroyQueue(queueName, null, !removeConsumers, removeConsumers, autoDeleteAddress);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyQueue(String name, boolean removeConsumers) throws Exception {
        this.destroyQueue(name, removeConsumers, false);
    }

    public void destroyQueue(String name) throws Exception {
        this.destroyQueue(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAddressInfo(String address) throws ActiveMQAddressDoesNotExistException {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddressInfo((Object)this.server, (Object[])new Object[]{address});
        }
        this.checkStarted();
        this.clearIO();
        try {
            AddressInfo addressInfo = this.server.getAddressInfo(SimpleString.toSimpleString((String)address));
            if (addressInfo == null) {
                throw ActiveMQMessageBundle.BUNDLE.addressDoesNotExist(SimpleString.toSimpleString((String)address));
            }
            String string = AddressInfoTextFormatter.Long.format(addressInfo, new StringBuilder()).toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listBindingsForAddress(String address) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listBindingsForAddress((Object)this.server, (Object[])new Object[]{address});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Bindings bindings = this.server.getPostOffice().lookupBindingsForAddress(new SimpleString(address));
            String string = bindings == null ? "" : bindings.getBindings().stream().map(Binding::toManagementString).collect(Collectors.joining(","));
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAddresses(String separator) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listAddresses((Object)this.server, (Object[])new Object[]{separator});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<SimpleString> addresses = this.server.getPostOffice().getAddresses();
            TreeSet<SimpleString> sortAddress = new TreeSet<SimpleString>(new Comparator<SimpleString>(){

                @Override
                public int compare(SimpleString o1, SimpleString o2) {
                    return o1.toString().compareToIgnoreCase(o2.toString());
                }
            });
            sortAddress.addAll(addresses);
            StringBuilder result = new StringBuilder();
            for (SimpleString string : sortAddress) {
                if (result.length() > 0) {
                    result.append(separator);
                }
                result.append((CharSequence)string);
            }
            String string = result.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getConnectionCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getConnectionCount((Object)this.server, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.server.getConnectionCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getTotalConnectionCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTotalConnectionCount((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.server.getTotalConnectionCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getTotalMessageCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTotalMessageCount((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.server.getTotalMessageCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getTotalMessagesAdded() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTotalMessagesAdded((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.server.getTotalMessagesAdded();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getTotalMessagesAcknowledged() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTotalMessagesAcknowledged((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.server.getTotalMessagesAcknowledged();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public long getTotalConsumerCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTotalConsumerCount((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.server.getTotalConsumerCount();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void enableMessageCounters() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.enableMessageCounters((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.setMessageCounterEnabled(true);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void disableMessageCounters() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.disableMessageCounters((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.setMessageCounterEnabled(false);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetAllMessageCounters() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.resetAllMessageCounters((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.messageCounterManager.resetAllCounters();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void resetAllMessageCounterHistories() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.resetAllMessageCounterHistories((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.messageCounterManager.resetAllCounterHistories();
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isMessageCounterEnabled() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isMessageCounterEnabled((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean bl = this.configuration.isMessageCounterEnabled();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public synchronized long getMessageCounterSamplePeriod() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getMessageCounterSamplePeriod((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            long l = this.messageCounterManager.getSamplePeriod();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    public synchronized void setMessageCounterSamplePeriod(long newPeriod) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.setMessageCounterSamplePeriod((Object)this.server, (Object[])new Object[]{newPeriod});
        }
        this.checkStarted();
        this.clearIO();
        try {
            if (newPeriod < 1000L) {
                if (newPeriod <= 0L) {
                    throw ActiveMQMessageBundle.BUNDLE.periodMustGreaterThanZero(newPeriod);
                }
                ActiveMQServerLogger.LOGGER.invalidMessageCounterPeriod(newPeriod);
            }
            if (this.messageCounterManager != null && newPeriod != this.messageCounterManager.getSamplePeriod()) {
                this.messageCounterManager.reschedule(newPeriod);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public int getMessageCounterMaxDayCount() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getMessageCounterMaxDayCount((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            int n = this.messageCounterManager.getMaxDayCount();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void setMessageCounterMaxDayCount(int count) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.setMessageCounterMaxDayCount((Object)this.server, (Object[])new Object[]{count});
        }
        this.checkStarted();
        this.clearIO();
        try {
            if (count <= 0) {
                throw ActiveMQMessageBundle.BUNDLE.greaterThanZero(count);
            }
            this.messageCounterManager.setMaxDayCount(count);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listPreparedTransactions() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listPreparedTransactions((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return entry1.getValue().compareTo(entry2.getValue());
                }
            });
            String[] s = new String[xidsSortedByCreationTime.size()];
            int i = 0;
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Date creation = new Date(entry.getValue());
                Xid xid = entry.getKey();
                s[i++] = dateFormat.format(creation) + " base64: " + XidImpl.toBase64String((Xid)xid) + " " + xid.toString();
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        return this.listPreparedTransactionDetailsAsJSON((xid, tx, creation) -> new CoreTransactionDetail(xid, tx, creation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPreparedTransactionDetailsAsJSON(TransactionDetailFactory factory) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listPreparedTransactionDetailsAsJSON((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            if (xids == null || xids.size() == 0) {
                String string = "";
                return string;
            }
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return entry1.getValue().compareTo(entry2.getValue());
                }
            });
            JsonArrayBuilder txDetailListJson = JsonLoader.createArrayBuilder();
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Xid xid = entry.getKey();
                Transaction tx = this.resourceManager.getTransaction(xid);
                if (tx == null) continue;
                TransactionDetail detail = factory.createTransactionDetail(xid, tx, entry.getValue());
                txDetailListJson.add((JsonValue)detail.toJSON());
            }
            String string = txDetailListJson.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        return this.listPreparedTransactionDetailsAsHTML((xid, tx, creation) -> new CoreTransactionDetail(xid, tx, creation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listPreparedTransactionDetailsAsHTML(TransactionDetailFactory factory) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listPreparedTransactionDetailsAsHTML((Object)this.server, (Object[])new Object[]{factory});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Map<Xid, Long> xids = this.resourceManager.getPreparedTransactionsWithCreationTime();
            if (xids == null || xids.size() == 0) {
                String string = "<h3>*** Prepared Transaction Details ***</h3><p>No entry.</p>";
                return string;
            }
            ArrayList<Map.Entry<Xid, Long>> xidsSortedByCreationTime = new ArrayList<Map.Entry<Xid, Long>>(xids.entrySet());
            Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

                @Override
                public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                    return entry1.getValue().compareTo(entry2.getValue());
                }
            });
            StringBuilder html = new StringBuilder();
            html.append("<h3>*** Prepared Transaction Details ***</h3>");
            for (Map.Entry<Xid, Long> entry : xidsSortedByCreationTime) {
                Xid xid = entry.getKey();
                Transaction tx = this.resourceManager.getTransaction(xid);
                if (tx == null) continue;
                TransactionDetail detail = factory.createTransactionDetail(xid, tx, entry.getValue());
                JsonObject txJson = detail.toJSON();
                html.append("<table border=\"1\">");
                html.append("<tr><th>creation_time</th>");
                html.append("<td>" + txJson.get((Object)"creation_time") + "</td>");
                html.append("<th>xid_as_base_64</th>");
                html.append("<td colspan=\"3\">" + txJson.get((Object)"xid_as_base64") + "</td></tr>");
                html.append("<tr><th>xid_format_id</th>");
                html.append("<td>" + txJson.get((Object)"xid_format_id") + "</td>");
                html.append("<th>xid_global_txid</th>");
                html.append("<td>" + txJson.get((Object)"xid_global_txid") + "</td>");
                html.append("<th>xid_branch_qual</th>");
                html.append("<td>" + txJson.get((Object)"xid_branch_qual") + "</td></tr>");
                html.append("<tr><th colspan=\"6\">Message List</th></tr>");
                html.append("<tr><td colspan=\"6\">");
                html.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
                JsonArray msgs = txJson.getJsonArray("tx_related_messages");
                for (int i = 0; i < msgs.size(); ++i) {
                    JsonObject msgJson = msgs.getJsonObject(i);
                    JsonObject props = msgJson.getJsonObject("message_properties");
                    StringBuilder propstr = new StringBuilder();
                    Set keys = props.keySet();
                    for (String key : keys) {
                        propstr.append(key);
                        propstr.append("=");
                        propstr.append(props.get((Object)key));
                        propstr.append(", ");
                    }
                    html.append("<th>operation_type</th>");
                    html.append("<td>" + msgJson.get((Object)"message_operation_type") + "</th>");
                    html.append("<th>message_type</th>");
                    html.append("<td>" + msgJson.get((Object)"message_type") + "</td></tr>");
                    html.append("<tr><th>properties</th>");
                    html.append("<td colspan=\"3\">" + propstr.toString() + "</td></tr>");
                }
                html.append("</table></td></tr>");
                html.append("</table><br>");
            }
            String string = html.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listHeuristicCommittedTransactions() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listHeuristicCommittedTransactions((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getHeuristicCommittedTransactions();
            String[] s = new String[xids.size()];
            int i = 0;
            for (Xid xid : xids) {
                s[i++] = XidImpl.toBase64String((Xid)xid);
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listHeuristicRolledBackTransactions() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listHeuristicRolledBackTransactions((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getHeuristicRolledbackTransactions();
            String[] s = new String[xids.size()];
            int i = 0;
            for (Xid xid : xids) {
                s[i++] = XidImpl.toBase64String((Xid)xid);
            }
            String[] stringArray = s;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean commitPreparedTransaction(String transactionAsBase64) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.commitPreparedTransaction((Object)this.server, (Object[])new Object[]{transactionAsBase64});
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getPreparedTransactions();
            for (Xid xid : xids) {
                if (!XidImpl.toBase64String((Xid)xid).equals(transactionAsBase64)) continue;
                Transaction transaction = this.resourceManager.removeTransaction(xid);
                transaction.commit(false);
                long recordID = this.server.getStorageManager().storeHeuristicCompletion(xid, true);
                this.storageManager.waitOnOperations();
                this.resourceManager.putHeuristicCompletion(recordID, xid, true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean rollbackPreparedTransaction(String transactionAsBase64) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.rollbackPreparedTransaction((Object)this.server, (Object[])new Object[]{transactionAsBase64});
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<Xid> xids = this.resourceManager.getPreparedTransactions();
            for (Xid xid : xids) {
                if (!XidImpl.toBase64String((Xid)xid).equals(transactionAsBase64)) continue;
                Transaction transaction = this.resourceManager.removeTransaction(xid);
                transaction.rollback();
                long recordID = this.server.getStorageManager().storeHeuristicCompletion(xid, false);
                this.server.getStorageManager().waitOnOperations();
                this.resourceManager.putHeuristicCompletion(recordID, xid, false);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listRemoteAddresses((Object)this.server, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            String[] remoteAddresses = new String[connections.size()];
            int i = 0;
            for (RemotingConnection connection : connections) {
                remoteAddresses[i++] = connection.getRemoteAddress();
            }
            String[] stringArray = remoteAddresses;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listRemoteAddresses(String ipAddress) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listRemoteAddresses((Object)this.server, (Object[])new Object[]{ipAddress});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            ArrayList<String> remoteConnections = new ArrayList<String>();
            for (RemotingConnection connection : connections) {
                String remoteAddress = connection.getRemoteAddress();
                if (!remoteAddress.contains(ipAddress)) continue;
                remoteConnections.add(connection.getRemoteAddress());
            }
            String[] stringArray = remoteConnections.toArray(new String[remoteConnections.size()]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnectionsForAddress(String ipAddress) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.closeConnectionsForAddress((Object)this.server, (Object[])new Object[]{ipAddress});
        }
        this.checkStarted();
        this.clearIO();
        try {
            boolean closed = false;
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            for (RemotingConnection connection : connections) {
                String remoteAddress = connection.getRemoteAddress();
                if (!remoteAddress.contains(ipAddress)) continue;
                connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsClosedByManagement(ipAddress));
                this.remotingService.removeConnection(connection.getID());
                closed = true;
            }
            boolean bl = closed;
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConsumerConnectionsForAddress(String address) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.closeConsumerConnectionsForAddress((Object)this.server, (Object[])new Object[]{address});
        }
        boolean closed = false;
        this.checkStarted();
        this.clearIO();
        try {
            for (Binding binding : this.postOffice.getMatchingBindings(SimpleString.toSimpleString((String)address)).getBindings()) {
                if (!(binding instanceof LocalQueueBinding)) continue;
                Queue queue = ((LocalQueueBinding)binding).getQueue();
                for (Consumer consumer : queue.getConsumers()) {
                    if (!(consumer instanceof ServerConsumer)) continue;
                    ServerConsumer serverConsumer = (ServerConsumer)consumer;
                    RemotingConnection connection = null;
                    for (RemotingConnection potentialConnection : this.remotingService.getConnections()) {
                        if (!potentialConnection.getID().toString().equals(serverConsumer.getConnectionID())) continue;
                        connection = potentialConnection;
                    }
                    if (connection == null) continue;
                    this.remotingService.removeConnection(connection.getID());
                    connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.consumerConnectionsClosedByManagement(address));
                    closed = true;
                }
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToCloseConsumerConnectionsForAddress(address, e);
        }
        finally {
            this.blockOnIO();
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnectionsForUser(String userName) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.closeConnectionsForUser((Object)this.server, (Object[])new Object[]{userName});
        }
        boolean closed = false;
        this.checkStarted();
        this.clearIO();
        try {
            for (ServerSession serverSession : this.server.getSessions()) {
                if (serverSession.getUsername() == null || !serverSession.getUsername().equals(userName)) continue;
                RemotingConnection connection = null;
                for (RemotingConnection potentialConnection : this.remotingService.getConnections()) {
                    if (!potentialConnection.getID().toString().equals(serverSession.getConnectionID().toString())) continue;
                    connection = potentialConnection;
                }
                if (connection == null) continue;
                this.remotingService.removeConnection(connection.getID());
                connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionsForUserClosedByManagement(userName));
                closed = true;
            }
        }
        finally {
            this.blockOnIO();
        }
        return closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnectionWithID(String ID) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.closeConnectionWithID((Object)this.server, (Object[])new Object[]{ID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            for (RemotingConnection connection : this.remotingService.getConnections()) {
                if (!connection.getID().toString().equals(ID)) continue;
                this.remotingService.removeConnection(connection.getID());
                connection.fail((ActiveMQException)ActiveMQMessageBundle.BUNDLE.connectionWithIDClosedByManagement(ID));
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.blockOnIO();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSessionWithID(String connectionID, String ID) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.closeSessionWithID((Object)this.server, (Object[])new Object[]{connectionID, ID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<ServerSession> sessions = this.server.getSessions(connectionID);
            for (ServerSession session : sessions) {
                if (!session.getName().equals(ID.toString())) continue;
                session.close(true);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.blockOnIO();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConsumerWithID(String sessionID, String ID) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.closeConsumerWithID((Object)this.server, (Object[])new Object[]{sessionID, ID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<ServerSession> sessions = this.server.getSessions();
            for (ServerSession session : sessions) {
                if (!session.getName().equals(sessionID.toString())) continue;
                Set<ServerConsumer> serverConsumers = session.getServerConsumers();
                for (ServerConsumer serverConsumer : serverConsumers) {
                    if (serverConsumer.sequentialID() != Long.valueOf(ID).longValue()) continue;
                    serverConsumer.disconnect();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.blockOnIO();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listConnectionIDs() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listConnectionIDs((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<RemotingConnection> connections = this.remotingService.getConnections();
            String[] connectionIDs = new String[connections.size()];
            int i = 0;
            for (RemotingConnection connection : connections) {
                connectionIDs[i++] = connection.getID().toString();
            }
            String[] stringArray = connectionIDs;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSessions(String connectionID) {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listSessions((Object)this.server, (Object[])new Object[]{connectionID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            List<ServerSession> sessions = this.server.getSessions(connectionID);
            String[] sessionIDs = new String[sessions.size()];
            int i = 0;
            for (ServerSession serverSession : sessions) {
                sessionIDs[i++] = serverSession.getName();
            }
            String[] stringArray = sessionIDs;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String listProducersInfoAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listProducersInfoAsJSON((Object)this.server);
        }
        JsonArrayBuilder producers = JsonLoader.createArrayBuilder();
        for (ServerSession session : this.server.getSessions()) {
            session.describeProducersInfo(producers);
        }
        return producers.build().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConnections(String options, int page, int pageSize) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listConnections((Object)this.server, (Object[])new Object[]{options, page, pageSize});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.getPostOffice().getAddresses();
            ConnectionView view = new ConnectionView(this.server);
            view.setCollection(this.server.getRemotingService().getConnections());
            view.setOptions(options);
            String string = view.getResultsAsJson(page, pageSize);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSessions(String options, int page, int pageSize) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listSessions((Object)this.server, (Object[])new Object[]{options, page, pageSize});
        }
        this.checkStarted();
        this.clearIO();
        try {
            SessionView view = new SessionView();
            view.setCollection(this.server.getSessions());
            view.setOptions(options);
            String string = view.getResultsAsJson(page, pageSize);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumers(String options, int page, int pageSize) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listConsumers((Object)this.server, (Object[])new Object[]{options, page, pageSize});
        }
        this.checkStarted();
        this.clearIO();
        try {
            HashSet<ServerConsumer> consumers = new HashSet<ServerConsumer>();
            for (ServerSession session : this.server.getSessions()) {
                consumers.addAll(session.getServerConsumers());
            }
            ConsumerView view = new ConsumerView(this.server);
            view.setCollection(consumers);
            view.setOptions(options);
            String string = view.getResultsAsJson(page, pageSize);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAddresses(String options, int page, int pageSize) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listAddresses((Object)this.server, (Object[])new Object[]{options, page, pageSize});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<SimpleString> addresses = this.server.getPostOffice().getAddresses();
            ArrayList<AddressInfo> addressInfo = new ArrayList<AddressInfo>();
            for (SimpleString address : addresses) {
                AddressInfo info = this.server.getPostOffice().getAddressInfo(address);
                if (info == null) continue;
                addressInfo.add(info);
            }
            AddressView view = new AddressView(this.server);
            view.setCollection(addressInfo);
            view.setOptions(options);
            String string = view.getResultsAsJson(page, pageSize);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listQueues(String options, int page, int pageSize) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listQueues((Object)this.server, (Object[])new Object[]{options, page, pageSize});
        }
        this.checkStarted();
        this.clearIO();
        try {
            ArrayList<QueueControl> queues = new ArrayList<QueueControl>();
            Object[] qs = this.server.getManagementService().getResources(QueueControl.class);
            for (int i = 0; i < qs.length; ++i) {
                queues.add((QueueControl)qs[i]);
            }
            QueueView view = new QueueView(this.server);
            view.setCollection(queues);
            view.setOptions(options);
            String string = view.getResultsAsJson(page, pageSize);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listProducers(@Parameter(name="Options") String options, @Parameter(name="Page Number") int page, @Parameter(name="Page Size") int pageSize) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listProducers((Object)this.server, (Object[])new Object[]{options, page, pageSize});
        }
        this.checkStarted();
        this.clearIO();
        try {
            HashSet<ServerProducer> producers = new HashSet<ServerProducer>();
            for (ServerSession session : this.server.getSessions()) {
                producers.addAll(session.getServerProducers().values());
            }
            ProducerView view = new ProducerView(this.server);
            view.setCollection(producers);
            view.setOptions(options);
            String string = view.getResultsAsJson(page, pageSize);
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConnectionsAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listConnectionsAsJSON((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder array = JsonLoader.createArrayBuilder();
            Set<RemotingConnection> connections = this.server.getRemotingService().getConnections();
            for (RemotingConnection connection : connections) {
                JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("connectionID", connection.getID().toString()).add("clientAddress", connection.getRemoteAddress()).add("creationTime", connection.getCreationTime()).add("implementation", connection.getClass().getSimpleName()).add("sessionCount", this.server.getSessions(connection.getID().toString()).size());
                array.add(obj);
            }
            String string = array.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSessionsAsJSON(String connectionID) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listSessionsAsJSON((Object)this.server, (Object[])new Object[]{connectionID});
        }
        this.checkStarted();
        this.clearIO();
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        try {
            List<ServerSession> sessions = this.server.getSessions(connectionID);
            for (ServerSession sess : sessions) {
                this.buildSessionJSON(array, sess);
            }
        }
        finally {
            this.blockOnIO();
        }
        return array.build().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAllSessionsAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listAllSessionsAsJSON((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        try {
            Set<ServerSession> sessions = this.server.getSessions();
            for (ServerSession sess : sessions) {
                this.buildSessionJSON(array, sess);
            }
        }
        finally {
            this.blockOnIO();
        }
        return array.build().toString();
    }

    public void buildSessionJSON(JsonArrayBuilder array, ServerSession sess) {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("sessionID", sess.getName()).add("creationTime", sess.getCreationTime()).add("consumerCount", sess.getServerConsumers().size());
        if (sess.getValidatedUser() != null) {
            obj.add("principal", sess.getValidatedUser());
        }
        if (sess.getMetaData() != null) {
            JsonObjectBuilder metadata = JsonLoader.createObjectBuilder();
            for (Map.Entry<String, String> entry : sess.getMetaData().entrySet()) {
                metadata.add(entry.getKey(), entry.getValue());
            }
            obj.add("metadata", metadata);
        }
        array.add(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listConsumersAsJSON(String connectionID) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listConsumersAsJSON((Object)this.server, (Object[])new Object[]{connectionID});
        }
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder array = JsonLoader.createArrayBuilder();
            Set<RemotingConnection> connections = this.server.getRemotingService().getConnections();
            for (RemotingConnection connection : connections) {
                if (!connectionID.equals(connection.getID().toString())) continue;
                List<ServerSession> sessions = this.server.getSessions(connectionID);
                for (ServerSession session : sessions) {
                    Set<ServerConsumer> consumers = session.getServerConsumers();
                    for (ServerConsumer consumer : consumers) {
                        JsonObject obj = this.toJSONObject(consumer);
                        if (obj == null) continue;
                        array.add((JsonValue)obj);
                    }
                }
            }
            String string = array.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listAllConsumersAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listAllConsumersAsJSON((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder array = JsonLoader.createArrayBuilder();
            Set<ServerSession> sessions = this.server.getSessions();
            for (ServerSession session : sessions) {
                Set<ServerConsumer> consumers = session.getServerConsumers();
                for (ServerConsumer consumer : consumers) {
                    JsonObject obj = this.toJSONObject(consumer);
                    if (obj == null) continue;
                    array.add((JsonValue)obj);
                }
            }
            String string = array.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    private JsonObject toJSONObject(ServerConsumer consumer) throws Exception {
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add("consumerID", consumer.getID()).add("connectionID", consumer.getConnectionID().toString()).add("sessionID", consumer.getSessionID()).add("queueName", consumer.getQueue().getName().toString()).add("browseOnly", consumer.isBrowseOnly()).add("creationTime", consumer.getCreationTime()).add("deliveringCount", consumer.getDeliveringMessages().size());
        if (consumer.getFilter() != null) {
            obj.add("filter", consumer.getFilter().getFilterString().toString());
        }
        return obj.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getConnectors() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getConnectors((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Collection<TransportConfiguration> connectorConfigurations = this.configuration.getConnectorConfigurations().values();
            Object[] ret = new Object[connectorConfigurations.size()];
            int i = 0;
            for (TransportConfiguration config : connectorConfigurations) {
                Object[] tc = new Object[]{config.getName(), config.getFactoryClassName(), config.getParams()};
                ret[i++] = tc;
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConnectorsAsJSON() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getConnectorsAsJSON((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder array = JsonLoader.createArrayBuilder();
            for (TransportConfiguration config : this.configuration.getConnectorConfigurations().values()) {
                array.add((JsonValue)config.toJson());
            }
            String string = array.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles) throws Exception {
        this.addSecuritySettings(addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles, "");
    }

    public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles) throws Exception {
        this.addSecuritySettings(addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles, browseRoles, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecuritySettings(String addressMatch, String sendRoles, String consumeRoles, String createDurableQueueRoles, String deleteDurableQueueRoles, String createNonDurableQueueRoles, String deleteNonDurableQueueRoles, String manageRoles, String browseRoles, String createAddressRoles, String deleteAddressRoles) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.addSecuritySettings((Object)this.server, (Object[])new Object[]{addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles, browseRoles, createAddressRoles, deleteAddressRoles});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set roles = SecurityFormatter.createSecurity((String)sendRoles, (String)consumeRoles, (String)createDurableQueueRoles, (String)deleteDurableQueueRoles, (String)createNonDurableQueueRoles, (String)deleteNonDurableQueueRoles, (String)manageRoles, (String)browseRoles, (String)createAddressRoles, (String)deleteAddressRoles);
            this.server.getSecurityRepository().addMatch(addressMatch, roles);
            PersistedRoles persistedRoles = new PersistedRoles(addressMatch, sendRoles, consumeRoles, createDurableQueueRoles, deleteDurableQueueRoles, createNonDurableQueueRoles, deleteNonDurableQueueRoles, manageRoles, browseRoles, createAddressRoles, deleteAddressRoles);
            this.storageManager.storeSecurityRoles(persistedRoles);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void removeSecuritySettings(String addressMatch) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.removeSecuritySettings((Object)this.server, (Object[])new Object[]{addressMatch});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.getSecurityRepository().removeMatch(addressMatch);
            this.storageManager.deleteSecurityRoles(new SimpleString(addressMatch));
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getRoles(String addressMatch) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRoles((Object)this.server, (Object[])new Object[]{addressMatch});
        }
        this.checkStarted();
        this.clearIO();
        try {
            Set<Role> roles = this.server.getSecurityRepository().getMatch(addressMatch);
            Object[] objRoles = new Object[roles.size()];
            int i = 0;
            for (Role role : roles) {
                objRoles[i++] = new Object[]{role.getName(), CheckType.SEND.hasRole(role), CheckType.CONSUME.hasRole(role), CheckType.CREATE_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_DURABLE_QUEUE.hasRole(role), CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), CheckType.MANAGE.hasRole(role)};
            }
            Object[] objectArray = objRoles;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRolesAsJSON(String addressMatch) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getRolesAsJSON((Object)this.server, (Object[])new Object[]{addressMatch});
        }
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder json = JsonLoader.createArrayBuilder();
            Set<Role> roles = this.server.getSecurityRepository().getMatch(addressMatch);
            for (Role role : roles) {
                json.add((JsonValue)role.toJson());
            }
            String string = json.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getAddressSettingsAsJSON(String address) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getAddressSettingsAsJSON((Object)this.server, (Object[])new Object[]{address});
        }
        this.checkStarted();
        AddressSettings addressSettings = this.server.getAddressSettingsRepository().getMatch(address);
        String policy = addressSettings.getAddressFullMessagePolicy() == AddressFullMessagePolicy.PAGE ? "PAGE" : (addressSettings.getAddressFullMessagePolicy() == AddressFullMessagePolicy.BLOCK ? "BLOCK" : (addressSettings.getAddressFullMessagePolicy() == AddressFullMessagePolicy.DROP ? "DROP" : "FAIL"));
        String consumerPolicy = addressSettings.getSlowConsumerPolicy() == SlowConsumerPolicy.NOTIFY ? "NOTIFY" : "KILL";
        JsonObjectBuilder settings = JsonLoader.createObjectBuilder();
        if (addressSettings.getDeadLetterAddress() != null) {
            settings.add("DLA", addressSettings.getDeadLetterAddress().toString());
        }
        if (addressSettings.getExpiryAddress() != null) {
            settings.add("expiryAddress", addressSettings.getExpiryAddress().toString());
        }
        return settings.add("expiryDelay", addressSettings.getExpiryDelay().longValue()).add("maxDeliveryAttempts", addressSettings.getMaxDeliveryAttempts()).add("pageCacheMaxSize", addressSettings.getPageCacheMaxSize()).add("maxSizeBytes", addressSettings.getMaxSizeBytes()).add("pageSizeBytes", addressSettings.getPageSizeBytes()).add("redeliveryDelay", addressSettings.getRedeliveryDelay()).add("redeliveryMultiplier", addressSettings.getRedeliveryMultiplier()).add("maxRedeliveryDelay", addressSettings.getMaxRedeliveryDelay()).add("redistributionDelay", addressSettings.getRedistributionDelay()).add("lastValueQueue", addressSettings.isDefaultLastValueQueue()).add("sendToDLAOnNoRoute", addressSettings.isSendToDLAOnNoRoute()).add("addressFullMessagePolicy", policy).add("slowConsumerThreshold", addressSettings.getSlowConsumerThreshold()).add("slowConsumerCheckPeriod", addressSettings.getSlowConsumerCheckPeriod()).add("slowConsumerPolicy", consumerPolicy).add("autoCreateJmsQueues", addressSettings.isAutoCreateJmsQueues()).add("autoCreateJmsTopics", addressSettings.isAutoCreateJmsTopics()).add("autoDeleteJmsQueues", addressSettings.isAutoDeleteJmsQueues()).add("autoDeleteJmsTopics", addressSettings.isAutoDeleteJmsQueues()).add("autoCreateQueues", addressSettings.isAutoCreateQueues()).add("autoDeleteQueues", addressSettings.isAutoDeleteQueues()).add("autoCreateAddress", addressSettings.isAutoCreateAddresses()).add("autoDeleteAddress", addressSettings.isAutoDeleteAddresses()).build().toString();
    }

    public void addAddressSettings(String address, String DLA, String expiryAddress, long expiryDelay, boolean lastValueQueue, int deliveryAttempts, long maxSizeBytes, int pageSizeBytes, int pageMaxCacheSize, long redeliveryDelay, double redeliveryMultiplier, long maxRedeliveryDelay, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, long slowConsumerThreshold, long slowConsumerCheckPeriod, String slowConsumerPolicy, boolean autoCreateJmsQueues, boolean autoDeleteJmsQueues, boolean autoCreateJmsTopics, boolean autoDeleteJmsTopics) throws Exception {
        this.addAddressSettings(address, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, true, true, true, true);
    }

    public void addAddressSettings(String address, String DLA, String expiryAddress, long expiryDelay, boolean lastValueQueue, int deliveryAttempts, long maxSizeBytes, int pageSizeBytes, int pageMaxCacheSize, long redeliveryDelay, double redeliveryMultiplier, long maxRedeliveryDelay, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy, long slowConsumerThreshold, long slowConsumerCheckPeriod, String slowConsumerPolicy, boolean autoCreateJmsQueues, boolean autoDeleteJmsQueues, boolean autoCreateJmsTopics, boolean autoDeleteJmsTopics, boolean autoCreateQueues, boolean autoDeleteQueues, boolean autoCreateAddresses, boolean autoDeleteAddresses) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.addAddressSettings((Object)this.server, (Object[])new Object[]{address, DLA, expiryAddress, expiryDelay, lastValueQueue, deliveryAttempts, maxSizeBytes, pageSizeBytes, pageMaxCacheSize, redeliveryDelay, redeliveryMultiplier, maxRedeliveryDelay, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy, slowConsumerThreshold, slowConsumerCheckPeriod, slowConsumerPolicy, autoCreateJmsQueues, autoDeleteJmsQueues, autoCreateJmsTopics, autoDeleteJmsTopics, autoCreateQueues, autoDeleteQueues, autoCreateAddresses, autoDeleteAddresses});
        }
        this.checkStarted();
        if ((long)pageSizeBytes > maxSizeBytes && maxSizeBytes > 0L) {
            throw new IllegalStateException("pageSize has to be lower than maxSizeBytes. Invalid argument (" + pageSizeBytes + " < " + maxSizeBytes + ")");
        }
        if (maxSizeBytes < -1L) {
            throw new IllegalStateException("Invalid argument on maxSizeBytes");
        }
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setDeadLetterAddress(DLA == null ? null : new SimpleString(DLA));
        addressSettings.setExpiryAddress(expiryAddress == null ? null : new SimpleString(expiryAddress));
        addressSettings.setExpiryDelay(expiryDelay);
        addressSettings.setDefaultLastValueQueue(lastValueQueue);
        addressSettings.setMaxDeliveryAttempts(deliveryAttempts);
        addressSettings.setPageCacheMaxSize(pageMaxCacheSize);
        addressSettings.setMaxSizeBytes(maxSizeBytes);
        addressSettings.setPageSizeBytes(pageSizeBytes);
        addressSettings.setRedeliveryDelay(redeliveryDelay);
        addressSettings.setRedeliveryMultiplier(redeliveryMultiplier);
        addressSettings.setMaxRedeliveryDelay(maxRedeliveryDelay);
        addressSettings.setRedistributionDelay(redistributionDelay);
        addressSettings.setSendToDLAOnNoRoute(sendToDLAOnNoRoute);
        if (addressFullMessagePolicy == null) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("PAGE")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("DROP")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.DROP);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("BLOCK")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.BLOCK);
        } else if (addressFullMessagePolicy.equalsIgnoreCase("FAIL")) {
            addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL);
        }
        addressSettings.setSlowConsumerThreshold(slowConsumerThreshold);
        addressSettings.setSlowConsumerCheckPeriod(slowConsumerCheckPeriod);
        if (slowConsumerPolicy == null) {
            addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
        } else if (slowConsumerPolicy.equalsIgnoreCase("NOTIFY")) {
            addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.NOTIFY);
        } else if (slowConsumerPolicy.equalsIgnoreCase("KILL")) {
            addressSettings.setSlowConsumerPolicy(SlowConsumerPolicy.KILL);
        }
        addressSettings.setAutoCreateJmsQueues(autoCreateJmsQueues);
        addressSettings.setAutoDeleteJmsQueues(autoDeleteJmsQueues);
        addressSettings.setAutoCreateJmsTopics(autoCreateJmsTopics);
        addressSettings.setAutoDeleteJmsTopics(autoDeleteJmsTopics);
        addressSettings.setAutoCreateQueues(autoCreateQueues);
        addressSettings.setAutoDeleteQueues(autoDeleteQueues);
        addressSettings.setAutoCreateAddresses(autoCreateAddresses);
        addressSettings.setAutoDeleteAddresses(autoDeleteAddresses);
        this.server.getAddressSettingsRepository().addMatch(address, addressSettings);
        this.storageManager.storeAddressSetting(new PersistedAddressSetting(new SimpleString(address), addressSettings));
    }

    public void removeAddressSettings(String addressMatch) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.removeAddressSettings((Object)this.server, (Object[])new Object[]{addressMatch});
        }
        this.checkStarted();
        this.server.getAddressSettingsRepository().removeMatch(addressMatch);
        this.storageManager.deleteAddressSetting(new SimpleString(addressMatch));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueueInfoToQueue(String queueName, String address) throws Exception {
        this.checkStarted();
        this.clearIO();
        try {
            this.postOffice.sendQueueInfoToQueue(new SimpleString(queueName), new SimpleString(address == null ? "" : address));
            GroupingHandler handler = this.server.getGroupingHandler();
            if (handler != null) {
                handler.resendPending();
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDivertNames() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getDivertNames((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Object[] diverts = this.server.getManagementService().getResources(DivertControl.class);
            String[] names = new String[diverts.length];
            for (int i = 0; i < diverts.length; ++i) {
                DivertControl divert = (DivertControl)diverts[i];
                names[i] = divert.getUniqueName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName) throws Exception {
        this.createDivert(name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, ActiveMQDefaultConfiguration.getDefaultDivertRoutingType());
    }

    public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName, String routingType) throws Exception {
        this.createDivert(name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, (String)null, routingType);
    }

    public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName, String transformerPropertiesAsJSON, String routingType) throws Exception {
        this.createDivert(name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, JsonUtil.readJsonProperties((String)transformerPropertiesAsJSON), routingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDivert(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName, Map<String, String> transformerProperties, String routingType) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createDivert((Object)this.server, (Object[])new Object[]{name, routingName, address, forwardingAddress, exclusive, filterString, transformerClassName, transformerProperties, routingType});
        }
        this.checkStarted();
        this.clearIO();
        try {
            TransformerConfiguration transformerConfiguration = transformerClassName == null ? null : new TransformerConfiguration(transformerClassName).setProperties(transformerProperties);
            DivertConfiguration config = new DivertConfiguration().setName(name).setRoutingName(routingName).setAddress(address).setForwardingAddress(forwardingAddress).setExclusive(exclusive).setFilterString(filterString).setTransformerConfiguration(transformerConfiguration).setRoutingType(ComponentConfigurationRoutingType.valueOf((String)routingType));
            this.server.deployDivert(config);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyDivert(String name) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.destroyDivert((Object)this.server, (Object[])new Object[]{name});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.destroyDivert(SimpleString.toSimpleString((String)name));
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getBridgeNames() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getBridgeNames((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            Object[] bridges = this.server.getManagementService().getResources(BridgeControl.class);
            String[] names = new String[bridges.length];
            for (int i = 0; i < bridges.length; ++i) {
                BridgeControl bridge = (BridgeControl)bridges[i];
                names[i] = bridge.getName();
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String staticConnectorsOrDiscoveryGroup, boolean useDiscoveryGroup, boolean ha, String user, String password) throws Exception {
        this.createBridge(name, queueName, forwardingAddress, filterString, transformerClassName, (String)null, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, producerWindowSize, clientFailureCheckPeriod, staticConnectorsOrDiscoveryGroup, useDiscoveryGroup, ha, user, password);
    }

    public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, String transformerPropertiesAsJSON, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String staticConnectorsOrDiscoveryGroup, boolean useDiscoveryGroup, boolean ha, String user, String password) throws Exception {
        this.createBridge(name, queueName, forwardingAddress, filterString, transformerClassName, JsonUtil.readJsonProperties((String)transformerPropertiesAsJSON), retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, producerWindowSize, clientFailureCheckPeriod, staticConnectorsOrDiscoveryGroup, useDiscoveryGroup, ha, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, Map<String, String> transformerProperties, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, int producerWindowSize, long clientFailureCheckPeriod, String staticConnectorsOrDiscoveryGroup, boolean useDiscoveryGroup, boolean ha, String user, String password) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createBridge((Object)this.server, (Object[])new Object[]{name, queueName, forwardingAddress, filterString, transformerClassName, transformerProperties, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, producerWindowSize, clientFailureCheckPeriod, staticConnectorsOrDiscoveryGroup, useDiscoveryGroup, ha, user, "****"});
        }
        this.checkStarted();
        this.clearIO();
        try {
            TransformerConfiguration transformerConfiguration = transformerClassName == null ? null : new TransformerConfiguration(transformerClassName).setProperties(transformerProperties);
            BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setTransformerConfiguration(transformerConfiguration).setClientFailureCheckPeriod(clientFailureCheckPeriod).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setHA(ha).setUser(user).setPassword(password);
            if (useDiscoveryGroup) {
                config.setDiscoveryGroupName(staticConnectorsOrDiscoveryGroup);
            } else {
                config.setStaticConnectors(ListUtil.toList((String)staticConnectorsOrDiscoveryGroup));
            }
            this.server.deployBridge(config);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBridge(String name, String queueName, String forwardingAddress, String filterString, String transformerClassName, long retryInterval, double retryIntervalMultiplier, int initialConnectAttempts, int reconnectAttempts, boolean useDuplicateDetection, int confirmationWindowSize, long clientFailureCheckPeriod, String staticConnectorsOrDiscoveryGroup, boolean useDiscoveryGroup, boolean ha, String user, String password) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createBridge((Object)this.server, (Object[])new Object[]{name, queueName, forwardingAddress, filterString, transformerClassName, retryInterval, retryIntervalMultiplier, initialConnectAttempts, reconnectAttempts, useDuplicateDetection, confirmationWindowSize, clientFailureCheckPeriod, staticConnectorsOrDiscoveryGroup, useDiscoveryGroup, ha, user, "****"});
        }
        this.checkStarted();
        this.clearIO();
        try {
            TransformerConfiguration transformerConfiguration = transformerClassName == null ? null : new TransformerConfiguration(transformerClassName);
            BridgeConfiguration config = new BridgeConfiguration().setName(name).setQueueName(queueName).setForwardingAddress(forwardingAddress).setFilterString(filterString).setTransformerConfiguration(transformerConfiguration).setClientFailureCheckPeriod(clientFailureCheckPeriod).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setInitialConnectAttempts(initialConnectAttempts).setReconnectAttempts(reconnectAttempts).setUseDuplicateDetection(useDuplicateDetection).setConfirmationWindowSize(confirmationWindowSize).setHA(ha).setUser(user).setPassword(password);
            if (useDiscoveryGroup) {
                config.setDiscoveryGroupName(staticConnectorsOrDiscoveryGroup);
            } else {
                config.setStaticConnectors(ListUtil.toList((String)staticConnectorsOrDiscoveryGroup));
            }
            this.server.deployBridge(config);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyBridge(String name) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.destroyBridge((Object)this.server, (Object[])new Object[]{name});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.destroyBridge(name);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnectorService(String name, String factoryClass, Map<String, Object> parameters) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.createConnectorService((Object)this.server, (Object[])new Object[]{name, factoryClass, parameters});
        }
        this.checkStarted();
        this.clearIO();
        try {
            ConnectorServiceConfiguration config = new ConnectorServiceConfiguration().setName(name).setFactoryClassName(factoryClass).setParams(parameters);
            ConnectorServiceFactory factory = this.server.getServiceRegistry().getConnectorService(config);
            this.server.getConnectorsService().createService(config, factory);
        }
        finally {
            this.blockOnIO();
        }
    }

    public void destroyConnectorService(String name) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.destroyConnectorService((Object)this.server, (Object[])new Object[]{name});
        }
        this.checkStarted();
        this.clearIO();
        try {
            this.server.getConnectorsService().destroyService(name);
        }
        finally {
            this.blockOnIO();
        }
    }

    public String[] getConnectorServices() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getConnectorServices((Object)this.server, (Object[])new Object[0]);
        }
        this.checkStarted();
        this.clearIO();
        try {
            String[] stringArray = this.server.getConnectorsService().getConnectors().keySet().toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void forceFailover() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.forceFailover((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ActiveMQServerControlImpl.this.server.stop(true, true);
                }
                catch (Throwable e) {
                    logger.warn((Object)e.getMessage(), e);
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDuplicateIdCache(String address, Object[] ids) throws Exception {
        this.clearIO();
        try {
            DuplicateIDCache duplicateIDCache = this.server.getPostOffice().getDuplicateIDCache(new SimpleString(address));
            for (Object id : ids) {
                duplicateIDCache.addToCache(((String)id).getBytes(), null);
            }
        }
        finally {
            this.blockOnIO();
        }
    }

    public void scaleDown(String connector) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.scaleDown((Object)this.server, (Object[])new Object[]{connector});
        }
        this.checkStarted();
        this.clearIO();
        HAPolicy haPolicy = this.server.getHAPolicy();
        if (haPolicy instanceof LiveOnlyPolicy) {
            LiveOnlyPolicy liveOnlyPolicy = (LiveOnlyPolicy)haPolicy;
            if (liveOnlyPolicy.getScaleDownPolicy() == null) {
                liveOnlyPolicy.setScaleDownPolicy(new ScaleDownPolicy());
            }
            liveOnlyPolicy.getScaleDownPolicy().setEnabled(true);
            if (connector != null) {
                liveOnlyPolicy.getScaleDownPolicy().getConnectors().add(0, connector);
            }
            this.server.fail(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listNetworkTopology() throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listNetworkTopology((Object)this.server);
        }
        this.checkStarted();
        this.clearIO();
        try {
            JsonArrayBuilder brokers = JsonLoader.createArrayBuilder();
            ClusterManager clusterManager = this.server.getClusterManager();
            if (clusterManager != null) {
                Set<ClusterConnection> clusterConnections = clusterManager.getClusterConnections();
                for (ClusterConnection clusterConnection : clusterConnections) {
                    Topology topology = clusterConnection.getTopology();
                    Collection members = topology.getMembers();
                    for (TopologyMemberImpl member : members) {
                        JsonObjectBuilder obj = JsonLoader.createObjectBuilder();
                        TransportConfiguration live = member.getLive();
                        if (live != null) {
                            obj.add("nodeID", member.getNodeId()).add("live", live.getParams().get("host") + ":" + live.getParams().get("port"));
                            TransportConfiguration backup = member.getBackup();
                            if (backup != null) {
                                obj.add("backup", backup.getParams().get("host") + ":" + backup.getParams().get("port"));
                            }
                        }
                        brokers.add(obj);
                    }
                }
            }
            String string = brokers.build().toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (AuditLogger.isEnabled()) {
            AuditLogger.removeNotificationListener((Object)this.server, (Object[])new Object[]{listener, filter, handback});
        }
        this.clearIO();
        try {
            this.broadcaster.removeNotificationListener(listener, filter, handback);
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (AuditLogger.isEnabled()) {
            AuditLogger.removeNotificationListener((Object)this.server, (Object[])new Object[]{listener});
        }
        this.clearIO();
        try {
            this.broadcaster.removeNotificationListener(listener);
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (AuditLogger.isEnabled()) {
            AuditLogger.addNotificationListener((Object)this.server, (Object[])new Object[]{listener, filter, handback});
        }
        this.clearIO();
        try {
            this.broadcaster.addNotificationListener(listener, filter, handback);
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getNotificationInfo((Object)this.server);
        }
        CoreNotificationType[] values = CoreNotificationType.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(names, this.getClass().getName(), "Notifications emitted by a Core Server")};
    }

    private synchronized void setMessageCounterEnabled(boolean enable) {
        if (this.isStarted()) {
            if (this.configuration.isMessageCounterEnabled() && !enable) {
                this.stopMessageCounters();
            } else if (!this.configuration.isMessageCounterEnabled() && enable) {
                this.startMessageCounters();
            }
        }
        this.configuration.setMessageCounterEnabled(enable);
    }

    private void startMessageCounters() {
        this.messageCounterManager.start();
    }

    private void stopMessageCounters() {
        this.messageCounterManager.stop();
        this.messageCounterManager.resetAllCounters();
        this.messageCounterManager.resetAllCounterHistories();
    }

    public long getConnectionTTLOverride() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getConnectionTTLOverride((Object)this.server);
        }
        return this.configuration.getConnectionTTLOverride();
    }

    public int getIDCacheSize() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getIDCacheSize((Object)this.server);
        }
        return this.configuration.getIDCacheSize();
    }

    public String getLargeMessagesDirectory() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getLargeMessagesDirectory((Object)this.server);
        }
        return this.configuration.getLargeMessagesDirectory();
    }

    public String getManagementAddress() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getManagementAddress((Object)this.server);
        }
        return this.configuration.getManagementAddress().toString();
    }

    public String getNodeID() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getNodeID((Object)this.server);
        }
        return this.server.getNodeID() == null ? null : this.server.getNodeID().toString();
    }

    public String getManagementNotificationAddress() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getManagementNotificationAddress((Object)this.server);
        }
        return this.configuration.getManagementNotificationAddress().toString();
    }

    public long getMessageExpiryScanPeriod() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getMessageExpiryScanPeriod((Object)this.server);
        }
        return this.configuration.getMessageExpiryScanPeriod();
    }

    public long getMessageExpiryThreadPriority() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getMessageExpiryThreadPriority((Object)this.server);
        }
        return this.configuration.getMessageExpiryThreadPriority();
    }

    public long getTransactionTimeout() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTransactionTimeout((Object)this.server);
        }
        return this.configuration.getTransactionTimeout();
    }

    public long getTransactionTimeoutScanPeriod() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.getTransactionTimeoutScanPeriod((Object)this.server);
        }
        return this.configuration.getTransactionTimeoutScanPeriod();
    }

    public boolean isPersistDeliveryCountBeforeDelivery() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isPersistDeliveryCountBeforeDelivery((Object)this.server);
        }
        return this.configuration.isPersistDeliveryCountBeforeDelivery();
    }

    public boolean isPersistIDCache() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isPersistIDCache((Object)this.server);
        }
        return this.configuration.isPersistIDCache();
    }

    public boolean isWildcardRoutingEnabled() {
        if (AuditLogger.isEnabled()) {
            AuditLogger.isWildcardRoutingEnabled((Object)this.server);
        }
        return this.configuration.isWildcardRoutingEnabled();
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(ActiveMQServerControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(ActiveMQServerControl.class);
    }

    private void checkStarted() {
        if (!this.server.isStarted()) {
            throw new IllegalStateException("Broker is not started. It can not be managed yet");
        }
    }

    public String[] listTargetAddresses(String sessionID) {
        ServerSession session = this.server.getSessionByID(sessionID);
        if (session != null) {
            return session.getTargetAddresses();
        }
        return new String[0];
    }

    public void onNotification(Notification notification) {
        TypedProperties props;
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        CoreNotificationType type = (CoreNotificationType)notification.getType();
        if (type == CoreNotificationType.SESSION_CREATED && (props = notification.getProperties()).getIntProperty(ManagementHelper.HDR_DISTANCE) > 0) {
            return;
        }
        this.broadcaster.sendNotification(new javax.management.Notification(type.toString(), (Object)this, this.notifSeq.incrementAndGet(), notification.toString()));
    }

    public void addUser(String username, String password, String roles, boolean plaintext) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.addUser((Object)this.server, (Object[])new Object[]{username, "****", roles, plaintext});
        }
        this.tcclInvoke(ActiveMQServerControlImpl.class.getClassLoader(), () -> this.internalAddUser(username, password, roles, plaintext));
    }

    private void internalAddUser(String username, String password, String roles, boolean plaintext) throws Exception {
        PropertiesLoginModuleConfigurator config = this.getPropertiesLoginModuleConfigurator();
        config.addNewUser(username, plaintext ? password : PasswordMaskingUtil.getHashProcessor().hash(password), roles.split(","));
        config.save();
    }

    private String getSecurityDomain() {
        return this.server.getSecurityManager().getDomain();
    }

    public String listUser(String username) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.listUser((Object)this.server, (Object[])new Object[]{username});
        }
        return (String)this.tcclCall(ActiveMQServerControlImpl.class.getClassLoader(), () -> this.internaListUser(username));
    }

    private String internaListUser(String username) throws Exception {
        PropertiesLoginModuleConfigurator config = this.getPropertiesLoginModuleConfigurator();
        Map<String, Set<String>> info = config.listUser(username);
        JsonArrayBuilder users = JsonLoader.createArrayBuilder();
        for (Map.Entry<String, Set<String>> entry : info.entrySet()) {
            JsonObjectBuilder user = JsonLoader.createObjectBuilder();
            user.add("username", entry.getKey());
            JsonArrayBuilder roles = JsonLoader.createArrayBuilder();
            for (String role : entry.getValue()) {
                roles.add(role);
            }
            user.add("roles", roles);
            users.add(user);
        }
        return users.build().toString();
    }

    public void removeUser(String username) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.removeUser((Object)this.server, (Object[])new Object[]{username});
        }
        this.tcclInvoke(ActiveMQServerControlImpl.class.getClassLoader(), () -> this.internalRemoveUser(username));
    }

    private void internalRemoveUser(String username) throws Exception {
        PropertiesLoginModuleConfigurator config = this.getPropertiesLoginModuleConfigurator();
        config.removeUser(username);
        config.save();
    }

    public void resetUser(String username, String password, String roles) throws Exception {
        if (AuditLogger.isEnabled()) {
            AuditLogger.resetUser((Object)this.server, (Object[])new Object[]{username, "****", roles});
        }
        this.tcclInvoke(ActiveMQServerControlImpl.class.getClassLoader(), () -> this.internalresetUser(username, password, roles));
    }

    private void internalresetUser(String username, String password, String roles) throws Exception {
        PropertiesLoginModuleConfigurator config = this.getPropertiesLoginModuleConfigurator();
        config.updateUser(username, password, roles == null ? null : roles.split(","));
        config.save();
    }

    private PropertiesLoginModuleConfigurator getPropertiesLoginModuleConfigurator() throws Exception {
        URL configurationUrl = this.server.getConfiguration().getConfigurationUrl();
        if (configurationUrl == null) {
            throw ActiveMQMessageBundle.BUNDLE.failedToLocateConfigURL();
        }
        String path = configurationUrl.getPath();
        return new PropertiesLoginModuleConfigurator(this.getSecurityDomain(), path.substring(0, path.lastIndexOf("/")));
    }

    public static enum QueueTextFormatter {
        Long{

            @Override
            StringBuilder format(Queue queue, StringBuilder output) {
                output.append("Queue [name=").append((CharSequence)queue.getName());
                output.append(", address=").append((CharSequence)queue.getAddress());
                output.append(", routingType=").append(queue.getRoutingType());
                Filter filter = queue.getFilter();
                if (filter != null) {
                    output.append(", filter=").append((CharSequence)filter.getFilterString());
                }
                output.append(", durable=").append(queue.isDurable());
                int maxConsumers = queue.getMaxConsumers();
                if (maxConsumers != -1) {
                    output.append(", maxConsumers=").append(queue.getMaxConsumers());
                }
                output.append(", purgeOnNoConsumers=").append(queue.isPurgeOnNoConsumers());
                output.append(", autoCreateAddress=").append(queue.isAutoCreated());
                output.append(", exclusive=").append(queue.isExclusive());
                output.append(", lastValue=").append(queue.isLastValue());
                output.append(", lastValueKey=").append((CharSequence)queue.getLastValueKey());
                output.append(", nonDestructive=").append(queue.isNonDestructive());
                output.append(", consumersBeforeDispatch=").append(queue.getConsumersBeforeDispatch());
                output.append(", delayBeforeDispatch=").append(queue.getDelayBeforeDispatch());
                output.append(", autoCreateAddress=").append(queue.isAutoCreated());
                output.append(']');
                return output;
            }
        };


        abstract StringBuilder format(Queue var1, StringBuilder var2);
    }

    private static enum AddressInfoTextFormatter {
        Long{

            @Override
            public StringBuilder format(AddressInfo addressInfo, StringBuilder output) {
                output.append("Address [name=").append((CharSequence)addressInfo.getName());
                output.append(", routingTypes={");
                EnumSet<RoutingType> routingTypes = addressInfo.getRoutingTypes();
                if (!routingTypes.isEmpty()) {
                    for (RoutingType routingType : routingTypes) {
                        output.append(routingType).append(',');
                    }
                    output.deleteCharAt(output.length() - 1);
                }
                output.append('}');
                output.append(", autoCreated=").append(addressInfo.isAutoCreated());
                output.append(']');
                return output;
            }
        };


        public abstract StringBuilder format(AddressInfo var1, StringBuilder var2);
    }
}

