/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.openssl.Cipher;
import org.wildfly.openssl.CipherSuiteConverter;
import org.wildfly.openssl.Messages;
import org.wildfly.openssl.OpenSSLClientSessionContext;
import org.wildfly.openssl.OpenSSLEngine;
import org.wildfly.openssl.OpenSSLServerSessionContext;
import org.wildfly.openssl.OpenSSLServerSocket;
import org.wildfly.openssl.OpenSSLSocket;
import org.wildfly.openssl.OpenSslX509Certificate;
import org.wildfly.openssl.SSL;

public abstract class OpenSSLContextSPI
extends SSLContextSpi {
    private static final Logger LOG = Logger.getLogger(OpenSSLContextSPI.class.getName());
    public static final int DEFAULT_SESSION_CACHE_SIZE = 1000;
    private static final String BEGIN_RSA_CERT = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final String END_RSA_CERT = "\n-----END RSA PRIVATE KEY-----";
    private static final String BEGIN_DSA_CERT = "-----BEGIN DSA PRIVATE KEY-----\n";
    private static final String END_DSA_CERT = "\n-----END DSA PRIVATE KEY-----";
    private static final String[] ALGORITHMS = new String[]{"RSA", "DSA"};
    private OpenSSLServerSessionContext serverSessionContext;
    private OpenSSLClientSessionContext clientSessionContext;
    private static volatile String[] allAvailableCiphers;
    protected final long ctx;
    final int supportedCiphers;
    private volatile String[] ciphers;
    static final CertificateFactory X509_CERT_FACTORY;
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] getAvailableCipherSuites() {
        if (allAvailableCiphers != null) return allAvailableCiphers;
        Class<OpenSSLContextSPI> clazz = OpenSSLContextSPI.class;
        synchronized (OpenSSLContextSPI.class) {
            if (allAvailableCiphers != null) return allAvailableCiphers;
            LinkedHashSet<String> availableCipherSuites = new LinkedHashSet<String>(128);
            try {
                long sslCtx = SSL.getInstance().makeSSLContext(28, 1);
                try {
                    SSL.getInstance().setSSLContextOptions(sslCtx, 4095);
                    SSL.getInstance().setCipherSuite(sslCtx, "ALL");
                    long ssl = SSL.getInstance().newSSL(sslCtx, true);
                    try {
                        for (String c : SSL.getInstance().getCiphers(ssl)) {
                            if (c == null || c.length() == 0 || availableCipherSuites.contains(c)) continue;
                            availableCipherSuites.add(CipherSuiteConverter.toJava(c, "TLS"));
                        }
                    }
                    finally {
                        SSL.getInstance().freeSSL(ssl);
                    }
                }
                finally {
                    SSL.getInstance().freeSSLContext(sslCtx);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, Messages.MESSAGES.failedToInitializeCiphers(), e);
            }
            allAvailableCiphers = availableCipherSuites.toArray(new String[availableCipherSuites.size()]);
            // ** MonitorExit[var0] (shouldn't be in output)
            return allAvailableCiphers;
        }
    }

    OpenSSLContextSPI(int value) throws SSLException {
        this.supportedCiphers = value;
        SSL.init();
        try {
            try {
                this.ctx = SSL.getInstance().makeSSLContext(value, 2);
            }
            catch (Exception e) {
                throw new SSLException(Messages.MESSAGES.failedToMakeSslContext(), e);
            }
            try {
                SSL.getInstance().clearSSLContextOptions(this.ctx, 262144);
            }
            catch (UnsatisfiedLinkError e) {
                // empty catch block
            }
            boolean disableCompressionSupported = false;
            try {
                disableCompressionSupported = SSL.getInstance().hasOp(131072);
                if (disableCompressionSupported) {
                    SSL.getInstance().setSSLContextOptions(this.ctx, 131072);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!disableCompressionSupported) {
                LOG.fine("The version of SSL in use does not support disabling compression");
            }
            boolean disableSessionTicketsSupported = false;
            try {
                disableSessionTicketsSupported = SSL.getInstance().hasOp(16384);
                if (disableSessionTicketsSupported) {
                    SSL.getInstance().setSSLContextOptions(this.ctx, 16384);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!disableSessionTicketsSupported) {
                LOG.fine("The version of SSL in use does not support disabling session tickets");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.MESSAGES.failedToInitializeSslContext(), e);
        }
    }

    private synchronized void init(KeyManager[] kms, TrustManager[] tms) throws KeyManagementException {
        if (this.initialized) {
            LOG.warning(Messages.MESSAGES.ignoringSecondInit());
            return;
        }
        try {
            X509KeyManager keyManager = this.chooseKeyManager(kms);
            if (keyManager != null) {
                block2: for (String algorithm : ALGORITHMS) {
                    boolean rsa = algorithm.equals("RSA");
                    String[] aliases = keyManager.getServerAliases(algorithm, null);
                    if (aliases == null || aliases.length == 0) continue;
                    for (String alias : aliases) {
                        X509Certificate[] certificateChain = keyManager.getCertificateChain(alias);
                        PrivateKey key = keyManager.getPrivateKey(alias);
                        if (key == null || certificateChain == null || key.getEncoded() == null) continue;
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("Using alias " + alias + " for " + algorithm);
                        }
                        StringBuilder sb = new StringBuilder(rsa ? BEGIN_RSA_CERT : BEGIN_DSA_CERT);
                        byte[] encodedPrivateKey = key.getEncoded();
                        if (encodedPrivateKey == null) {
                            throw new KeyManagementException(Messages.MESSAGES.unableToObtainPrivateKey());
                        }
                        sb.append(Base64.getMimeEncoder(64, new byte[]{10}).encodeToString(encodedPrivateKey));
                        sb.append(rsa ? END_RSA_CERT : END_DSA_CERT);
                        byte[][] encodedIntermediaries = new byte[certificateChain.length - 1][];
                        for (int i = 1; i < certificateChain.length; ++i) {
                            encodedIntermediaries[i - 1] = certificateChain[i].getEncoded();
                        }
                        X509Certificate certificate = certificateChain[0];
                        SSL.getInstance().setCertificate(this.ctx, certificate.getEncoded(), encodedIntermediaries, sb.toString().getBytes(StandardCharsets.US_ASCII), rsa ? 0 : 1);
                        continue block2;
                    }
                }
            }
            SSL.getInstance().setSessionCacheSize(this.ctx, 1000L);
            X509TrustManager manager = OpenSSLContextSPI.chooseTrustManager(tms);
            if (manager != null) {
                SSL.getInstance().setCertVerifyCallback(this.ctx, (ssl, chain, cipherNo, server) -> {
                    X509Certificate[] peerCerts = OpenSSLContextSPI.certificates(chain);
                    Cipher cipher = Cipher.valueOf(cipherNo);
                    String auth = cipher == null ? "RSA" : cipher.getAu().toString();
                    try {
                        if (server) {
                            manager.checkClientTrusted(peerCerts, auth);
                        } else {
                            manager.checkServerTrusted(peerCerts, auth);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Certificate verification failed", e);
                        }
                        return false;
                    }
                });
            }
            this.serverSessionContext = new OpenSSLServerSessionContext(this.ctx);
            this.serverSessionContext.setSessionIdContext("test".getBytes(StandardCharsets.US_ASCII));
            this.clientSessionContext = new OpenSSLClientSessionContext(this.ctx);
            this.initialized = true;
            SSL.getInstance().enableAlpn(this.ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private X509KeyManager chooseKeyManager(KeyManager[] tms) {
        if (tms == null) {
            return null;
        }
        for (KeyManager tm : tms) {
            if (!(tm instanceof X509KeyManager)) continue;
            return (X509KeyManager)tm;
        }
        throw new IllegalStateException(Messages.MESSAGES.keyManagerIsMissing());
    }

    static X509TrustManager chooseTrustManager(TrustManager[] managers) {
        if (managers == null) {
            try {
                TrustManagerFactory instance = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                instance.init((KeyStore)null);
                managers = instance.getTrustManagers();
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
        for (TrustManager m : managers) {
            if (!(m instanceof X509TrustManager)) continue;
            return (X509TrustManager)m;
        }
        throw new IllegalStateException(Messages.MESSAGES.trustManagerIsMissing());
    }

    private static X509Certificate[] certificates(byte[][] chain) {
        X509Certificate[] peerCerts = new X509Certificate[chain.length];
        for (int i = 0; i < peerCerts.length; ++i) {
            peerCerts[i] = new OpenSslX509Certificate(chain[i]);
        }
        return peerCerts;
    }

    public SSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    public SSLEngine createSSLEngine() {
        return new OpenSSLEngine(this.ctx, false, this);
    }

    public SSLEngine createSSLEngine(String host, int port) {
        return new OpenSSLEngine(this.ctx, false, this, host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCiphers() {
        if (this.ciphers == null) {
            OpenSSLContextSPI openSSLContextSPI = this;
            synchronized (openSSLContextSPI) {
                if (this.ciphers == null) {
                    OpenSSLEngine engine = (OpenSSLEngine)this.createSSLEngine();
                    engine.initSsl();
                    this.ciphers = engine.getEnabledCipherSuites();
                }
            }
        }
        return (String[])this.ciphers.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        super.finalize();
        Class<OpenSSLContextSPI> clazz = OpenSSLContextSPI.class;
        synchronized (OpenSSLContextSPI.class) {
            if (this.ctx != 0L) {
                SSL.getInstance().freeSSLContext(this.ctx);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.init(km, tm);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return new SSLSocketFactory(){

            @Override
            public String[] getDefaultCipherSuites() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return (String[])OpenSSLContextSPI.this.getCiphers().clone();
            }

            @Override
            public Socket createSocket() throws IOException {
                return new OpenSSLSocket(new OpenSSLEngine(OpenSSLContextSPI.this.ctx, true, OpenSSLContextSPI.this));
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                return new OpenSSLSocket(s, autoClose, host, port, new OpenSSLEngine(OpenSSLContextSPI.this.ctx, true, OpenSSLContextSPI.this, host, port));
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                return new OpenSSLSocket(host, port, new OpenSSLEngine(OpenSSLContextSPI.this.ctx, true, OpenSSLContextSPI.this, host, port));
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                return new OpenSSLSocket(host, port, localHost, localPort, new OpenSSLEngine(OpenSSLContextSPI.this.ctx, true, OpenSSLContextSPI.this, host, port));
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                return new OpenSSLSocket(host, port, new OpenSSLEngine(OpenSSLContextSPI.this.ctx, true, OpenSSLContextSPI.this, host.getHostName(), port));
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                return new OpenSSLSocket(address, port, localAddress, localPort, new OpenSSLEngine(OpenSSLContextSPI.this.ctx, true, OpenSSLContextSPI.this, address.getHostName(), port));
            }
        };
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return new SSLServerSocketFactory(){

            @Override
            public String[] getDefaultCipherSuites() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return (String[])OpenSSLContextSPI.this.getCiphers().clone();
            }

            @Override
            public ServerSocket createServerSocket(int port) throws IOException {
                return new OpenSSLServerSocket(port, OpenSSLContextSPI.this);
            }

            @Override
            public ServerSocket createServerSocket(int port, int backlog) throws IOException {
                return new OpenSSLServerSocket(port, backlog, OpenSSLContextSPI.this);
            }

            @Override
            public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
                return new OpenSSLServerSocket(port, backlog, ifAddress, OpenSSLContextSPI.this);
            }
        };
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        return this.createSSLEngine(host, port);
    }

    @Override
    protected OpenSSLServerSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected OpenSSLClientSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    public void sessionRemoved(byte[] session) {
        this.serverSessionContext.remove(session);
    }

    static {
        try {
            X509_CERT_FACTORY = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class OpenSSLTLS_1_2_ContextSpi
    extends OpenSSLContextSPI {
        public OpenSSLTLS_1_2_ContextSpi() throws SSLException {
            super(16);
        }
    }

    public static final class OpenSSLTLS_1_1_ContextSpi
    extends OpenSSLContextSPI {
        public OpenSSLTLS_1_1_ContextSpi() throws SSLException {
            super(8);
        }
    }

    public static final class OpenSSLTLS_1_0_ContextSpi
    extends OpenSSLContextSPI {
        public OpenSSLTLS_1_0_ContextSpi() throws SSLException {
            super(4);
        }
    }

    public static final class OpenSSLTLSContextSpi
    extends OpenSSLContextSPI {
        public OpenSSLTLSContextSpi() throws SSLException {
            super(28);
        }
    }
}

