/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.manager;

import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.transaction.Transaction;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.persistence.support.BatchModification;
import org.reactivestreams.Publisher;

public interface PersistenceManager
extends Lifecycle {
    public boolean isEnabled();

    public boolean isPreloaded();

    public void preload();

    public void disableStore(String var1);

    public <T> Set<T> getStores(Class<T> var1);

    public Collection<String> getStoresAsString();

    public void purgeExpired();

    public void clearAllStores(Predicate<? super StoreConfiguration> var1);

    public boolean deleteFromAllStores(Object var1, int var2, Predicate<? super StoreConfiguration> var3);

    default public <K, V> Publisher<MarshalledEntry<K, V>> publishEntries(boolean fetchValue, boolean fetchMetadata) {
        return this.publishEntries(null, fetchValue, fetchMetadata, AccessMode.BOTH);
    }

    public <K, V> Publisher<MarshalledEntry<K, V>> publishEntries(Predicate<? super K> var1, boolean var2, boolean var3, Predicate<? super StoreConfiguration> var4);

    public <K, V> Publisher<MarshalledEntry<K, V>> publishEntries(IntSet var1, Predicate<? super K> var2, boolean var3, boolean var4, Predicate<? super StoreConfiguration> var5);

    public <K> Publisher<K> publishKeys(Predicate<? super K> var1, Predicate<? super StoreConfiguration> var2);

    public <K> Publisher<K> publishKeys(IntSet var1, Predicate<? super K> var2, Predicate<? super StoreConfiguration> var3);

    public MarshalledEntry loadFromAllStores(Object var1, boolean var2, boolean var3);

    default public MarshalledEntry loadFromAllStores(Object key, int segment, boolean localInvocation, boolean includeStores) {
        return this.loadFromAllStores(key, localInvocation, includeStores);
    }

    public AdvancedCacheLoader getStateTransferProvider();

    default public int size() {
        return this.size(AccessMode.BOTH);
    }

    public int size(Predicate<? super StoreConfiguration> var1);

    public int size(IntSet var1);

    public void setClearOnStop(boolean var1);

    public void writeToAllNonTxStores(MarshalledEntry var1, int var2, Predicate<? super StoreConfiguration> var3);

    public void writeToAllNonTxStores(MarshalledEntry var1, int var2, Predicate<? super StoreConfiguration> var3, long var4);

    public void prepareAllTxStores(Transaction var1, BatchModification var2, Predicate<? super StoreConfiguration> var3) throws PersistenceException;

    public void commitAllTxStores(Transaction var1, Predicate<? super StoreConfiguration> var2);

    public void rollbackAllTxStores(Transaction var1, Predicate<? super StoreConfiguration> var2);

    public void writeBatchToAllNonTxStores(Iterable<MarshalledEntry> var1, Predicate<? super StoreConfiguration> var2, long var3);

    public void deleteBatchFromAllNonTxStores(Iterable<Object> var1, Predicate<? super StoreConfiguration> var2, long var3);

    public boolean isAvailable();

    default public boolean addSegments(IntSet segments) {
        return true;
    }

    default public boolean removeSegments(IntSet segments) {
        return true;
    }

    public static enum AccessMode implements Predicate<StoreConfiguration>
    {
        BOTH{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return true;
            }
        }
        ,
        SHARED{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return configuration.shared();
            }
        }
        ,
        PRIVATE{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return !configuration.shared();
            }
        }
        ,
        ASYNC{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return configuration.async().enabled();
            }
        }
        ,
        NOT_ASYNC{

            @Override
            public boolean test(StoreConfiguration configuration) {
                return !configuration.async().enabled();
            }
        };

    }
}

