/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.routing;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.WebDeploymentConfiguration;
import org.wildfly.clustering.web.cache.routing.RouteLocatorServiceNameProvider;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocator;
import org.wildfly.clustering.web.infinispan.routing.PrimaryOwnerRouteLocatorConfiguration;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagementConfiguration;
import org.wildfly.clustering.web.routing.RouteLocator;

public class PrimaryOwnerRouteLocatorServiceConfigurator
extends RouteLocatorServiceNameProvider
implements CapabilityServiceConfigurator,
PrimaryOwnerRouteLocatorConfiguration,
Supplier<RouteLocator> {
    private final InfinispanSessionManagementConfiguration managementConfiguration;
    private final WebDeploymentConfiguration deploymentConfiguration;
    private volatile SupplierDependency<Registry<String, Void>> registry;
    private volatile SupplierDependency<Cache<String, ?>> cache;
    private volatile SupplierDependency<NodeFactory<Address>> factory;

    public PrimaryOwnerRouteLocatorServiceConfigurator(InfinispanSessionManagementConfiguration managementConfiguration, WebDeploymentConfiguration deploymentConfiguration) {
        super(deploymentConfiguration);
        this.managementConfiguration = managementConfiguration;
        this.deploymentConfiguration = deploymentConfiguration;
    }

    @Override
    public RouteLocator get() {
        return new PrimaryOwnerRouteLocator(this);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceBuilder builder = target.addService(name);
        Consumer locator = new CompositeDependency(new Dependency[]{this.registry, this.cache, this.factory}).register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(locator, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.registry = new ServiceSupplierDependency(ClusteringCacheRequirement.REGISTRY.getServiceName(support, this.managementConfiguration.getContainerName(), this.deploymentConfiguration.getServerName()));
        this.factory = new ServiceSupplierDependency(ClusteringCacheRequirement.GROUP.getServiceName(support, this.managementConfiguration.getContainerName(), this.deploymentConfiguration.getServerName()));
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.managementConfiguration.getContainerName(), this.deploymentConfiguration.getDeploymentName()));
        return this;
    }

    @Override
    public Registry<String, Void> getRegistry() {
        return (Registry)this.registry.get();
    }

    @Override
    public Cache<String, ?> getCache() {
        return (Cache)this.cache.get();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.factory.get();
    }
}

