/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public abstract class BasicTCP
extends TP
implements Receiver {
    @Property(description="Reaper interval in msec. Default is 0 (no reaping)")
    protected long reaper_interval = 0L;
    @Property(description="Max time connection can be idle before being reaped (in ms)")
    protected long conn_expire_time = 0L;
    @Property(description="Receiver buffer size in bytes")
    protected int recv_buf_size = 150000;
    @Property(description="Send buffer size in bytes")
    protected int send_buf_size = 150000;
    @Property(description="Max time allowed for a socket creation in connection table")
    protected int sock_conn_timeout = 2000;
    @Property(description="Max time to block on reading of peer address")
    protected int peer_addr_read_timeout = 1000;
    @Property(description="Should TCP no delay flag be turned on")
    protected boolean tcp_nodelay = true;
    @Property(description="SO_LINGER in msec. Default of -1 disables it")
    protected int linger = -1;
    @LocalAddress
    @Property(name="client_bind_addr", description="The address of a local network interface which should be used by client sockets to bind to. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.tcp.client_bind_addr"}, writable=false)
    protected InetAddress client_bind_addr;
    @Property(description="The local port a client socket should bind to. If 0, an ephemeral port will be picked.")
    protected int client_bind_port;
    @Property(description="If true, client sockets will not explicitly bind to bind_addr but will defer to the native socket")
    protected boolean defer_client_bind_addr;

    protected BasicTCP() {
    }

    @Override
    public boolean supportsMulticasting() {
        return false;
    }

    public long getReaperInterval() {
        return this.reaper_interval;
    }

    public void setReaperInterval(long interval) {
        this.reaper_interval = interval;
    }

    public BasicTCP reaperInterval(long interval) {
        this.reaper_interval = interval;
        return this;
    }

    public long getConnExpireTime() {
        return this.conn_expire_time;
    }

    public void setConnExpireTime(long time) {
        this.conn_expire_time = time;
    }

    public BasicTCP connExpireTime(long time) {
        this.conn_expire_time = time;
        return this;
    }

    @Override
    public void init() throws Exception {
        Discovery discovery_prot;
        super.init();
        if (this.bind_port <= 0 && (discovery_prot = (Discovery)this.stack.findProtocol((Class<? extends Protocol>)Discovery.class)) != null && !discovery_prot.isDynamic()) {
            throw new IllegalArgumentException("bind_port cannot be set to " + this.bind_port + ", as no dynamic discovery protocol (e.g. MPING or TCPGOSSIP) has been detected.");
        }
        if (this.reaper_interval > 0L || this.conn_expire_time > 0L) {
            if (this.conn_expire_time == 0L && this.reaper_interval > 0L) {
                this.log.warn("reaper interval (%d) set, but not conn_expire_time, disabling reaping", this.reaper_interval);
                this.reaper_interval = 0L;
            } else if (this.conn_expire_time > 0L && this.reaper_interval == 0L) {
                this.reaper_interval = this.conn_expire_time / 2L;
                this.log.warn("conn_expire_time (%d) is set but reaper_interval is 0; setting it to %d", this.conn_expire_time, this.reaper_interval);
            }
        }
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        this.sendToMembers(this.members, data, offset, length);
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        this.send(dest, data, offset, length);
    }

    @Override
    public String getInfo() {
        return String.format("connections: %s\n", this.printConnections());
    }

    public abstract String printConnections();

    public abstract void send(Address var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract void retainAll(Collection<Address> var1);

    @Override
    public void receive(Address sender, ByteBuffer buf) {
        Util.bufferToArray(sender, buf, this);
    }

    @Override
    protected Object handleDownEvent(Event evt) {
        Object ret = super.handleDownEvent(evt);
        if (evt.getType() == 6) {
            HashSet<Address> physical_mbrs = new HashSet<Address>();
            for (Address addr : this.members) {
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(addr);
                if (physical_addr == null) continue;
                physical_mbrs.add(physical_addr);
            }
            this.retainAll(physical_mbrs);
        }
        return ret;
    }
}

