/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.clustering.ee.Remover;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.Scheduler;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SessionExpirationScheduler
implements Scheduler {
    final Map<String, Future<?>> expirationFutures = new ConcurrentHashMap();
    final Remover<String> remover;
    private final ScheduledExecutorService executor;

    public SessionExpirationScheduler(Remover<String> remover) {
        this(remover, SessionExpirationScheduler.createScheduledExecutor(SessionExpirationScheduler.createThreadFactory()));
    }

    private static ThreadFactory createThreadFactory() {
        return AccessController.doPrivileged(new PrivilegedAction<ThreadFactory>(){

            @Override
            public ThreadFactory run() {
                return new JBossThreadFactory(new ThreadGroup(SessionExpirationScheduler.class.getSimpleName()), Boolean.FALSE, null, "%G - %t", null, null);
            }
        });
    }

    private static ScheduledExecutorService createScheduledExecutor(ThreadFactory factory) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, factory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return executor;
    }

    public SessionExpirationScheduler(Remover<String> remover, ScheduledExecutorService executor) {
        this.remover = remover;
        this.executor = executor;
    }

    @Override
    public void cancel(String sessionId) {
        Future<?> future = this.expirationFutures.remove(sessionId);
        if (future != null) {
            future.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        Duration maxInactiveInterval = metaData.getMaxInactiveInterval();
        if (!maxInactiveInterval.isZero()) {
            Instant lastAccessed = metaData.getLastAccessedTime();
            Duration delay = Duration.between(Instant.now(), lastAccessed.plus(maxInactiveInterval));
            Runnable task = () -> {
                try {
                    this.remover.remove((Object)sessionId);
                }
                finally {
                    this.expirationFutures.remove(sessionId);
                }
            };
            long seconds = !delay.isNegative() ? delay.getSeconds() + 1L : 0L;
            Logger.ROOT_LOGGER.tracef("Session %s will expire in %d sec", sessionId, seconds);
            Runnable runnable = task;
            synchronized (runnable) {
                this.expirationFutures.put(sessionId, this.executor.schedule(task, seconds, TimeUnit.SECONDS));
            }
        }
    }

    @Override
    public void close() {
        PrivilegedAction<Void> shutdownAction = () -> {
            this.executor.shutdown();
            return null;
        };
        WildFlySecurityManager.doUnchecked(shutdownAction);
        this.expirationFutures.values().forEach(future -> future.cancel(false));
        this.expirationFutures.values().stream().filter(future -> !future.isDone()).forEach(future -> {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        });
        this.expirationFutures.clear();
    }
}

