/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session.fine;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.hotrod.RemoteCacheEntryMutator;
import org.wildfly.clustering.marshalling.spi.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.cache.session.SessionAttributes;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.cache.session.fine.FineSessionAttributes;
import org.wildfly.clustering.web.hotrod.Logger;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.hotrod.session.fine.SessionAttributeNamesKey;
import org.wildfly.clustering.web.session.ImmutableSessionAttributes;

public class FineSessionAttributesFactory<V>
implements SessionAttributesFactory<Map<String, UUID>>,
BiFunction<SessionAttributeKey, V, Mutator> {
    private final RemoteCache<SessionAttributeNamesKey, Map<String, UUID>> namesCache;
    private final RemoteCache<SessionAttributeKey, V> attributeCache;
    private final Marshaller<Object, V> marshaller;
    private final Immutability immutability;
    private final CacheProperties properties;

    public FineSessionAttributesFactory(RemoteCache<SessionAttributeNamesKey, Map<String, UUID>> namesCache, RemoteCache<SessionAttributeKey, V> attributeCache, Marshaller<Object, V> marshaller, Immutability immutability, CacheProperties properties) {
        this.namesCache = namesCache;
        this.attributeCache = attributeCache;
        this.marshaller = marshaller;
        this.immutability = immutability;
        this.properties = properties;
    }

    @Override
    public Mutator apply(SessionAttributeKey key, V value) {
        return new RemoteCacheEntryMutator(this.attributeCache, (Object)key, value);
    }

    public Map<String, UUID> createValue(String id, Void context) {
        return Collections.emptyMap();
    }

    public Map<String, UUID> findValue(String id) {
        Map names = (Map)this.namesCache.get((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            for (Map.Entry nameEntry : names.entrySet()) {
                Object value = this.attributeCache.get((Object)new SessionAttributeKey(id, (UUID)nameEntry.getValue()));
                if (value != null) {
                    try {
                        this.marshaller.read(value);
                        continue;
                    }
                    catch (InvalidSerializedFormException e) {
                        Logger.ROOT_LOGGER.failedToActivateSessionAttribute(e, id, (String)nameEntry.getKey());
                    }
                } else {
                    Logger.ROOT_LOGGER.missingSessionAttributeCacheEntry(id, (String)nameEntry.getKey());
                }
                this.remove(id);
                return null;
            }
            return names;
        }
        return Collections.emptyMap();
    }

    public boolean remove(String id) {
        Map names = (Map)this.namesCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)new SessionAttributeNamesKey(id));
        if (names != null) {
            for (UUID attributeId : names.values()) {
                this.attributeCache.remove((Object)new SessionAttributeKey(id, attributeId));
            }
        }
        return true;
    }

    public SessionAttributes createSessionAttributes(String id, Map<String, UUID> names) {
        return new FineSessionAttributes((Object)new SessionAttributeNamesKey(id), names, this.namesCache, FineSessionAttributesFactory.getKeyFactory(id), (Map)this.attributeCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}), this.marshaller, (BiFunction)this, this.immutability, this.properties);
    }

    public ImmutableSessionAttributes createImmutableSessionAttributes(String id, Map<String, UUID> names) {
        return new FineImmutableSessionAttributes(names, FineSessionAttributesFactory.getKeyFactory(id), this.attributeCache, this.marshaller);
    }

    private static Function<UUID, SessionAttributeKey> getKeyFactory(final String id) {
        return new Function<UUID, SessionAttributeKey>(){

            @Override
            public SessionAttributeKey apply(UUID attributeId) {
                return new SessionAttributeKey(id, attributeId);
            }
        };
    }
}

